/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl.scanresult;

import chemaxon.jchem.cartridge.rmi.KilledTaskException;
import chemaxon.jchem.cartridge.rmi.impl.EvalTableScannerImpl;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.rmi.impl.scanresult.TableScanBaseImpl;
import chemaxon.jchem.cartridge.tunnel.EvalChemTermInfo;
import chemaxon.jchem.cartridge.tunnel.TableScanInfo;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import chemaxon.util.hitfinder.HitFinderController;
import chemaxon.util.hitfinder.HitFinderFactory;
import chemaxon.util.hitfinder.HitFinderInput;
import chemaxon.util.hitfinder.HitFinderInputProducer;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EvaluatorScan
extends TableScanBaseImpl {
    private static final Logger logger = Logger.getLogger(EvalTableScannerImpl.class.getName());
    private EvalChemTermInfo tableScanInfo;
    private int resultChunkSize;
    private ConnectionHandler ch;
    private volatile PreparedStatement psReadOrigStruct;
    private PreparedStatement psCdSmilesLoader;
    private ResultSet rsMolReader;
    private HitFinderFactory<String> hitFinderFactory;
    private HitFinderController<String> hitFinderCtl;

    public EvaluatorScan(TableScanInfo tableScanInfo, HitFinderFactory<String> hitFinderFactory, int resultChunkSize) throws Exception {
        super(tableScanInfo);
        this.tableScanInfo = (EvalChemTermInfo)tableScanInfo;
        this.hitFinderFactory = hitFinderFactory;
        this.resultChunkSize = resultChunkSize;
        this.init();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("EvalTableScanResultImpl constructed");
        }
    }

    private void init() throws Exception {
        this.ch = EvalTableScannerImpl.getCm().createConnectionHandler(this.tableScanInfo.getSessionInfo(), this.tableScanInfo.getJcpropTableName(), true);
        try {
            Connection conn = this.ch.getConnection();
            conn.setAutoCommit(false);
            String stmt = "select cd_id, cd_smiles from " + this.tableScanInfo.getIndexTableQName();
            this.psCdSmilesLoader = conn.prepareStatement(stmt);
            this.rsMolReader = this.psCdSmilesLoader.executeQuery();
            this.createStartWorkerController();
        }
        catch (Throwable throwable) {
            block4: {
                try {
                    this.ch.close();
                }
                catch (Throwable throwable2) {
                    if (!logger.isLoggable(Level.SEVERE)) break block4;
                    logger.log(Level.SEVERE, "error", throwable2);
                }
            }
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }

    private void createStartWorkerController() throws IOException {
        this.hitFinderCtl = new HitFinderController<String>(this.getThreadCount("evaluator.scan.thread.count"), new HitFinderInputProducer<String>(){

            @Override
            public HitFinderInput<String> getNextInput() throws Exception {
                return EvaluatorScan.this.getNextInput();
            }
        }, this.hitFinderFactory);
        this.hitFinderCtl.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void dispose() throws Exception {
        Throwable error = null;
        try {
            super.dispose();
        }
        finally {
            try {
                if (this.hitFinderCtl != null) {
                    this.hitFinderCtl.stop();
                    this.hitFinderCtl = null;
                }
            }
            catch (Throwable throwable) {
                error = throwable;
            }
            finally {
                block29: {
                    try {
                        this.cleanUpConnection();
                    }
                    catch (Throwable throwable) {
                        if (error != null) break block29;
                        error = throwable;
                    }
                }
            }
        }
        if (error != null) {
            throw new ExecutionException(error);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("disposed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpConnection() throws SQLException {
        try {
            if (this.rsMolReader != null) {
                this.rsMolReader.close();
                this.rsMolReader = null;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("rsMolReader closed");
            }
        }
        finally {
            try {
                if (this.psCdSmilesLoader != null) {
                    this.psCdSmilesLoader.close();
                    this.psCdSmilesLoader = null;
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("psCdSmilesLoader closed");
                }
            }
            finally {
                try {
                    if (this.psReadOrigStruct != null) {
                        this.psReadOrigStruct.close();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("psReadOrigStruct closed");
                        }
                        this.psReadOrigStruct = null;
                    } else if (logger.isLoggable(Level.FINER)) {
                        logger.finer("psReadOrigStruct was null");
                    }
                }
                finally {
                    this.ch.close();
                }
            }
        }
    }

    @Override
    protected int[] getNextHits0() throws RemoteException, DatabaseSearchException, InterruptedException {
        try {
            int[] hits = this.hitFinderCtl.getAvailableNewHits(this.resultChunkSize);
            return hits == null || hits.length == 0 ? null : hits;
        }
        catch (DatabaseSearchException dbse) {
            if (dbse.getCause() != null && dbse.getCause() instanceof CancellationException) {
                throw new KilledTaskException("Task has been killed");
            }
            throw dbse;
        }
    }

    private HitFinderInput<String> getNextInput() throws Exception {
        if (!this.rsMolReader.next()) {
            return null;
        }
        int cdId = this.rsMolReader.getInt(1);
        String smiles = this.rsMolReader.getString(2);
        if (smiles == null) {
            if (this.psReadOrigStruct == null) {
                String baseTblQName = this.tableScanInfo.getBaseSchemaName() + "." + this.tableScanInfo.getBaseTableName();
                this.psReadOrigStruct = EvaluatorScan.createPsReadOrigStruct(this.ch.getConnection(), baseTblQName, this.tableScanInfo.getIndexTableQName(), this.tableScanInfo.isJchemTable(), this.tableScanInfo.getIndexedColumn());
            }
            smiles = EvaluatorScan.readStandarOrigStruct(this.psReadOrigStruct, cdId);
        }
        return new HitFinderInput<String>(cdId, smiles);
    }

    public static String readStandarOrigStruct(PreparedStatement ps, int cdId) throws Exception {
        ResultSet rset = null;
        ps.setInt(1, cdId);
        rset = ps.executeQuery();
        rset.next();
        byte[] bytes = DatabaseTools.readBytes(rset, 1);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new String(bytes, "ASCII");
    }

    public static PreparedStatement createPsReadOrigStruct(Connection conn, String baseTableName, String idxTblQName, boolean isJChemTable, String colName) throws Exception {
        String stmt = null;
        stmt = isJChemTable ? "SELECT cd_structure FROM " + baseTableName + " WHERE cd_id = ?" : "SELECT " + colName + " FROM " + baseTableName + " WHERE ROWID = (SELECT rid FROM " + idxTblQName + " WHERE cd_id = ?)";
        return conn.prepareStatement(stmt);
    }
}

