/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.server;

import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.util.RuntimeUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Bootstrapper {
    private static final Logger logger = Logger.getLogger(Bootstrapper.class.getName());
    private static final Bootstrapper instance = new Bootstrapper();
    private volatile RuntimeUtils.Procezz serverProcezz;
    private volatile boolean serverProcezzFinishing;
    private int exitCode = -1;

    public void waitForServerProcezzAsynch() {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Bootstrapper.this.exitCode = Bootstrapper.this.serverProcezz.waitFor();
                }
                catch (InterruptedException e) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.log(Level.INFO, "Interrupted, killing server process", e);
                    }
                    Bootstrapper.this.exitCode = 1;
                    Bootstrapper.this.serverProcezz.destroy();
                }
                finally {
                    Bootstrapper.this.serverProcezz = null;
                }
            }
        };
        t.start();
    }

    public int waitForServerProcezz() throws InterruptedException {
        if (this.serverProcezz == null) {
            return 0;
        }
        int exitCode = this.serverProcezz.waitFor();
        this.serverProcezz = null;
        return exitCode;
    }

    public boolean isServerProcezzFinishing() {
        boolean l = this.serverProcezzFinishing;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("returning " + l);
        }
        return l;
    }

    public boolean isServerProcezzFinished() {
        boolean l;
        boolean bl = l = this.serverProcezz == null;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("returning " + l);
        }
        return l;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public synchronized void destroy() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getInstance().isManagedFinishing()=" + this.isServerProcezzFinishing() + ",getInstance().isManagedFinished()" + this.isServerProcezzFinished());
        }
        if (this.isServerProcezzFinishing() || this.isServerProcezzFinished()) {
            return;
        }
        this.serverProcezzFinishing = true;
        if (this.serverProcezz != null) {
            this.serverProcezz.destroy();
        }
    }

    private static String getServerProperty(String key) throws IOException {
        return JccConfig.getInstance().getProperty(key);
    }

    private static String getLogConfigClassName() {
        return "chemaxon.jchem.cartridge.util.LoggingConfigurator";
    }

    private static void initLogConfig() throws SecurityException, IOException {
        System.setProperty("java.util.logging.config.class", Bootstrapper.getLogConfigClassName());
        LogManager.getLogManager().readConfiguration();
    }

    public void serverControl(String jchemHome, String command) throws IOException, InterruptedException {
        this.serverControl(new File(jchemHome), null, command);
    }

    public void serverControl(File jchemHome, File workDir, String command) throws IOException, InterruptedException {
        String javaHeapSize;
        String jchemHomeStr;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("server control command: " + command + ", jchemHome: " + jchemHome + ", current working directory: " + workDir);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "debug stack", new Exception());
        }
        if (workDir == null) {
            workDir = new File(System.getProperty("user.dir"));
        }
        if (jchemHome == null && (jchemHomeStr = System.getProperty("chemaxon.jchem.home")) != null) {
            jchemHome = new File(jchemHomeStr);
        }
        if (jchemHome == null) {
            jchemHome = workDir.getParentFile();
        }
        this.removeIgnoredProperties(command);
        ArrayList<String> argList = new ArrayList<String>();
        String javaHome = Bootstrapper.getServerProperty("java.home");
        if (javaHome == null || javaHome.length() == 0) {
            javaHome = RuntimeUtils.getEnvVar("JAVA_HOME");
        }
        if (javaHome == null || javaHome.length() == 0) {
            javaHome = System.getProperty("java.home");
        }
        if (javaHome == null || javaHome.length() == 0) {
            throw new RuntimeException("Java home could not be determined");
        }
        String javaExeBaseName = "java";
        if (RuntimeUtils.isWindows()) {
            javaExeBaseName = "javaw.exe";
            this.testServerMode(javaHome + File.separator + "bin" + File.separator + "java.exe");
        }
        argList.add(javaHome + File.separator + "bin" + File.separator + javaExeBaseName);
        argList.add("-server");
        if (RuntimeUtils.isWindows()) {
            argList.add("-Xrs");
        }
        if ((javaHeapSize = Bootstrapper.getServerProperty("jcserver.maxmem")) == null || javaHeapSize.length() == 0) {
            javaHeapSize = RuntimeUtils.getEnvVar("JAVA_HEAP_SIZE");
        }
        if (javaHeapSize == null || javaHeapSize.length() == 0) {
            throw new RuntimeException("Either the JAVA_HEAP_SIZE environment variable or the jcserver.maxmem property should be set.");
        }
        argList.add("-Xms" + javaHeapSize);
        argList.add("-Xmx" + javaHeapSize);
        Bootstrapper.addXXOptions(argList);
        Bootstrapper.addMiscOptions(argList);
        String serverConfigFilePath = System.getProperty("chemaxon.jchem.cartridge.config.file");
        File serverConfigFile = null;
        if (serverConfigFilePath == null) {
            File confDir = new File(workDir, "conf");
            serverConfigFile = new File(confDir, "jcart.properties");
        } else {
            serverConfigFile = new File(serverConfigFilePath);
        }
        argList.add("-Dchemaxon.jchem.cartridge.config.file=" + serverConfigFile.getCanonicalPath());
        argList.add("-Djava.util.logging.config.class=" + Bootstrapper.getLogConfigClassName());
        argList.add("-Djava.awt.headless=true");
        Bootstrapper.addMiscSysProps(argList);
        argList.add("-classpath");
        argList.add(Bootstrapper.createClasspath(jchemHome));
        argList.add("chemaxon.jchem.cartridge.rmi.impl.AdminImpl");
        argList.add("--no-pwprompt");
        argList.add(command);
        String[] cmdarray = new String[argList.size()];
        argList.toArray(cmdarray);
        boolean startCommand = command.equals("start");
        if (startCommand && !this.isServerProcezzFinished()) {
            throw new IllegalArgumentException("Server process already running.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(command + "-ing server process...");
        }
        RuntimeUtils.Procezz pz = RuntimeUtils.startProcess(cmdarray, workDir, System.out, System.err);
        if (startCommand) {
            this.serverProcezz = pz;
            this.serverProcezzFinishing = false;
        } else {
            pz.waitFor();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Server process " + command + "-ed.");
        }
    }

    private void testServerMode(String javaExecutable) throws IOException, InterruptedException {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(javaExecutable);
        argList.add("-server");
        argList.add("-version");
        String[] cmdarray = new String[argList.size()];
        argList.toArray(cmdarray);
        RuntimeUtils.Procezz pz = RuntimeUtils.startProcess(cmdarray, null, System.out, System.err);
        if (pz.waitFor() != 0) {
            throw new IllegalArgumentException("No server mode for " + (String)argList.get(0));
        }
    }

    private void removeIgnoredProperties(String command) throws IOException {
        String IGNORE_PROP = "ignore.properties.for.";
        ArrayList<String> propsToRemove = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : JccConfig.getInstance().entrySet()) {
            String icmd;
            String key = (String)entry.getKey();
            if (!key.startsWith("ignore.properties.for.") || !(icmd = key.substring("ignore.properties.for.".length())).equals(command)) continue;
            StringTokenizer stok = new StringTokenizer((String)entry.getValue(), ",");
            while (stok.hasMoreTokens()) {
                propsToRemove.add(stok.nextToken());
            }
        }
        for (String propName : propsToRemove) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removing property for " + command + ": " + propName);
            }
            JccConfig.getInstance().remove(propName);
        }
    }

    private static void addMiscSysProps(ArrayList<String> argList) throws IOException {
        String sysPropPrefix = "sysprop.";
        JccConfig serverProps = JccConfig.getInstance();
        Enumeration<?> e = serverProps.propertyNames();
        while (e.hasMoreElements()) {
            String pname = (String)e.nextElement();
            if (!pname.startsWith("sysprop.")) continue;
            argList.add("-D" + pname.substring("sysprop.".length()) + "=" + serverProps.getProperty(pname));
        }
    }

    private static void addXXOptions(ArrayList<String> argList) throws IOException {
        String xxOptPrefix = "xx.opt.";
        JccConfig serverProps = JccConfig.getInstance();
        Enumeration<?> e = serverProps.propertyNames();
        while (e.hasMoreElements()) {
            String pname = (String)e.nextElement();
            if (!pname.startsWith("xx.opt.")) continue;
            String optString = "-XX:" + pname.substring("xx.opt.".length());
            String pvalue = serverProps.getProperty(pname);
            if (pvalue != null && pvalue.trim().length() > 0) {
                optString = optString + "=" + pvalue;
            }
            argList.add(optString);
        }
    }

    private static void addMiscOptions(ArrayList<String> argList) throws IOException {
        String optPrefix = "misc.opt.";
        JccConfig serverProps = JccConfig.getInstance();
        Enumeration<?> e = serverProps.propertyNames();
        while (e.hasMoreElements()) {
            String pname = (String)e.nextElement();
            if (!pname.startsWith("misc.opt.")) continue;
            String optString = pname.substring("misc.opt.".length());
            String pvalue = serverProps.getProperty(pname);
            if (pvalue != null && pvalue.trim().length() > 0) {
                optString = optString + "=" + pvalue;
            }
            argList.add(optString);
        }
    }

    private static String createClasspath(File jchemHome) throws IOException {
        StringBuffer cp = new StringBuffer();
        cp.append(Bootstrapper.getJChemJarPath(jchemHome).getCanonicalPath());
        try {
            Class.forName("oracle.jdbc.OracleDriver");
        }
        catch (ClassNotFoundException cnf) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("No Oracle JDBC driver found on classpath");
            }
            Bootstrapper.appendJdbcDriverPath(cp);
        }
        String xclasspath = Bootstrapper.getServerProperty("xclasspath");
        if (xclasspath != null) {
            cp.append(File.pathSeparator).append(xclasspath);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Using classpath: " + cp.toString());
        }
        return cp.toString();
    }

    private static void appendJdbcDriverPath(StringBuffer cp) throws IOException {
        String jdbcDriverPath = Bootstrapper.getServerProperty("jdbc.driver.path");
        String oracleHomeS = Bootstrapper.getServerProperty("oracle.home");
        if (oracleHomeS == null || oracleHomeS.length() == 0) {
            oracleHomeS = System.getProperty("oracle.home");
        }
        if (jdbcDriverPath == null || jdbcDriverPath.length() == 0) {
            if (oracleHomeS == null || oracleHomeS.length() == 0) {
                oracleHomeS = RuntimeUtils.getEnvVar("ORACLE_HOME");
            }
            if (oracleHomeS == null || oracleHomeS.length() == 0) {
                throw new RuntimeException("Either the ORACLE_HOME environment variable or the oracle.home property must be set");
            }
            File oracleHome = new File(oracleHomeS);
            File oraJdbcDir = new File(oracleHome, "jdbc");
            File jdbcLibDir = new File(oraJdbcDir, "lib");
            if (!jdbcLibDir.isDirectory()) {
                throw new RuntimeException(jdbcLibDir + " doesn't exist or is not a directory");
            }
            File ojdbc5 = new File(jdbcLibDir, "ojdbc5.jar");
            File ojdbc14 = new File(jdbcLibDir, "ojdbc14.jar");
            File jdbcFile = null;
            if (ojdbc5.isFile()) {
                jdbcFile = ojdbc5;
            } else if (ojdbc14.isFile()) {
                jdbcFile = ojdbc14;
            } else {
                throw new RuntimeException("Neither " + ojdbc5.getCanonicalPath() + " nor " + ojdbc14.getCanonicalPath() + " exists");
            }
            jdbcDriverPath = jdbcFile.getCanonicalPath();
        }
        cp.append(File.pathSeparator).append(jdbcDriverPath);
    }

    private static File getJChemJarPath(File jchemHome) throws IOException {
        File jchemJar = null;
        File jclib = new File(jchemHome, "lib");
        jchemJar = new File(jclib, "jchem.jar");
        if (!jchemJar.exists()) {
            throw new RuntimeException("No such file: " + jchemJar.getCanonicalPath() + ".");
        }
        return jchemJar;
    }

    public static Bootstrapper getInstance() {
        return instance;
    }

    public static void main(String[] args) {
        int childExitValue = 0;
        try {
            Bootstrapper.initLogConfig();
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Server control process started");
            }
            String serverWorkingDirectoryPath = System.getProperty("user.dir");
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (!arg.equals("--srv-work-dir")) continue;
                serverWorkingDirectoryPath = args[++i];
            }
            String cmd = "start";
            if (args.length > 0) {
                cmd = args[args.length - 1];
            }
            File serverWorkingDirectory = new File(serverWorkingDirectoryPath).getCanonicalFile();
            Bootstrapper.getInstance().serverControl(null, serverWorkingDirectory, cmd);
            int exitValue = Bootstrapper.getInstance().waitForServerProcezz();
            if (exitValue != 0) {
                childExitValue = exitValue;
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Server process exited with code: " + exitValue);
                }
            }
        }
        catch (Throwable throwable) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "error", throwable);
            }
            int myExitValue = 1;
            if (childExitValue != 0) {
                myExitValue = childExitValue;
            }
            System.exit(myExitValue);
        }
    }
}

