/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.server.task;

import chemaxon.jchem.cartridge.server.task.Resource;
import chemaxon.jchem.cartridge.server.task.ResourceTimer;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceTimerImpl
implements ResourceTimer {
    private static final Logger logger = Logger.getLogger(ResourceTimerImpl.class.getName());
    private Timer timer = new Timer(true);
    private Resource resource;
    private Date lastRescheduleDate;
    private int idleTimeout;
    private volatile TimerTask currentTask;

    public ResourceTimerImpl(Resource resource, int idleTimeout) throws IOException {
        this.resource = resource;
        if (idleTimeout <= 0) {
            throw new IllegalArgumentException("Invalid timeout value: " + idleTimeout);
        }
        this.idleTimeout = idleTimeout;
        this.scheduleForTimeout();
    }

    private void scheduleForTimeout() {
        if (this.currentTask != null) {
            throw new IllegalStateException(this + " has a pending timer task");
        }
        this.currentTask = new TimerTask(){

            @Override
            public void run() {
                block4: {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Timer (timeout=" + ResourceTimerImpl.this.idleTimeout + " for " + ResourceTimerImpl.this.resource + " expired!");
                    }
                    try {
                        ResourceTimerImpl.this.resource.dispose();
                        if (logger.isLoggable(Level.INFO)) {
                            logger.info(ResourceTimerImpl.this.resource + " disposed as a result of timeout.");
                        }
                    }
                    catch (Throwable throwable) {
                        if (!logger.isLoggable(Level.SEVERE)) break block4;
                        logger.log(Level.SEVERE, "Error while disposing " + ResourceTimerImpl.this.resource, throwable);
                    }
                }
            }
        };
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Scheduling timer task for " + this.resource + " for " + this.idleTimeout + " seconds...");
        }
        this.timer.schedule(this.currentTask, this.idleTimeout * 1000);
        this.lastRescheduleDate = GregorianCalendar.getInstance().getTime();
    }

    private synchronized void touch(boolean reschedule) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Trying to cancel timer task for " + this.resource + " (reschedule=" + reschedule + ")...");
        }
        if (this.currentTask == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + " has no pending timer tasks anymore");
            }
            if (reschedule) {
                throw new IllegalStateException("Results are already unavailable (possibly due to idle timeout)");
            }
            return;
        }
        this.currentTask.cancel();
        this.currentTask = null;
        if (reschedule) {
            this.scheduleForTimeout();
            return;
        }
    }

    @Override
    public void touch() {
        this.touch(true);
    }

    @Override
    public void cancel() {
        this.touch(false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("lastRescheduled=").append(this.lastRescheduleDate);
        sb.append(", timeout=").append(this.idleTimeout);
        return sb.toString();
    }

    @Override
    public Integer getTimeout() {
        return this.idleTimeout;
    }

    @Override
    public synchronized Date getLastRescheduleDate() {
        return this.lastRescheduleDate;
    }
}

