/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets;

import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.rmi.JccSecurityException;
import chemaxon.jchem.cartridge.tunnel.ExUserInfo;
import chemaxon.jchem.cartridge.tunnel.UserInfo;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.jchem.cartridge.util.cpool.JCartDataSource;
import chemaxon.jchem.cartridge.util.cpool.Ora9iDataSource;
import chemaxon.jchem.cartridge.util.cpool.Oracle10gDataSource;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.StringConverter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCartConnectionManager {
    private static Logger logger = Logger.getLogger(JCartConnectionManager.class.getName());
    private static final Logger setPwLogger = Logger.getLogger("chemaxon.jchem.cartridge.setPw");
    private static final Logger sqlLogger = Logger.getLogger("x.chemaxon.jchem.cartridge.sqlLogger");
    private Hashtable<String, String> userPasswords = new Hashtable();
    private Hashtable<String, JCartDataSource> userConnPoolMap = new Hashtable();
    private static JCartConnectionManager instance = new JCartConnectionManager();

    private JCartConnectionManager() {
    }

    public static JCartConnectionManager getInstance() {
        return instance;
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.getDefaultConnection();
        }
        catch (SQLException sqlException) {
            throw sqlException;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Connection getConnection(UserInfo userInfo) throws SQLException {
        String login = StringConverter.megfejt(userInfo.getUserName());
        String password = StringConverter.megfejt(userInfo.getPassword());
        return this.getConnection(login, password);
    }

    public Connection getConnection(String login, String password) throws SQLException {
        try {
            return this.getConnectionUc(login, password, null);
        }
        catch (SQLException sqlException) {
            throw sqlException;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Connection getConnectionUc(String login, String password, Callable<Object> xValidation) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("login=" + login + ", xValidation=" + xValidation);
        }
        if (login == null) {
            return this.getDefaultConnection();
        }
        this.checkAllowedToChange(login);
        if (password == null) {
            if (this.isPasswordAlwaysRequired()) {
                throw new JccSecurityException("Requests must include password");
            }
            String cachedPwd = this.userPasswords.get(login);
            if (cachedPwd == null) {
                return this.getDefaultConnection();
            }
            return this.getConnectionFromCache(login, password);
        }
        String cachedPwd = this.userPasswords.get(login);
        if (cachedPwd == null || !cachedPwd.equals(password)) {
            this.validateCredentials(login, password);
            this.xValidate(xValidation);
            if (cachedPwd != null) {
                this.getOraCache(login).resetPassword(password);
            }
            this.userPasswords.put(login, password);
            if (setPwLogger.isLoggable(Level.FINE)) {
                setPwLogger.fine("Password set for " + login);
            }
        }
        return this.getConnectionFromCache(login, password);
    }

    private void xValidate(Callable<Object> xValidatation) throws Exception {
        if (xValidatation == null) {
            return;
        }
        JccConfig config = JccConfig.getInstance();
        if (config.getBoolean("skip.conn.config.sanity.check", false)) {
            return;
        }
        xValidatation.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCredentials(String login, String password) throws SQLException, IOException {
        Connection c = JCartConnectionManager.createConnectionByDriverManager(login, password);
        try {
            Statement stmt = c.createStatement();
            ResultSet rs = stmt.executeQuery("select sysdate from dual");
            rs.next();
            rs.close();
        }
        finally {
            c.close();
        }
    }

    private static String getDbUrl() throws IOException {
        String url = JccConfig.getInstance().getUrl();
        if (url == null) {
            throw new JccSecurityException("Please, check the \"oracle.server.xxx\" settings for JChemServer.");
        }
        return url;
    }

    private Connection getDefaultConnection() throws Exception {
        boolean suForbidden = false;
        JccConfig props = JccConfig.getInstance();
        String suForbiddenStr = props.getFallbackOnSuperUser();
        boolean bl = suForbidden = suForbiddenStr != null && suForbiddenStr.equals("false");
        if (suForbidden) {
            throw new JccSecurityException("Default user disabled");
        }
        String login = props.getProperty("oracle.server.login");
        if (login == null) {
            throw new JccSecurityException("Missing credential(s).Either jchem_core_pkg.use_password(...) must be called or oracle.server.login must be set. (See http://www.chemaxon.com/jchem/doc/admin/cartridge.html#jcserver_dbaccess_credentials)");
        }
        login = StringConverter.megfejt(login);
        String pass = props.getProperty("oracle.server.password");
        if (pass == null) {
            throw new JccSecurityException("oracle.server.password must be set for default user.");
        }
        pass = StringConverter.megfejt(pass);
        return this.getConnectionFromCache(login, pass);
    }

    private boolean isPasswordAlwaysRequired() throws IOException {
        JccConfig config = JccConfig.getInstance();
        return config.getBoolean("password.always.required", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnectionFromCache(String login, String password) throws Exception {
        JCartDataSource oraCache;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("login=" + login);
        }
        if (login.equalsIgnoreCase("sys")) {
            login = "sys as sysdba";
        }
        if ((oraCache = this.getOraCache(login)) == null) {
            oraCache = this.createJCartDataSource(JCartConnectionManager.getDbUrl(), login, password);
            this.userConnPoolMap.put(login.toUpperCase(), oraCache);
        }
        Connection connection = oraCache.getConnection();
        connection.setAutoCommit(false);
        if (logger.isLoggable(Level.FINER)) {
            String sql = "SELECT userenv('SESSIONID') FROM dual";
            Statement stmt = connection.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                logger.finer("SESSIONID=" + rs.getString(1));
            }
            finally {
                stmt.close();
            }
        }
        return connection;
    }

    private JCartDataSource createJCartDataSource(String url, String login, String password) throws Exception {
        String dataSourceImpl = JccConfig.getInstance().getProperty("connection.cached.pool.impl");
        JCartDataSource jccDataSource = null;
        if (dataSourceImpl == null) {
            try {
                jccDataSource = new Oracle10gDataSource(url, login, password);
            }
            catch (NoSuchMethodError nsme) {
                jccDataSource = new Ora9iDataSource(url, login, password);
            }
        } else {
            Class<?> clazz = Class.forName(dataSourceImpl);
            Constructor<?> cons = clazz.getConstructor(String.class, String.class, String.class);
            jccDataSource = (JCartDataSource)cons.newInstance(url, login, password);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Using " + jccDataSource.getClass().getName());
        }
        return jccDataSource;
    }

    public synchronized void reset() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Resetting Oracle cached connection pools...");
        }
        Iterator<JCartDataSource> iterator = this.userConnPoolMap.values().iterator();
        while (iterator.hasNext()) {
            JCartDataSource oraPool = iterator.next();
            try {
                oraPool.close();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            iterator.remove();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Singleton of " + this.getClass().getName() + " has been reset");
        }
    }

    public ConnectionHandler createConnectionHandler(UserInfo userInfo) throws Exception {
        return this.createConnectionHandler(userInfo, null, false);
    }

    public ConnectionHandler createConnectionHandler(UserInfo userInfo, String jchemPropertiesTable, boolean connect) throws Exception {
        String login = StringConverter.megfejt(userInfo.getUserName());
        String password = StringConverter.megfejt(userInfo.getPassword());
        ConnectionHandler ch = new ConnectionHandler();
        if (connect) {
            ch.setConnection(this.getConnection(login, password));
        }
        ch.setUrl(JCartConnectionManager.getDbUrl());
        ch.setLoginName(login);
        ch.setPassword(password);
        ch.setPropertyTable(jchemPropertiesTable);
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnectionSanity(UserInfo userInfo) throws Exception {
        String login = StringConverter.megfejt(userInfo.getUserName());
        String password = StringConverter.megfejt(userInfo.getPassword());
        this.hostPreCheck();
        Connection c = JCartConnectionManager.createConnectionByDriverManager(login, password);
        try {
            Statement stmt = c.createStatement();
            ResultSet rs = stmt.executeQuery("select sysdate from dual");
            this.checkHostAndInstance(c, userInfo);
        }
        finally {
            c.close();
        }
    }

    private static Connection createConnectionByDriverManager(String login, String password) throws SQLException, IOException {
        try {
            Class.forName("oracle.jdbc.OracleDriver");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("Could not load JDBC driver class: oracle.jdbc.OracleDriver");
        }
        String url = JCartConnectionManager.getDbUrl();
        try {
            return DriverManager.getConnection(url, login, password);
        }
        catch (SQLException sqlE) {
            if (sqlE.getErrorCode() == 1017) {
                throw new JccSecurityException(sqlE.getMessage());
            }
            throw new SQLException("Problem connecting to the followingJDBC URL: " + url + ": " + sqlE.getMessage() + ". Please, check " + "the JDBC connection properties of the JChem Server.");
        }
    }

    private void hostPreCheck() throws IOException, ServerNotActiveException {
        if (JccConfig.getInstance().getProperty("url") == null) {
            JccConfig serverProps = JccConfig.getInstance();
            String propHost = serverProps.getProperty("oracle.server.host");
            String clientHost = UnicastRemoteObject.getClientHost();
            InetAddress propHostAddr = InetAddress.getByName(propHost);
            InetAddress clientHostAddr = InetAddress.getByName(clientHost);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("propHostAddr=" + propHostAddr + ", clientHostAddr=" + clientHostAddr);
            }
            if (!(propHostAddr.equals(clientHostAddr) || propHostAddr.isLoopbackAddress() && clientHostAddr.isSiteLocalAddress() || clientHostAddr.isLoopbackAddress() && propHostAddr.isSiteLocalAddress())) {
                throw new RuntimeException("Inconsistent oracle.server.host setting for JChemServer: " + propHost + " resolves to " + propHostAddr + ", but client oracle server is hosted on " + clientHost + " (which resolves to " + clientHostAddr + ")");
            }
        }
    }

    private void checkHostAndInstance(Connection c, UserInfo userInfo) throws Exception {
        if (userInfo instanceof ExUserInfo) {
            JcMetaDataFunctions metaData;
            String[] outgoing;
            String host = JccConfig.getInstance().getProperty("oracle.server.host");
            if (host == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("oracle.server.host not set. Assuming url has been set for Oracle RAC...");
                }
                return;
            }
            ExUserInfo exUserInfo = (ExUserInfo)userInfo;
            String incomingHost = exUserInfo.getHostName();
            if (incomingHost != null && (outgoing = (metaData = new JcMetaDataFunctions(new ClientSideSession(c))).getHostAndInstanceName()) != null) {
                String incomingInstance = exUserInfo.getInstanceName();
                String outgoingHost = outgoing[0];
                String outgoingInstance = outgoing[1];
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Incoming connection from [host=" + incomingHost + ", instance=" + incomingInstance + "] / outgoing connection to [host=" + outgoingHost + ", instance=" + outgoingInstance + "]");
                }
                if (!incomingHost.equals(outgoingHost) || !incomingInstance.equals(outgoingInstance)) {
                    throw new RuntimeException("Please, check the oracle.server.host and oracle.server.instance setting for JChemServer. (Incoming connection from [host=" + incomingHost + ", instance=" + incomingInstance + "] / outgoing connection to [host=" + outgoingHost + ", instance=" + outgoingInstance + "]");
                }
                return;
            }
        }
    }

    private void checkAllowedToChange(String login) throws IOException {
        JccConfig jccConfig = JccConfig.getInstance();
        String key = "allowed.to.specify.credentials";
        String separator = ",";
        String allowedToSpecCredList = jccConfig.getProperty(key);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Checking " + login + " in " + allowedToSpecCredList);
        }
        if (allowedToSpecCredList == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(allowedToSpecCredList, separator);
        while (tok.hasMoreTokens()) {
            String e = tok.nextToken().toUpperCase();
            if (!e.equals(login.toUpperCase())) continue;
            return;
        }
        throw new JccSecurityException("Not in the " + key + " list.");
    }

    public synchronized void changeUserInfo(final UserInfo userInfo) throws Exception {
        if (userInfo.getPassword() != null && setPwLogger.isLoggable(Level.FINE)) {
            setPwLogger.fine("Attempt to set password for " + userInfo.getUserName());
        }
        this.checkAllowedToChange(userInfo.getUserName());
        if (userInfo.getUserName() == null) {
            throw new JccSecurityException("Login not specified");
        }
        if (userInfo.getPassword() == null) {
            throw new JccSecurityException("Password not specified");
        }
        String login = StringConverter.megfejt(userInfo.getUserName());
        String oldPassword = this.userPasswords.get(login);
        String password = StringConverter.megfejt(userInfo.getPassword());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("userName='" + login + "'");
        }
        if (password.equals(oldPassword)) {
            return;
        }
        userInfo.setUserName(login);
        userInfo.setPassword(password);
        Connection conn = this.getConnectionUc(login, password, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JCartConnectionManager.this.checkConnectionSanity(userInfo);
                return null;
            }
        });
        conn.close();
    }

    public void reinitializeAll() throws Exception {
        Iterator<JCartDataSource> iterator = this.userConnPoolMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().reinitialize();
        }
    }

    public void reinitialize(String userName) throws Exception {
        JCartDataSource jcds = this.getOraCache(userName);
        if (jcds == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Cache not found: " + userName);
            }
        } else {
            jcds.reinitialize();
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Cache reinitialized: " + userName);
            }
        }
    }

    private JCartDataSource getOraCache(String login) {
        return this.userConnPoolMap.get(login.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testConnection(Connection conn) throws SQLException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Testing connection=" + conn);
        }
        Statement stmt = conn.createStatement();
        try {
            String sql = "select 1 from dual";
            stmt.executeQuery(sql);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSqlTrace(Connection conn, boolean on) throws SQLException {
        if (sqlLogger.isLoggable(Level.FINEST)) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute("alter session set sql_trace = " + (on ? "true" : "false"));
            }
            finally {
                stmt.close();
            }
        }
    }

    public void removePassword(String login) {
        this.userPasswords.remove(login.toUpperCase());
    }

    public void purgeCache(String userName) throws SQLException {
        this.purgeCache(userName, false);
    }

    public void purgeCache(String userName, boolean all) throws SQLException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("userName=" + userName + ", all=" + all);
        }
        for (JCartDataSource jcds : this.userConnPoolMap.values()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Checking against " + jcds.getLogin() + "...");
            }
            if (userName == null) {
                jcds.purge(all);
                continue;
            }
            if (!userName.toUpperCase().equals(jcds.getLogin())) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Purging " + jcds.getLogin() + "...");
            }
            jcds.purge(all);
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setConnection(ConnectionHandler connectionHandler) throws SQLException {
        Connection conn = this.getConnection(connectionHandler.getLoginName(), connectionHandler.getPassword());
        connectionHandler.setConnection(conn);
    }

    public void purgeCaches() throws SQLException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("START");
        }
        for (JCartDataSource ds : this.userConnPoolMap.values()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(ds.getLogin());
            }
            ds.purge(true);
        }
    }
}

