/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public class JcUtil {
    public static final Logger logger = Logger.getLogger(JcUtil.class.getName());

    private JcUtil() {
    }

    public static String extractParam(String data, String start, String stop) {
        int startPos = data.indexOf(start) + start.length();
        int stopPos = data.indexOf(stop);
        return data.substring(startPos, stopPos);
    }

    static char[] getOptionValue(String options, String optionName) {
        if (options == null) {
            return null;
        }
        int startIx = (options = options.toLowerCase()).indexOf(optionName = optionName.toLowerCase());
        if (startIx < 0) {
            return null;
        }
        int optIx = startIx + optionName.length();
        String optString = options.substring(optIx, optIx + 1);
        char[] carr = new char[]{optString.toCharArray()[0]};
        return carr;
    }

    static boolean getBooleanOptionValue(String options, String optionName, boolean defaultValue) {
        char[] carr = JcUtil.getOptionValue(options, optionName);
        if (carr == null) {
            return defaultValue;
        }
        switch (carr[0]) {
            case 'y': {
                return true;
            }
            case 'n': {
                return false;
            }
        }
        JcUtil.throwBadOptionValueException(carr, optionName);
        return false;
    }

    static void throwBadOptionValueException(char[] carr, String optionName) {
        throw new IllegalArgumentException("Option " + new String(carr) + " for " + optionName);
    }

    public static final String extractNormalizedParam(String data, int start, int stop) {
        return JcUtil.checkNormalizeNullParam(data.substring(start, stop));
    }

    public static final String checkNormalizeNullParam(String param) {
        if (param == null) {
            return null;
        }
        if (param.length() == 0 || param.equals("null")) {
            return null;
        }
        return param;
    }

    public static void writeToFile(String structure, String fileName) throws IOException {
        File f = new File(fileName);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f);
        fw.write(structure);
        fw.close();
    }

    public static final void exportProducts(LinkedBlockingQueue<String> lbq, Object molecules, String outFormat, boolean separateOutMols, String[] productIds) throws Exception {
        if (productIds != null && !separateOutMols) {
            throw new IllegalArgumentException("Mol property can be sent back separately only when mols are in separate records");
        }
        if (molecules == null) {
            return;
        }
        String prod = null;
        if (molecules instanceof Molecule[]) {
            Molecule[] mols = (Molecule[])molecules;
            if (separateOutMols) {
                for (int ix = 0; ix < mols.length; ++ix) {
                    prod = mols[ix].toFormat(outFormat);
                    if (productIds != null) {
                        prod = prod + "{molprop}";
                        prod = prod + productIds[ix];
                    }
                    lbq.put(prod);
                }
            } else {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                MolExporter exporter = new MolExporter(bout, outFormat);
                for (int ix = 0; ix < mols.length; ++ix) {
                    exporter.write(mols[ix]);
                }
                prod = new String(bout.toByteArray(), "US-ASCII");
                lbq.put(prod);
            }
        } else if (molecules instanceof Molecule) {
            Molecule mol = (Molecule)molecules;
            if (separateOutMols) {
                prod = mol.toFormat(outFormat);
                lbq.put(prod);
            } else {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                MolExporter exporter = new MolExporter(bout, outFormat);
                exporter.write(mol);
                prod = new String(bout.toByteArray(), "US-ASCII");
                lbq.put(prod);
            }
        }
    }

    public static final Molecule[] importMolecules(String structure, boolean isSmart) throws Exception {
        ArrayList<Molecule> molList = new ArrayList<Molecule>();
        ByteArrayInputStream instream = new ByteArrayInputStream(structure.getBytes("US-ASCII"));
        MolImporter importer = new MolImporter(instream);
        importer.setQueryMode(isSmart);
        Molecule mol = importer.read();
        while (mol != null) {
            molList.add(mol);
            mol = importer.read();
        }
        return molList.toArray(new Molecule[molList.size()]);
    }
}

