/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing;

import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.tunnel.UserInfo;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.jchem.db.CacheRegistrationUtil;
import chemaxon.jchem.db.TableInfo;
import chemaxon.util.ConnectionHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class CacheIdManagement {
    private static final Logger logger = Logger.getLogger(CacheIdManagement.class.getName());

    public String getMyCacheId() throws IOException {
        return JccConfig.getInstance().getProperty("structure.cache.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCacheIdForJcc(Connection connection, String jccOwner, String toAdd, String toRemove) throws Exception {
        if (toAdd == null) {
            throw new IllegalArgumentException("Cache id must not be null");
        }
        boolean haltOnDuplicate = true;
        ArrayList<String> list = this.getJccCacheIds(connection, jccOwner, true);
        try {
            if (toRemove != null) {
                list.remove(toRemove);
            }
            if (!list.contains(toAdd)) {
                list.add(toAdd);
            }
            JccCacheIdMasterList masterList = new JccCacheIdMasterList(list);
            ClientSideSession css = new ClientSideSession(connection);
            JcMetaDataFunctions metaData = new JcMetaDataFunctions(css);
            metaData.setMasterProperty(css.getJccOwner(), "structure.cache.id", masterList.toString());
        }
        finally {
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getAllJccCacheIds(UserInfo userInfo, String jccOwner) throws Exception {
        Connection connection = JCartConnectionManager.getInstance().getConnection(userInfo);
        try {
            ArrayList<String> arrayList = this.getAllJccCacheIds(connection, jccOwner);
            return arrayList;
        }
        finally {
            connection.close();
        }
    }

    public ArrayList<String> getAllJccCacheIds(Connection connection, String jccOwner) throws Exception {
        return this.getJccCacheIds(connection, jccOwner, false);
    }

    private ArrayList<String> getJccCacheIds(Connection connection, String jccOwner, boolean forUpdate) throws Exception {
        ClientSideSession css = new ClientSideSession(connection, jccOwner);
        JcMetaDataFunctions metaData = new JcMetaDataFunctions(css);
        String cacheIdList = metaData.getMasterProperty(css.getJccOwner(), "structure.cache.id");
        JccCacheIdMasterList list = new JccCacheIdMasterList(cacheIdList);
        return list.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCacheIdsForJcb(UserInfo userInfo, String jccOwner, String jchemPropertiesTableName) throws Exception {
        boolean commit = false;
        ConnectionHandler ch = JCartConnectionManager.getInstance().createConnectionHandler(userInfo, jchemPropertiesTableName, true);
        try {
            this.registerCacheIdsForJcb(ch, jccOwner, jchemPropertiesTableName);
            commit = true;
        }
        finally {
            try {
                if (commit) {
                    ch.getConnection().commit();
                } else {
                    ch.getConnection().rollback();
                }
            }
            finally {
                ch.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerCacheIdsForJcb(ConnectionHandler ch, String jccOwner, String jchemPropertiesTableName) throws Exception {
        ch.getConnection().setAutoCommit(true);
        try {
            TableInfo.createCacheRegistrationTableWithProperty(ch);
            ArrayList<String> cacheIds = this.getJccCacheIds(ch.getConnection(), jccOwner, false);
            CacheRegistrationUtil cru = new CacheRegistrationUtil(ch);
            for (String cacheId : cacheIds) {
                try {
                    cru.registerPermanentCache(cacheId);
                }
                catch (SQLException sqlException) {
                    if (sqlException.getErrorCode() == 1) continue;
                    throw sqlException;
                    return;
                }
            }
        }
        finally {
            ch.getConnection().setAutoCommit(false);
        }
    }

    private static class JccCacheIdMasterList {
        private ArrayList<String> list = new ArrayList();

        public JccCacheIdMasterList(String list) {
            if (list == null) {
                return;
            }
            StringTokenizer t = new StringTokenizer(list, ";");
            while (t.hasMoreTokens()) {
                this.list.add(t.nextToken());
            }
        }

        public JccCacheIdMasterList(ArrayList<String> list) {
            this.list = list;
        }

        public ArrayList<String> getList() {
            return this.list;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            for (String cacheId : this.list) {
                if (buffer.length() > 0) {
                    buffer.append(";");
                }
                buffer.append(cacheId);
            }
            return buffer.toString();
        }
    }
}

