/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class CtColDefList {
    private Set existingCtCols;
    private Set newlyDefinedColNames = new HashSet();
    private ArrayList l = new ArrayList();

    public CtColDefList() {
        this.existingCtCols = new HashSet();
    }

    public CtColDefList(Set existingCtCols) {
        this.existingCtCols = existingCtCols;
    }

    public void addDefListStrings(String[] defListStrings, boolean hasColName) {
        if (defListStrings == null || defListStrings.length == 0) {
            return;
        }
        String colName = null;
        String colType = null;
        String expression = null;
        for (int j = 0; j < defListStrings.length; ++j) {
            String ctDefString = defListStrings[j];
            if (hasColName) {
                StringTokenizer tzer = new StringTokenizer(ctDefString, ";");
                colName = tzer.nextToken();
                colType = tzer.nextToken();
                expression = tzer.nextToken();
                if (this.existingCtCols.contains(colName)) {
                    throw new IllegalArgumentException("CT Column name already exists: " + colName);
                }
                if (this.newlyDefinedColNames.contains(colName)) {
                    throw new IllegalArgumentException("Duplicate CT column name specification: " + colName);
                }
                this.newlyDefinedColNames.add(colName);
                this.l.add(new CtColDef(colName, colType, expression));
                continue;
            }
            int end = ctDefString.indexOf(59);
            colType = ctDefString.substring(0, end);
            expression = ctDefString.substring(end + 1);
            colName = this.generateNextColName();
            this.l.add(new CtColDef(colName, colType, expression));
        }
    }

    private String generateNextColName() {
        int sanityLimit = 10000;
        int i = 1;
        String colname = "chemterm" + i;
        while (this.colnameExists(colname)) {
            colname = "chemterm" + ++i;
            if (i <= 10000) continue;
            throw new RuntimeException("Could not generate column name after 10000 iterations already having: " + this.toString());
        }
        return colname;
    }

    private boolean colnameExists(String colname) {
        if (this.existingCtCols.contains(colname.toUpperCase())) {
            return true;
        }
        for (CtColDef ctColDef : this.l) {
            if (!ctColDef.colName.equalsIgnoreCase(colname)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        for (CtColDef ctColDef : this.l) {
            if (b.length() <= 0) continue;
            b.append("!!!");
            b.append(ctColDef.toString());
        }
        return b.toString();
    }

    public CtColDef[] toArray() {
        CtColDef[] a = new CtColDef[this.l.size()];
        this.l.toArray(a);
        return a;
    }

    public static class CtColDef {
        private String colName;
        private String colType;
        private String expression;

        public CtColDef(String colName, String colType, String expression) {
            this.colName = colName;
            this.colType = colType;
            this.expression = expression;
        }

        public String toString() {
            return this.colName + ";" + this.colType + ";" + this.expression;
        }

        public String getColName() {
            return this.colName;
        }

        public String getColType() {
            return this.colType;
        }

        public String getExpression() {
            return this.expression;
        }
    }
}

