/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing;

import chemaxon.jchem.cartridge.ColumnDescriptor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TableStructChangeSupport {
    private static final Logger logger = Logger.getLogger(TableStructChangeSupport.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ColumnDescriptor> getActualColDefList(Connection conn, String owner, String tableName) throws SQLException {
        ArrayList<ColumnDescriptor> actualColDefList = new ArrayList<ColumnDescriptor>();
        String sql = "select * from all_tab_cols where owner = ? and table_name = ?";
        ResultSet rs = null;
        PreparedStatement pstmt = conn.prepareStatement(sql);
        try {
            pstmt.setString(1, owner.toUpperCase());
            pstmt.setString(2, tableName.toUpperCase());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                actualColDefList.add(new ColumnDescriptor(rs));
            }
        }
        finally {
            pstmt.close();
        }
        return actualColDefList;
    }

    public static List<String> getRestructuringSqls(String tableName, List<ColumnDescriptor> actualColDefList, ColumnDescriptor[] newColDefs) {
        ArrayList<String> restructuringSqls = new ArrayList<String>();
        StringBuffer addClauses = new StringBuffer();
        StringBuffer modifyClauses = new StringBuffer();
        for (int i = 0; i < newColDefs.length; ++i) {
            ColumnDescriptor newColDef = newColDefs[i];
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Processing coldef: " + newColDef);
            }
            if (actualColDefList.contains(newColDef)) {
                int ix = actualColDefList.indexOf(newColDef);
                ColumnDescriptor actual = actualColDefList.remove(ix);
                if (actual.isSame(newColDef)) continue;
                if (newColDef.colSize < actual.colSize) {
                    newColDef.colSize = actual.colSize;
                    if (actual.isSame(newColDef)) continue;
                }
                if (modifyClauses.length() > 0) {
                    modifyClauses.append(", ");
                }
                modifyClauses.append(newColDef);
                continue;
            }
            if (addClauses.length() > 0) {
                addClauses.append(", ");
            }
            addClauses.append(newColDef);
        }
        if (modifyClauses.length() > 0) {
            restructuringSqls.add("alter table " + tableName + " modify (" + modifyClauses.toString() + ")");
        }
        if (addClauses.length() > 0) {
            restructuringSqls.add("alter table " + tableName + " add (" + addClauses.toString() + ")");
        }
        return restructuringSqls;
    }
}

