/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.operations;

import chemaxon.jchem.cartridge.ColumnDescriptor;
import chemaxon.jchem.cartridge.IndexTableStruct;
import chemaxon.jchem.cartridge.Indexing;
import chemaxon.jchem.cartridge.rmi.impl.MiscellaniousImpl;
import chemaxon.jchem.cartridge.servlets.indexing.LogTableStruct;
import chemaxon.jchem.cartridge.servlets.indexing.TableStructChangeSupport;
import chemaxon.jchem.cartridge.servlets.indexing.operations.JCartIndexCreate;
import chemaxon.jchem.cartridge.servlets.indexing.operations.JCartIndexTruncate;
import chemaxon.jchem.cartridge.servlets.indexing.operations.MdDescManager;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.MdMetaData;
import chemaxon.jchem.cartridge.tunnel.index.CreateMolDescInfo;
import chemaxon.jchem.cartridge.tunnel.index.IndexRebuildInfo;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.ConnectionHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCartIndexRebuild
extends JCartIndexCreate {
    private static final Logger logger = Logger.getLogger(JCartIndexRebuild.class.getName());
    private IndexRebuildInfo iri;

    public JCartIndexRebuild(IndexRebuildInfo ii) throws IOException {
        super(ii);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("IndexRebuildInfo: " + ii.toString());
        }
        this.iri = ii;
    }

    @Override
    protected void executePayLoad() throws Exception {
        boolean skipRecalc;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("BEGIN");
        }
        if (!(skipRecalc = this.iri.isSkipRecalculation())) {
            JCartIndexTruncate.truncateAll(this.ch, this.getIndexDescriptor());
            if (this.iri.getStdConfig() != null) {
                this.metaData.setJChemPropertyForIndex(this.ii.getJcpropTableName(), this.iri.getIndexTableQName(), false, "standardizerConfig", this.iri.getStdConfig());
            }
        }
        this.setJChemPropertiesIdMaybe();
        this.alterIdxTableMaybe(this.iri);
        this.addNewProperties(this.iri);
        this.metaData.setJChemPropertyForIndex(this.iri.getJcpropTableName(), this.iri.getIndexTableQName(), false, "version", String.valueOf(VersionInfo.JCHEM_TABLE_VERSION));
        this.upgradeIndexTableStructure(this.ch);
        this.upgradeLogTableStructure(this.ch);
        this.addMscrTableMaybe(this.ch);
        if (!skipRecalc) {
            Indexing.removeCdHashIndex(this.metaData, this.iri.getIndexTableQName());
            this.buildIndex(this.ch);
            Indexing.createCdHashIndex(this.metaData, this.iri.getIndexTableQName(), this.iri.getTableSpace());
            this.regenerateMdData(this.ch);
        }
        DatabaseProperties dbProps = new DatabaseProperties(this.ch, true);
        TableInfo.resetTableValidityTimestamp(dbProps, this.iri.getIndexTableQName());
        this.ch.getConnection().commit();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("END");
        }
    }

    private void addMscrTableMaybe(ConnectionHandler ch) throws Exception {
        if (Integer.parseInt(this.ii.getTableType()) == 3) {
            MdMetaData[] mdMeta;
            for (MdMetaData m : mdMeta = new MiscellaniousImpl().getMdMetaData(this.ii, false)) {
                if (!m.name.equals("MSCR")) continue;
                return;
            }
            MdDescManager.addDefaultMd(new CreateMolDescInfo(JCartIndexDescriptor.get(this.dbSession, this.ii), this.ii.getSessionInfo(), this.ii.getUserAssignedId(), this.ii.getThreadCount(), 1, "MSCR"));
        }
    }

    private void setJChemPropertiesIdMaybe() throws SQLException {
        DatabaseProperties dbProps = new DatabaseProperties(this.ch, true);
        if (dbProps.getProperty("propertytable.identifier") == null) {
            DatabaseOptions.setPropertyTableIdentifier(dbProps);
        }
    }

    private void regenerateMdData(ConnectionHandler conh) throws Exception {
        MdMetaData[] mdMetaDataArray;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("BEGIN");
        }
        if ((mdMetaDataArray = new MiscellaniousImpl().getMdMetaData(this.ii, false)).length == 0) {
            return;
        }
        String[] mdNames = new String[mdMetaDataArray.length];
        for (int i = 0; i < mdMetaDataArray.length; ++i) {
            MdMetaData mdmd = mdMetaDataArray[i];
            mdNames[i] = mdmd.name;
        }
        MdDescManager.generateStoreMdData(conh, this.iri, mdNames);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("END");
        }
    }

    private void addNewProperties(IndexRebuildInfo ii) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("BEGIN");
        }
        String[][] newProps = new String[][]{{"JChemVersion", VersionInfo.JCHEM_VERSION}, {"ctVersion", "" + VersionInfo.JCHEM_TABLE_VERSION}, {"mdVersion", "" + VersionInfo.JCHEM_TABLE_VERSION}, {"duplicateFiltering", "false"}, {"tautomerDuplicateFiltering", "false"}, {"exclusiveDuplicateFiltering", "false"}};
        for (int i = 0; i < newProps.length; ++i) {
            String pn = newProps[i][0];
            String pv = this.metaData.getJChemPropertyForIndex(ii.getJcpropTableName(), ii.getIndexTableQName(), false, pn);
            if (pv != null) continue;
            pv = newProps[i][1];
            this.metaData.setJChemPropertyForIndex(ii.getJcpropTableName(), ii.getIndexTableQName(), false, pn, pv);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("END");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterIdxTableMaybe(IndexRebuildInfo indexRebuildInfo) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("BEGIN");
        }
        String stmt = "alter table " + indexRebuildInfo.getIndexTableQName();
        boolean doAlterTable = false;
        if (indexRebuildInfo.getTableSpace() != null) {
            stmt = stmt + " MOVE TABLESPACE " + indexRebuildInfo.getTableSpace();
            doAlterTable = true;
        }
        if (indexRebuildInfo.getStorage() != null) {
            stmt = stmt + " STORAGE (" + indexRebuildInfo.getStorage() + ")";
            doAlterTable = true;
        }
        if (doAlterTable) {
            PreparedStatement ps = this.dbSession.prepareStatementNoCache(stmt);
            try {
                ps.execute();
            }
            finally {
                ps.close();
            }
            ResultSet rset = null;
            stmt = "SELECT index_name FROM user_indexes WHERE table_owner = ? AND table_name = ?";
            ps = this.dbSession.prepareStatement(stmt);
            try {
                ps.setString(1, indexRebuildInfo.getIndexSchemaName().toUpperCase());
                ps.setString(2, indexRebuildInfo.getIndexName().toUpperCase());
                rset = ps.executeQuery();
                while (rset.next()) {
                    String stmt1 = "ALTER INDEX " + rset.getString(1) + " REBUILD";
                    PreparedStatement ps1 = this.dbSession.prepareStatementNoCache(stmt1);
                    try {
                        ps1.execute();
                    }
                    finally {
                        ps.close();
                    }
                }
            }
            catch (Throwable throwable) {
                this.dbSession.close(rset, ps);
                throw throwable;
            }
            this.dbSession.close(rset, ps);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("END");
        }
    }

    private void upgradeIndexTableStructure(ConnectionHandler ch) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("BEGIN");
        }
        JCartIndexDescriptor idesc = this.getIndexDescriptor();
        String owner = idesc.getIndexSchemaName();
        String tableName = idesc.getIdxTableName();
        Connection conn = idesc.getDbSession().getConnection();
        List<ColumnDescriptor> actualColList = TableStructChangeSupport.getActualColDefList(conn, owner, tableName);
        ColumnDescriptor[] newColDefs = IndexTableStruct.getMiscColumnDefs(idesc.getTableType());
        List<String> restructuringSqls = TableStructChangeSupport.getRestructuringSqls(idesc.getIdxTableQName(), actualColList, newColDefs);
        for (String sql : restructuringSqls) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Executing \"" + sql + "\"");
            }
            this.metaData.execDDLStatement(sql);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("END");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeLogTableStructure(ConnectionHandler ch) throws Exception {
        JCartIndexDescriptor idesc = this.getIndexDescriptor();
        Statement stmt = ch.getConnection().createStatement();
        try {
            stmt.execute("truncate table " + idesc.getUpdateLogTableName());
        }
        finally {
            stmt.close();
        }
        String owner = idesc.getIndexSchemaName();
        String tableQName = idesc.getUpdateLogTableName();
        Connection conn = idesc.getDbSession().getConnection();
        List<ColumnDescriptor> actualColList = TableStructChangeSupport.getActualColDefList(conn, owner, tableQName.substring(owner.length() + 1));
        List<String> restructuringSqls = TableStructChangeSupport.getRestructuringSqls(tableQName, actualColList, LogTableStruct.columns);
        for (String sql : restructuringSqls) {
            System.err.println(sql);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Executing \"" + sql + "\"");
            }
            this.metaData.execDDLStatement(sql);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("END");
        }
    }

    @Override
    protected void recreateSequence() {
    }

    @Override
    public int getSofar() {
        return this.getCdIdCounter();
    }

    @Override
    public String getOpName() {
        return "Rebuilding index " + this.ii.getIndexName();
    }
}

