/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.operations;

import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.servlets.indexing.operations.JCartIndexBase;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.MdMetaData;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.TableInfo;
import chemaxon.util.ConnectionHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCartIndexTruncate {
    private static final Logger logger = Logger.getLogger(JCartIndexTruncate.class.getName());
    private IndexingInfo ii;

    public JCartIndexTruncate(IndexingInfo ii) {
        this.ii = ii;
    }

    public void all() throws Exception {
        JCartIndexBase all = new JCartIndexBase(this.ii){

            @Override
            protected void executePayLoad() throws Exception {
                JCartIndexTruncate.truncateAll(this.ch, this.getIndexDescriptor());
            }
        };
        all.executeSynch();
    }

    public void updateLogTable() throws Exception {
        JCartIndexBase updateLogTable = new JCartIndexBase(this.ii){

            @Override
            protected void executePayLoad() throws Exception {
                JCartIndexTruncate.truncateUpdateLogTable(this.getIndexDescriptor());
            }
        };
        updateLogTable.executeSynch();
    }

    public static void truncateAll(ConnectionHandler ch, JCartIndexDescriptor idxDesc) throws Exception {
        JCartIndexTruncate.truncateMdTables(idxDesc.getDbSession(), idxDesc);
        JCartIndexTruncate.truncateIdxTable(idxDesc.getDbSession(), idxDesc.getIndexSchemaName(), idxDesc.getIdxTableName());
        JCartIndexTruncate.truncateUpdateLogTable(idxDesc);
        DatabaseProperties dbProp = new DatabaseProperties(ch, true);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Setting table validity timestamp");
        }
        TableInfo.resetTableValidityTimestamp(dbProp, idxDesc.getIdxTableQName());
        ch.getConnection().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateMdTables(DbSession dbSession, JCartIndexDescriptor idxDesc) throws Exception {
        MdMetaData[] mdata = idxDesc.getAllMdMetaData();
        for (int i = 0; i < mdata.length; ++i) {
            MdMetaData mdMetaData = mdata[i];
            PreparedStatement pstmt = dbSession.prepareStatement("TRUNCATE TABLE " + mdMetaData.tableName);
            try {
                pstmt.execute();
                continue;
            }
            finally {
                dbSession.close(null, pstmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateIdxTable(DbSession session, String owner, String tableName) throws SQLException {
        List<String[]> fkConstraints = JCartIndexTruncate.getFkConstraints(session, owner, tableName);
        JCartIndexTruncate.enDisableFkConstraints(session, fkConstraints, false);
        try {
            PreparedStatement pstmt = session.prepareStatement("TRUNCATE TABLE " + owner + "." + tableName);
            try {
                pstmt.execute();
            }
            finally {
                session.close(null, pstmt);
            }
        }
        finally {
            JCartIndexTruncate.enDisableFkConstraints(session, fkConstraints, true);
        }
    }

    private static void enDisableFkConstraints(DbSession dbSession, List<String[]> fkConstraints, boolean enable) throws SQLException {
        for (String[] c : fkConstraints) {
            String sql = "alter table " + c[0] + "." + c[1] + " " + (enable ? "enable" : "disable") + " constraint " + c[2];
            PreparedStatement pstmt = dbSession.prepareStatement(sql);
            try {
                pstmt.execute();
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info(sql + " executed.");
            }
            catch (SQLException sqlException) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("The following statement failed: " + sql);
                }
                throw sqlException;
            }
            finally {
                dbSession.close(null, pstmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String[]> getFkConstraints(DbSession dbSession, String owner, String idxTableName) throws SQLException {
        ArrayList<String[]> arrayList;
        String sql = "select owner, table_name, constraint_name from all_constraints where r_constraint_name in (select constraint_name from all_constraints where owner = ? and table_name = ? and (constraint_type = 'P' or constraint_type = 'U')) and constraint_type = 'R'";
        ResultSet rs = null;
        PreparedStatement pstmt = dbSession.prepareStatement(sql);
        try {
            pstmt.setString(1, owner);
            pstmt.setString(2, idxTableName);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("About to execute " + sql + " [idxTableName=" + idxTableName + "]...");
            }
            rs = pstmt.executeQuery();
            ArrayList<String[]> l = new ArrayList<String[]>();
            while (rs.next()) {
                l.add(new String[]{rs.getString("owner"), rs.getString("table_name"), rs.getString("constraint_name")});
            }
            arrayList = l;
        }
        catch (Throwable throwable) {
            dbSession.close(rs, pstmt);
            throw throwable;
        }
        dbSession.close(rs, pstmt);
        return arrayList;
    }

    public static void truncateUpdateLogTable(JCartIndexDescriptor idxDesc) throws Exception {
        block2: {
            String sql = "TRUNCATE TABLE " + idxDesc.getUpdateLogTableName();
            try {
                idxDesc.getMetaDataFunctions().execDDLStatement(sql);
            }
            catch (SQLException sqle) {
                if (sqle.getErrorCode() == 942) break block2;
                throw sqle;
            }
        }
    }
}

