/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.operations;

import chemaxon.jchem.cartridge.rmi.impl.RmiTunnelImpl;
import chemaxon.jchem.cartridge.servlets.indexing.MdParams;
import chemaxon.jchem.cartridge.servlets.indexing.operations.ConcurrentIndexBuilder;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.MdCreationHandler;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.StructHandler;
import chemaxon.jchem.cartridge.tunnel.index.CreateMolDescInfo;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.jchem.cartridge.tunnel.index.MdManagementInfo;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.util.ConnectionHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MdDescManager {
    private static final Logger logger = Logger.getLogger(MdDescManager.class.getName());

    public static void delMdDesc(MdManagementInfo molDescInfo) throws Exception {
        String idxTableName = molDescInfo.getIndexTableQName();
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(molDescInfo);
        try {
            MDTableHandler mdTableHandler = new MDTableHandler(ch, idxTableName, !molDescInfo.isJchemTable());
            mdTableHandler.deleteMDTable(molDescInfo.getData());
            ch.getConnection().commit();
        }
        catch (Throwable e) {
            ch.getConnection().rollback();
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new Exception(e);
        }
        finally {
            ch.close();
        }
    }

    public static void delAllMdDesc(MdManagementInfo molDescInfo) throws Exception {
        String idxTableName = molDescInfo.getIndexTableQName();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Deleting all molecular descriptor tables for " + idxTableName + "...");
        }
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(molDescInfo);
        try {
            MDTableHandler mdTableHandler = new MDTableHandler(ch, idxTableName, !molDescInfo.isJchemTable());
            String[] mdNames = mdTableHandler.getMolecularDescriptors();
            for (int i = 0; i < mdNames.length; ++i) {
                String mdName = mdNames[i];
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Deleting molecular descriptor " + mdName + "...");
                    }
                    mdTableHandler.deleteMDTable(mdName);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            ch.getConnection().commit();
        }
        catch (SQLException sqlException) {
            ch.getConnection().rollback();
            if (sqlException.getMessage().indexOf("is not defined in property table") == -1) {
                throw sqlException;
            }
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Error while removing descriptor tables", sqlException);
            }
        }
        catch (Throwable e) {
            ch.getConnection().rollback();
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new Exception(e);
        }
        finally {
            ch.close();
        }
    }

    public static void addDefaultMd(CreateMolDescInfo molDescInfo) throws Exception {
        String idxTableName = molDescInfo.getIndexTableQName();
        MDTableHandler mdTableHandler = null;
        MdParams p = null;
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(molDescInfo);
        try {
            Connection conn = ch.getConnection();
            conn.setAutoCommit(false);
            mdTableHandler = new MDTableHandler(ch, idxTableName, !molDescInfo.isJchemTable());
            p = MdParams.createDefaultMdConf(molDescInfo.getMdDescParams());
            mdTableHandler.createMDTable(p.getName(), p.getType(), p.getSettings(), p.getComment(), true);
            conn.commit();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Processing the following MD name for " + molDescInfo.getIndexTableQName() + ": " + p.getName());
            }
            MdDescManager.generateStoreMdData(ch, molDescInfo, new String[]{p.getName()});
            ch.getConnection().commit();
        }
        catch (Throwable throwable) {
            ch.getConnection().rollback();
            if (p != null && mdTableHandler != null) {
                MdDescManager.removeMdTables(new MdParams[]{p}, mdTableHandler);
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable);
        }
        finally {
            ch.close();
        }
    }

    public static void addMd(CreateMolDescInfo molDescInfo) throws Exception {
        String idxTableName = molDescInfo.getIndexTableQName();
        MdParams[] parr = null;
        MDTableHandler mdTableHandler = null;
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(molDescInfo);
        try {
            Connection conn = ch.getConnection();
            conn.setAutoCommit(false);
            mdTableHandler = new MDTableHandler(ch, idxTableName, !molDescInfo.isJchemTable());
            parr = MdParams.extractInstanceArray(ch.getConnection(), molDescInfo.getMdDescParams(), true);
            for (int i = 0; i < parr.length; ++i) {
                parr[i].createMdTable(mdTableHandler);
            }
            conn.commit();
            StringBuffer debugBuffer = null;
            String[] mdNames = new String[parr.length];
            for (int i = 0; i < parr.length; ++i) {
                mdNames[i] = parr[i].getName();
                if (!logger.isLoggable(Level.FINE)) continue;
                if (debugBuffer == null) {
                    debugBuffer = new StringBuffer("Processing the following MD name for " + molDescInfo.getIndexTableQName() + ": ");
                } else {
                    debugBuffer.append(", ");
                }
                debugBuffer.append(mdNames[i]);
            }
            if (debugBuffer != null) {
                logger.fine(debugBuffer.toString());
            }
            MdDescManager.generateStoreMdData(ch, molDescInfo, mdNames);
            ch.getConnection().commit();
        }
        catch (Throwable throwable) {
            ch.getConnection().rollback();
            if (parr != null && mdTableHandler != null) {
                MdDescManager.removeMdTables(parr, mdTableHandler);
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable);
        }
        finally {
            ch.close();
        }
    }

    public static void generateStoreMdData(ConnectionHandler ch, final IndexingInfo molDescInfo, final String[] mdNames) throws Exception {
        final AtomicInteger rowCounter = new AtomicInteger();
        ConcurrentIndexBuilder cib = new ConcurrentIndexBuilder(molDescInfo.getSessionInfo().getUserName(), molDescInfo.getThreadCount()){

            @Override
            protected StructHandler createStructIndexer() throws Exception {
                return new MdCreationHandler(molDescInfo, mdNames, rowCounter);
            }
        };
        cib.build(ch, MdDescManager.createStructureGetterSql(ch, molDescInfo), null);
        DatabaseProperties dbProp = new DatabaseProperties(ch, true);
        TableInfo.resetTableValidityTimestamp(dbProp, molDescInfo.getIndexTableQName());
        ch.getConnection().commit();
    }

    public static void addMdConf(MdManagementInfo mdInfo) throws Exception {
        String idxTableName = mdInfo.getIndexTableQName();
        MdParams[] parr = null;
        MDTableHandler mdTableHandler = null;
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(mdInfo);
        try {
            Connection conn = ch.getConnection();
            conn.setAutoCommit(false);
            mdTableHandler = new MDTableHandler(ch, idxTableName, !mdInfo.isJchemTable());
            int colPos = mdInfo.getData().indexOf(58);
            String mdName = mdInfo.getData().substring(0, colPos);
            String definitionLocator = mdInfo.getData().substring(colPos + 1);
            parr = MdParams.extractInstanceArray(ch.getConnection(), definitionLocator, false);
            for (int i = 0; i < parr.length; ++i) {
                mdTableHandler.setMDConfig(mdName, parr[i].getName(), parr[i].getSettings());
            }
            conn.commit();
        }
        catch (Throwable throwable) {
            ch.getConnection().rollback();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable);
        }
        finally {
            ch.close();
        }
    }

    public static void delMdConf(MdManagementInfo mdInfo) throws Exception {
        String idxTableName = mdInfo.getIndexTableQName();
        MDTableHandler mdTableHandler = null;
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(mdInfo);
        try {
            Connection conn = ch.getConnection();
            conn.setAutoCommit(false);
            mdTableHandler = new MDTableHandler(ch, idxTableName, !mdInfo.isJchemTable());
            int colPos = mdInfo.getData().indexOf(58);
            String mdName = mdInfo.getData().substring(0, colPos);
            String configName = mdInfo.getData().substring(colPos + 1);
            mdTableHandler.deleteMDConfig(mdName, configName);
            conn.commit();
        }
        catch (Throwable throwable) {
            ch.getConnection().rollback();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable);
        }
        finally {
            ch.close();
        }
    }

    private static void removeMdTables(MdParams[] parr, MDTableHandler mdTableHandler) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Trying to remove MDTables after error in generating descriptors...");
        }
        for (MdParams mdParam : parr) {
            String mdName = mdParam.getName();
            try {
                mdTableHandler.deleteMDTable(mdName);
            }
            catch (Throwable tbl1) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, "Error while trying to remove table for " + mdName + ": " + tbl1.getMessage());
            }
        }
    }

    private static String createStructureGetterSql(ConnectionHandler ch, IndexingInfo molDescInfo) throws Exception {
        if (!molDescInfo.isJchemTable()) {
            String baseTblQName = molDescInfo.getBaseSchemaName() + "." + molDescInfo.getBaseTableName();
            String idxColName = molDescInfo.getIndexedColumn();
            String idxTblQName = molDescInfo.getIndexTableQName();
            return "SELECT " + idxTblQName + ".cd_id, " + baseTblQName + "." + idxColName + " FROM " + baseTblQName + ", " + idxTblQName + " where " + idxTblQName + ".rid = " + baseTblQName + ".ROWID";
        }
        return "SELECT cdId, " + molDescInfo.getIndexedColumn() + " FROM " + molDescInfo.getIndexTableQName();
    }
}

