/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.structhandlers;

import chemaxon.descriptors.MDDBWriter;
import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.rmi.impl.RmiTunnelImpl;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.StructHandler;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MdCreationHandler
implements StructHandler {
    private static final Logger logger = Logger.getLogger(MdCreationHandler.class.getName());
    private ConnectionHandler ch;
    private MDDBWriter writer;
    protected AtomicInteger rowCounter;
    protected long commitInterval;

    public MdCreationHandler(IndexingInfo molDescInfo, String[] mdNames, AtomicInteger rowCounter) throws Exception {
        this.ch = RmiTunnelImpl.getConnectionHandler(molDescInfo);
        this.writer = new MDDBWriter(!JCartIndexDescriptor.get((DbSession)new ClientSideSession(this.ch.getConnection()), molDescInfo).isJChemTable());
        this.writer.setStructureTable(molDescInfo.getIndexTableQName());
        this.writer.setMDNames(mdNames);
        this.writer.setUpdateMode(false);
        this.writer.setConnectionHandler(this.ch);
        this.rowCounter = rowCounter;
        this.commitInterval = JccConfig.getInstance().getLong("idx.commit.interval", 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean commit) throws Exception {
        if (this.ch == null) {
            return;
        }
        try {
            if (commit) {
                this.ch.getConnection().commit();
            } else {
                this.ch.getConnection().rollback();
            }
            this.writer.close();
        }
        catch (Throwable tbl) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "error", tbl);
            }
        }
        finally {
            this.ch.close();
        }
    }

    public boolean handleException(Exception exception) throws Exception {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, "error", exception);
        }
        return false;
    }

    @Override
    public boolean index(String rowid, byte[] structure) throws Exception {
        int id = Integer.parseInt(rowid);
        if (structure == null) {
            this.writer.put(new Molecule(), id);
        } else {
            this.writer.put(new String(structure, "US-ASCII"), id);
        }
        this.commitMayBe();
        return true;
    }

    protected void commitMayBe() throws SQLException {
        int rowCount = this.rowCounter.incrementAndGet();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("commitInterval=" + this.commitInterval + ", rowCount=" + rowCount);
        }
        if (this.commitInterval > 0L && (long)rowCount % this.commitInterval == 0L) {
            this.ch.getConnection().commit();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finer("Committed");
            }
        }
    }
}

