/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.react.prod_consumer;

import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.servlets.react.prod_consumer.DbInsertConsumer;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.interop.reactor.SynthCodeInfo;
import chemaxon.struc.Molecule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JChemTableProductInserter
extends DbInsertConsumer {
    private static final Log log = LogFactory.getLog(JChemTableProductInserter.class);
    private String jcpTableName;
    private UpdateHandler uh;

    public JChemTableProductInserter(SessionInfo userInfo, String tableName, String outFormat, String jcpTableName, String productIdColName, SynthCodeInfo synthCodeInfo) throws Exception {
        super(userInfo, tableName, outFormat, productIdColName, synthCodeInfo);
        this.jcpTableName = jcpTableName;
        this.turnOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() throws Exception {
        Throwable error = null;
        try {
            try {
                if (this.uh != null) {
                    this.uh.close();
                    this.uh = null;
                }
            }
            catch (Throwable tbl) {
                error = tbl;
                tbl.printStackTrace();
            }
            try {
                if (this.ch != null) {
                    this.ch.getConnection().commit();
                }
            }
            catch (Throwable tbl) {
                error = tbl;
                tbl.printStackTrace();
            }
            if (this.ch != null) {
                this.ch.close();
                this.ch = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Connection(Handler) closed");
                }
            }
        }
        finally {
            if (error != null) {
                throw new RuntimeException(error);
            }
        }
    }

    protected void turnOn() throws Exception {
        this.ch = JCartConnectionManager.getInstance().createConnectionHandler(this.userInfo, this.jcpTableName, true);
        this.createUpdateHandler();
    }

    private void createUpdateHandler() throws Exception {
        if (this.productIdColName == null) {
            this.productIdColName = "";
        }
        this.uh = new UpdateHandler(this.ch, 1, this.tableName, this.productIdColName);
    }

    @Override
    public void insertProduct(Molecule product, String productId) throws Exception {
        this.uh.setStructure(product.toFormat(this.outFormat));
        if (this.productIdColName != null && this.productIdColName.length() > 0) {
            this.uh.setValueForAdditionalColumn(1, productId);
        }
        this.uh.execute();
    }
}

