/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.react.prod_consumer;

import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.servlets.react.prod_consumer.DbInsertConsumer;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.interop.reactor.SynthCodeInfo;
import chemaxon.struc.Molecule;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlainTableProductInserter
extends DbInsertConsumer {
    private static final Log log = LogFactory.getLog(PlainTableProductInserter.class);
    protected String productColName;
    protected PreparedStatement psInsertEmpty;
    protected PreparedStatement psSelectForUpdate;
    protected int productColType;
    protected int productIdColType;

    public PlainTableProductInserter(SessionInfo userInfo, String tableName, String outFormat, String productColName, String productIdColName, SynthCodeInfo synthCodeInfo) throws Exception {
        super(userInfo, tableName, outFormat, productIdColName, synthCodeInfo);
        if (productColName == null) {
            throw new NullPointerException("The name of the product column must not be null");
        }
        this.productColName = productColName;
        this.turnOn();
    }

    public void turnOn() throws Exception {
        this.ch = JCartConnectionManager.getInstance().createConnectionHandler(this.userInfo, null, true);
        this.getColTypes();
        this.createPreparedStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getColTypes() throws Exception {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ").append(this.productColName);
        if (this.productIdColName != null) {
            sqlBuffer.append(", ").append(this.productIdColName);
        }
        sqlBuffer.append(" FROM ").append(this.tableName).append(" WHERE 1 = 2");
        ResultSet rs = null;
        Statement stmt = this.ch.getConnection().createStatement();
        try {
            rs = stmt.executeQuery(sqlBuffer.toString());
            ResultSetMetaData rsMetaData = rs.getMetaData();
            this.productColType = rsMetaData.getColumnType(1);
            if (this.productIdColName != null) {
                this.productIdColType = rsMetaData.getColumnType(2);
            }
        }
        finally {
            Throwable error;
            block12: {
                error = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Throwable tbl) {
                    error = tbl;
                    if (!log.isErrorEnabled()) break block12;
                    log.error((Object)"error", tbl);
                }
            }
            stmt.close();
            if (error != null) {
                throw new RuntimeException(error);
            }
        }
    }

    protected void createPreparedStatements() throws Exception {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("INSERT INTO ").append(this.tableName).append(" (").append(this.productColName);
        if (this.productIdColName != null) {
            sqlBuffer.append(", ");
            sqlBuffer.append(this.productIdColName);
        }
        sqlBuffer.append(") VALUES(");
        switch (this.productColType) {
            case 2005: {
                sqlBuffer.append("empty_clob()");
                break;
            }
            case 2004: {
                sqlBuffer.append("empty_blob()");
                break;
            }
            default: {
                sqlBuffer.append("?");
            }
        }
        if (this.productIdColName != null) {
            sqlBuffer.append(", ?");
        }
        sqlBuffer.append(")");
        if (log.isDebugEnabled()) {
            log.debug((Object)sqlBuffer.toString());
        }
        this.psInsertEmpty = this.ch.getConnection().prepareStatement(sqlBuffer.toString());
        if (this.isLob()) {
            String pkColName = this.productIdColName;
            String sql = "SELECT " + this.productColName + " FROM " + this.tableName + " WHERE " + pkColName + " = ? FOR UPDATE";
            if (log.isDebugEnabled()) {
                log.debug((Object)sql);
            }
            this.psSelectForUpdate = this.ch.getConnection().prepareStatement(sql);
        }
    }

    @Override
    public void cleanup() throws Exception {
        Throwable error;
        block14: {
            block13: {
                block12: {
                    error = null;
                    try {
                        if (this.ch != null) {
                            this.ch.getConnection().commit();
                        }
                    }
                    catch (Throwable tbl) {
                        error = tbl;
                        if (!log.isErrorEnabled()) break block12;
                        log.error((Object)"error", tbl);
                    }
                }
                try {
                    if (this.psInsertEmpty != null) {
                        this.psInsertEmpty.close();
                        this.psInsertEmpty = null;
                    }
                }
                catch (Throwable tbl) {
                    error = tbl;
                    if (!log.isErrorEnabled()) break block13;
                    log.error((Object)"error", tbl);
                }
            }
            try {
                if (this.psSelectForUpdate != null) {
                    this.psSelectForUpdate.close();
                    this.psSelectForUpdate = null;
                }
            }
            catch (Throwable tbl) {
                error = tbl;
                if (!log.isErrorEnabled()) break block14;
                log.error((Object)"error", tbl);
            }
        }
        if (this.ch != null) {
            this.ch.getConnection().close();
            this.ch = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection(Handler) closed");
            }
        }
        if (error != null) {
            throw new RuntimeException(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertProduct(Molecule product, String productId) throws Exception {
        String struct = product.toFormat(this.outFormat);
        int paramIdx = 1;
        if (!this.isLob()) {
            this.psInsertEmpty.setObject(paramIdx++, (Object)struct, this.productColType);
        }
        if (this.productIdColName != null) {
            this.psInsertEmpty.setObject(paramIdx++, (Object)productId, this.productIdColType);
        }
        this.psInsertEmpty.execute();
        if (this.isLob()) {
            int pkColType = this.productIdColType;
            this.psSelectForUpdate.setObject(1, (Object)productId, pkColType);
            ResultSet rs = this.psSelectForUpdate.executeQuery();
            try {
                rs.next();
                if (this.productColType == 2004) {
                    this.writeStructureToBlob(rs, struct);
                } else {
                    this.writeStructureToClob(rs, struct);
                }
            }
            finally {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStructureToBlob(ResultSet rs, String structure) throws Exception {
        Blob blob = rs.getBlob(this.productColName);
        BLOB oraBlob = (BLOB)blob;
        oraBlob.open(1);
        try {
            OutputStream outstream = oraBlob.getBinaryOutputStream();
            try {
                byte[] buffer = new byte[]{};
                if (structure != null) {
                    buffer = structure.getBytes();
                }
                outstream.write(buffer);
            }
            finally {
                outstream.close();
            }
        }
        finally {
            oraBlob.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStructureToClob(ResultSet rs, String structure) throws Exception {
        Clob clob = rs.getClob(this.productColName);
        CLOB oraClob = (CLOB)clob;
        oraClob.open(1);
        try {
            Writer writer = oraClob.getCharacterOutputStream();
            try {
                writer.write(structure);
            }
            finally {
                writer.close();
            }
        }
        finally {
            oraClob.close();
        }
    }

    protected boolean isLob() {
        return this.productColType == 2004 || this.productColType == 2005;
    }
}

