/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.react.prod_consumer;

import chemaxon.jchem.cartridge.servlets.JcUtil;
import chemaxon.jchem.cartridge.servlets.react.prod_consumer.ProductConsumer;
import chemaxon.jchem.interop.reactor.SynthCodeInfo;
import chemaxon.struc.Molecule;
import java.util.concurrent.LinkedBlockingQueue;

public class StreamingConsumer
implements ProductConsumer {
    private SynthCodeInfo synthCodeInfo;
    private boolean separateOutMols;
    private String outFormat;
    private LinkedBlockingQueue<String> lbq;
    private boolean dotSeparatedSmilesProducts;

    public StreamingConsumer(SynthCodeInfo synthCodeInfo, boolean separateOutMol, String outFormat, boolean dotSeparatedSmilesProducts) {
        this.synthCodeInfo = synthCodeInfo;
        this.separateOutMols = separateOutMol;
        this.outFormat = outFormat;
        this.dotSeparatedSmilesProducts = dotSeparatedSmilesProducts;
    }

    public StreamingConsumer(LinkedBlockingQueue<String> lbq, SynthCodeInfo synthCodeInfo, boolean separateOutMol, String outFormat, boolean dotSeparatedSmilesProducts) {
        this(synthCodeInfo, separateOutMol, outFormat, dotSeparatedSmilesProducts);
        this.lbq = lbq;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void consume(Molecule[] products) throws Exception {
        String[] productIds = null;
        if (this.separateOutMols && !this.dotSeparatedSmilesProducts) {
            productIds = this.synthCodeInfo.getProductIds(products);
        }
        if (this.dotSeparatedSmilesProducts) {
            StringBuffer buff = new StringBuffer("");
            for (int i = 0; i < products.length; ++i) {
                Molecule molecule = products[i];
                String prod = molecule.toFormat("smiles");
                if (buff.length() > 0) {
                    buff.append(".");
                }
                buff.append(prod);
            }
            this.lbq.put(buff.toString());
        } else {
            JcUtil.exportProducts(this.lbq, products, this.outFormat, this.separateOutMols, productIds);
        }
    }
}

