/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.search;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.rmi.impl.errcache.ErrorCacheImpl;
import chemaxon.jchem.cartridge.tunnel.search.ErrorRecord;
import chemaxon.jchem.db.status.observers.JCSObserver;

public class DeferredErrorHandler {
    private String sessionId;
    private long scanId;
    private JCSObserver jcsObserver;

    public DeferredErrorHandler(String sessionId, long scanId, JCSObserver jcsObserver) {
        this.sessionId = sessionId;
        this.scanId = scanId;
        this.jcsObserver = jcsObserver;
    }

    public void cacheErrors(String query) {
        int ix;
        int totalCachedErrorCount = 0;
        int count = this.jcsObserver.getStoredQTErrorCount();
        for (ix = 0; ix < count; ++ix) {
            JCSObserver.QTE qte = this.jcsObserver.getStoredQTError(ix);
            String reportedQuery = qte.getQueryAsString();
            ErrorCacheImpl.instance().addErrorRecord(this.sessionId, new ErrorRecord(this.scanId, null, qte.getCDID(), JFunctions.stackTrace(qte.getException()), reportedQuery));
        }
        totalCachedErrorCount += count;
        count = this.jcsObserver.getStoredStructureLoadErrorCount();
        for (ix = 0; ix < count; ++ix) {
            JCSObserver.IDE ide = this.jcsObserver.getStoredStructurLoadError(ix);
            ErrorCacheImpl.instance().addErrorRecord(this.sessionId, new ErrorRecord(this.scanId, null, ide.getCDID(), JFunctions.stackTrace(ide.getException()), query));
        }
        totalCachedErrorCount += count;
        count = this.jcsObserver.getStoredDBErrorCount();
        for (ix = 0; ix < count; ++ix) {
            JCSObserver.EM em = this.jcsObserver.getStoredDBError(ix);
            ErrorCacheImpl.instance().addErrorRecord(this.sessionId, new ErrorRecord(this.scanId, null, 0, JFunctions.stackTrace(em.getException()), query));
        }
        totalCachedErrorCount += count;
        count = this.jcsObserver.getStoredUnexpectedErrorCount();
        for (ix = 0; ix < count; ++ix) {
            Exception e = this.jcsObserver.getStoredUnexpectedError(ix);
            ErrorCacheImpl.instance().addErrorRecord(this.sessionId, new ErrorRecord(this.scanId, null, 0, JFunctions.stackTrace(e), query));
        }
        int reportedErrorCount = this.jcsObserver.getReportedErrorCount();
        if ((totalCachedErrorCount += count) < reportedErrorCount) {
            ErrorCacheImpl.instance().addErrorRecord(this.sessionId, new ErrorRecord(this.scanId, null, 0, totalCachedErrorCount + " of " + reportedErrorCount + " errors are cached for this search", query));
        }
    }
}

