/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.search;

import chemaxon.common.util.IntVector;
import chemaxon.descriptors.InHouseDefaultParser;
import chemaxon.formats.MolExporter;
import chemaxon.jchem.cartridge.server.task.Task;
import chemaxon.jchem.cartridge.servlets.search.DeferredErrorHandler;
import chemaxon.jchem.cartridge.servlets.search.QueryHandlerBase;
import chemaxon.jchem.cartridge.servlets.search.SingleQueryHandler;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiQueryHandler
extends QueryHandlerBase {
    private static Logger logger = Logger.getLogger(MultiQueryHandler.class.getName());
    private Molecule[] queryMols;
    private int[][] queryFps;
    private int currentQueryIdx;
    private SingleQueryHandler currentSingleHandler;
    private IntVector consolidatedHits = new IntVector();
    private int returnedHitCount;

    public MultiQueryHandler(JChemSearch jcSearch, DeferredErrorHandler deferredErrorHandler, Molecule[] queries, int desiredArraySize, ConnectionHandler connectionHandler, Long profilerId) {
        super(connectionHandler, jcSearch, deferredErrorHandler, desiredArraySize, profilerId);
        this.queryMols = queries;
    }

    public MultiQueryHandler(JChemSearch jcSearch, DeferredErrorHandler deferErrorHandler, int[][] queryFps, int desiredArraySize, ConnectionHandler connectionHandler, Long profilerId) {
        super(connectionHandler, jcSearch, deferErrorHandler, desiredArraySize, profilerId);
        this.queryFps = queryFps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        try {
            super.stop();
        }
        finally {
            if (this.currentSingleHandler != null) {
                this.currentSingleHandler.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws Exception {
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Iteration on QueryHandlers has started");
            }
            while (this.status == 1 && this.currentQueryIdx < this.queryMols.length) {
                this.currentSingleHandler = this.createSingleQueryHandler();
                this.currentSingleHandler.start();
                this.unblockHitReturn();
                while (this.currentSingleHandler.isRunning()) {
                    this.consolidateNewHits(this.currentSingleHandler);
                }
                this.consolidateNewHits(this.currentSingleHandler);
                ++this.currentQueryIdx;
            }
        }
        finally {
            this.status = 2;
            IntVector intVector = this.consolidatedHits;
            synchronized (intVector) {
                this.consolidatedHits.notifyAll();
            }
        }
    }

    private SingleQueryHandler createSingleQueryHandler() {
        if (this.queryMols == null) {
            int[] queryFp = this.queryFps[this.currentQueryIdx];
            return new SingleQueryHandler(this.cloneConnectionHandler(), this.jcSearch, this.deferredErrorHandler, queryFp, this.desiredArraySize, this.profileId);
        }
        Molecule queryMol = this.queryMols[this.currentQueryIdx];
        return new SingleQueryHandler(this.cloneConnectionHandler(), this.jcSearch, this.deferredErrorHandler, queryMol, this.desiredArraySize, this.profileId);
    }

    private ConnectionHandler cloneConnectionHandler() {
        ConnectionHandler ch = new ConnectionHandler(this.connectionHandler);
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getMoreHits() throws InterruptedException, ExecutionException, DatabaseSearchException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("desiredArraySize=" + this.desiredArraySize);
        }
        if (this.isInProgressiveMode()) {
            this.checkAsynchResult();
        }
        IntVector intVector = this.consolidatedHits;
        synchronized (intVector) {
            while (this.isRunning() && this.consolidatedHits.size() - this.returnedHitCount < this.desiredArraySize) {
                this.consolidatedHits.wait();
            }
            int[] newHits = new int[this.consolidatedHits.size() - this.returnedHitCount];
            int[] consArr = this.consolidatedHits.toArray();
            System.arraycopy(consArr, this.returnedHitCount, newHits, 0, newHits.length);
            this.returnedHitCount += newHits.length;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("returning " + newHits.length + " hit(s)");
            }
            return newHits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consolidateNewHits(SingleQueryHandler qh) throws DatabaseSearchException, InterruptedException, ExecutionException {
        int[] newHits = qh.getMoreHits();
        IntVector hitsPassedDupCheck = new IntVector();
        IntVector intVector = this.consolidatedHits;
        synchronized (intVector) {
            for (int i = 0; i < newHits.length; ++i) {
                int newHit = newHits[i];
                if (this.consolidatedHits.indexOf(newHit) != -1) continue;
                hitsPassedDupCheck.add(newHit);
            }
            this.consolidatedHits.addAll(hitsPassedDupCheck);
            this.consolidatedHits.notifyAll();
        }
    }

    @Override
    public String getDescription() throws IOException {
        int queryCount = 0;
        StringBuffer sb = new StringBuffer();
        if (this.queryMols == null) {
            queryCount = this.queryFps.length;
            for (int i = 0; i < this.queryFps.length; ++i) {
                int[] fp = this.queryFps[i];
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(InHouseDefaultParser.intArray2String(fp));
            }
        } else {
            queryCount = this.queryMols.length;
            for (int i = 0; i < this.queryMols.length; ++i) {
                Molecule mol = this.queryMols[i];
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(MolExporter.exportToObject(mol, "cxsmarts"));
            }
        }
        return "Query handler for " + queryCount + " queries: " + sb.toString();
    }

    @Override
    public synchronized Long getMemoryUsage() {
        Long jcSearchMem = super.getMemoryUsage();
        if (jcSearchMem == null || jcSearchMem == -1L) {
            return Task.intArrayMemory(this.consolidatedHits.size());
        }
        return jcSearchMem + Task.intArrayMemory(this.consolidatedHits.size());
    }
}

