/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.search;

import chemaxon.descriptors.InHouseDefaultParser;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.jchem.cartridge.profiling.ComputeSearchProfile;
import chemaxon.jchem.cartridge.rmi.impl.JCartProfilerImpl;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.servlets.search.DeferredErrorHandler;
import chemaxon.jchem.cartridge.servlets.search.QueryHandlerBase;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SingleQueryHandler
extends QueryHandlerBase {
    private static final Logger logger = Logger.getLogger(SingleQueryHandler.class.getName());
    private Molecule queryMol;
    private int[] queryFp;
    private boolean nonProgrModeResultServed;

    public SingleQueryHandler(ConnectionHandler connectionHandler, JChemSearch jcSearch, DeferredErrorHandler deferredErrorHandler, Molecule query, int desiredArraySize, Long profilerId) {
        super(connectionHandler, jcSearch, deferredErrorHandler, desiredArraySize, profilerId);
        this.queryMol = query;
    }

    public SingleQueryHandler(ConnectionHandler connectionHandler, JChemSearch jcSearch, DeferredErrorHandler deferErrorHandler, int[] queryFp, int desiredArraySize, Long profilerId) {
        super(connectionHandler, jcSearch, deferErrorHandler, desiredArraySize, profilerId);
        this.queryFp = queryFp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws MolFormatException, DatabaseSearchException, SQLException, IOException, PropertyNotSetException, InterruptedException, ExecutionException {
        try {
            this.runJChemSearch();
        }
        finally {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("search has stopped");
                }
            }
            finally {
                if (this.status != 3) {
                    this.status = 2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runJChemSearch() throws DatabaseSearchException, SQLException, IOException, PropertyNotSetException, InterruptedException, ExecutionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("search for " + this.query() + " on behalf of " + this.connectionHandler.getLoginName() + " has started");
        }
        JCartConnectionManager.getInstance().setConnection(this.connectionHandler);
        try {
            Throwable error;
            ConnectionHandler cmittableCh = new ConnectionHandler(this.connectionHandler.getConnection(), this.connectionHandler.getPropertyTable(), true);
            this.jcSearch.setConnectionHandler(cmittableCh);
            this.setQuery(this.jcSearch);
            SingleQueryHandler.setRuntimeProperties(this.jcSearch);
            this.jcSearch.run();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("JChemSearch.run returned");
            }
            this.unblockHitReturn();
            this.jcSearch.waitUntilSearchComplete();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("JChemSearch.waitUntilSearchComplete returned");
            }
            this.deferredErrorHandler.cacheErrors(this.query());
            if (this.profileId != null) {
                long endSearch = System.currentTimeMillis();
                long startSearch = endSearch - this.jcSearch.getSearchTime();
                ComputeSearchProfile sp = JCartProfilerImpl.getSearchProfileLocal((long)this.profileId.longValue()).computeSearchProfile;
                sp.startSearch = startSearch;
                sp.endSearch = endSearch;
                sp.screeningTime = this.jcSearch.getScreeningTime();
                sp.screenedCount = this.jcSearch.getScreenedCount();
                sp.hitCount = this.jcSearch.getResults().length;
                JChemSearchOptions sop = this.jcSearch.getSearchOptions();
                if (sop.getSearchType() == 3) {
                    float simThreshold = 1.0f - sop.getDissimilarityThreshold();
                    sp.queryParams = " > " + simThreshold;
                }
            }
            if ((error = this.jcSearch.getException()) == null) return;
            if (!(error instanceof IllegalArgumentException)) throw new DatabaseSearchException(error);
            throw (IllegalArgumentException)error;
        }
        finally {
            try {
                this.unblockHitReturn();
            }
            finally {
                try {
                    this.connectionHandler.getConnection().commit();
                }
                catch (Exception exception) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                    this.connectionHandler.getConnection().rollback();
                }
                finally {
                    this.connectionHandler.getConnection().close();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Connection closed for user " + this.connectionHandler.getLoginName() + " searching " + this.query());
                    }
                }
            }
        }
    }

    private void setQuery(JChemSearch jcSearch) {
        if (this.queryMol == null) {
            jcSearch.setQueryFingerprint(this.queryFp);
        } else {
            jcSearch.setQueryStructure(this.queryMol);
        }
    }

    @Override
    public int[] getMoreHits() throws InterruptedException, ExecutionException, DatabaseSearchException {
        int[] moreHits;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.desiredArraySize + " hit(s) requested, status=" + this.status);
        }
        if (this.status == 3) {
            Object var1_1 = null;
        }
        if (this.isInProgressiveMode()) {
            this.checkAsynchResult();
            moreHits = this.jcSearch.getAvailableNewHits(this.desiredArraySize);
        } else {
            int[] allHits = this.jcSearch.getResults();
            if (!this.nonProgrModeResultServed) {
                this.nonProgrModeResultServed = true;
                moreHits = allHits;
            } else {
                moreHits = new int[]{};
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("returning " + moreHits.length + " hit(s)");
        }
        return moreHits;
    }

    protected String query() throws IOException {
        if (this.queryMol == null) {
            return this.toFormat(this.queryFp);
        }
        return this.toFormat(this.queryMol);
    }

    protected String toFormat(Molecule mol) throws IOException {
        return MolExporter.exportToFormat(mol, mol.getInputFormat());
    }

    protected String toFormat(int[] fp) {
        return InHouseDefaultParser.intArray2String(fp);
    }

    @Override
    public String getDescription() throws IOException {
        return "Query handler for " + this.query();
    }
}

