/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.structs;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.MdMetaData;
import chemaxon.jchem.cartridge.tunnel.search.MdScreenParams;

public class MdMetaDataSupport {
    private MdMetaDataSupport() {
    }

    public static String getMdTableNameByMdName(MdMetaData[] mdmda, String mdName) {
        for (int i = 0; i < mdmda.length; ++i) {
            MdMetaData mdmd = mdmda[i];
            if (!mdmd.name.equals(mdName)) continue;
            return mdmd.tableName;
        }
        throw new IllegalArgumentException("No such MD name found: " + mdName);
    }

    public static MdMetaData getMdMetaDataByMdName(MdMetaData[] mdmda, String mdName) {
        for (int i = 0; i < mdmda.length; ++i) {
            MdMetaData mdmd = mdmda[i];
            if (!mdmd.name.equals(mdName)) continue;
            return mdmd;
        }
        throw new IllegalArgumentException("No such MD name found: " + mdName);
    }

    public static String getScreenConfig(MdMetaData[] mdmda, String mdName, String screenConfigName) {
        MdMetaData mdmd = MdMetaDataSupport.getMdMetaDataByMdName(mdmda, mdName);
        for (int i = 0; i < mdmd.configs.length; ++i) {
            String configName = mdmd.configs[i][0];
            if (!configName.equals(screenConfigName)) continue;
            return mdmd.configs[i][1];
        }
        throw new IllegalArgumentException("No such config found for '" + mdName + "': " + screenConfigName);
    }

    public static MdScreenParams getMdScreenParams(JCartIndexDescriptor idxDescriptor, CxOptions cxOptions) throws Exception {
        MdMetaData[] allMdMetaData = idxDescriptor.getAllMdMetaData();
        String molDescName = cxOptions.getStringValue("descriptorName");
        String screenConfigName = cxOptions.getStringValue("screenConfig");
        MdMetaData mdMetaData = MdMetaDataSupport.getMdMetaDataByMdName(allMdMetaData, molDescName);
        String mdScreenConfig = null;
        if (screenConfigName != null) {
            mdScreenConfig = screenConfigName.toLowerCase().startsWith("select ") ? JFunctions.getStringResult(idxDescriptor.getDbSession().getConnection(), screenConfigName) : MdMetaDataSupport.getScreenConfig(allMdMetaData, molDescName, screenConfigName);
        }
        return new MdScreenParams(mdMetaData, mdScreenConfig);
    }
}

