/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.tunnel;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.tunnel.InsertReqData;
import chemaxon.jchem.cartridge.tunnel.codec.ValueObject;
import chemaxon.jchem.interop.InteropUtil;

public class InsertRespData
implements ValueObject {
    public String structure = "\n  Empty structure\n\n  0  0  0  0  0  0            999 V2000\nM  END";
    public String smilesOrSmarts = " ";
    public String formula;
    public Double mass;
    public int hashCode;
    public String flags;
    public int[] fps;
    public String[][] xColNamesAndValues;
    public String[][] ctColNamesAndValues;
    public byte[] markushData;
    public byte[][] mdFps;
    public String genericTautomer;

    public void reset() {
        this.structure = "\n  Empty structure\n\n  0  0  0  0  0  0            999 V2000\nM  END";
        this.smilesOrSmarts = " ";
        this.formula = null;
        this.mass = null;
        this.hashCode = 0;
        this.flags = null;
        this.fps = null;
        this.xColNamesAndValues = null;
        this.ctColNamesAndValues = null;
        this.markushData = null;
        this.mdFps = null;
        this.genericTautomer = null;
    }

    public void setFpsEmpty(InsertReqData insertReqData) {
        int numBits = insertReqData.fingerPrintProps[0];
        int intCount = JFunctions.translateBitCountToIntCount(numBits);
        this.fps = new int[intCount + insertReqData.structuralFpColCount];
        for (int ix = 0; ix < this.fps.length; ++ix) {
            this.fps[ix] = 0;
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("structure=").append(this.structure);
        b.append(", smilesOrSmarts=").append(this.smilesOrSmarts);
        b.append(", formula=").append(this.formula);
        b.append(", mass=").append(this.mass);
        b.append(", hashCode=").append(this.hashCode);
        b.append(", flags=").append(this.flags);
        b.append(", fps=").append(this.fps);
        b.append(", xColNamesAndValues=").append(InteropUtil.flattenStringArrays(this.xColNamesAndValues));
        b.append(", ctColNamesAndValues=").append(InteropUtil.flattenStringArrays(this.ctColNamesAndValues));
        b.append(", markushData(.length)=").append(this.markushData == null ? "null" : String.valueOf(this.markushData.length));
        b.append(", mdFps=").append(this.mdFps);
        b.append(", genericTautomer=").append(this.genericTautomer);
        return b.toString();
    }
}

