/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.tunnel;

import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import java.io.Serializable;

public class TableOpInfo
implements Serializable {
    private String baseSchemaName;
    private String baseTableName;
    private String indexSchemaName;
    private String indexPartition;
    private String indexName;
    private String indexTableQName;
    private boolean jchemTable;
    private String indexedColumn;
    private int indexSubType;
    private String jcpropTableName;
    private SessionInfo sessionInfo;
    private int threadCount;
    private String userAssignedId;

    public TableOpInfo() {
    }

    public TableOpInfo(JCartIndexDescriptor idesc, SessionInfo sessionInfo, String userAssignedId, int threadCount) {
        this.baseSchemaName = idesc.getBaseTableSchema();
        this.baseTableName = idesc.getBaseTableName();
        this.indexSchemaName = idesc.getIndexSchemaName();
        this.indexName = idesc.getIndexName();
        this.indexPartition = idesc.getIndexPartitionName();
        this.jchemTable = idesc.isJChemTable();
        this.indexedColumn = idesc.getColName();
        this.indexTableQName = idesc.getIdxTableQName();
        this.indexSubType = idesc.getIdxSubType();
        this.jcpropTableName = idesc.getJcptName();
        this.setSessionInfo(sessionInfo);
        this.userAssignedId = userAssignedId;
        this.threadCount = threadCount;
    }

    public TableOpInfo(TableOpInfo tableOpInfo) {
        this.baseSchemaName = tableOpInfo.baseSchemaName;
        this.baseTableName = tableOpInfo.baseTableName;
        this.indexSchemaName = tableOpInfo.indexSchemaName;
        this.indexName = tableOpInfo.indexName;
        this.indexPartition = tableOpInfo.indexPartition;
        this.indexTableQName = tableOpInfo.getIndexTableQName();
        this.indexSubType = tableOpInfo.indexSubType;
        this.jcpropTableName = tableOpInfo.jcpropTableName;
        this.setSessionInfo(tableOpInfo.sessionInfo);
        this.userAssignedId = tableOpInfo.userAssignedId;
        this.threadCount = tableOpInfo.threadCount;
    }

    protected TableOpInfo(String baseSchemaName2, String baseTableName2, String indexSchemaName2, String indexName2, String indexPartion, String indexedColumnName, String indexTblName, int idxSubType, String jcpropTableName2, SessionInfo sessionInfo, String userAssignedId, int threadCount) {
        this.baseSchemaName = baseSchemaName2;
        this.baseTableName = baseTableName2;
        this.indexSchemaName = indexSchemaName2;
        this.indexName = indexName2;
        this.indexPartition = indexPartion;
        this.indexedColumn = indexedColumnName;
        this.indexTableQName = indexTblName;
        this.indexSubType = idxSubType;
        this.jcpropTableName = jcpropTableName2;
        this.sessionInfo = sessionInfo;
        this.userAssignedId = userAssignedId;
        this.threadCount = threadCount;
    }

    public String getBaseSchemaName() {
        return this.baseSchemaName;
    }

    public void setBaseSchemaName(String baseSchemaName) {
        this.baseSchemaName = baseSchemaName;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String baseTableName) {
        this.baseTableName = baseTableName;
    }

    public String getIndexSchemaName() {
        return this.indexSchemaName;
    }

    public void setIndexSchemaName(String indexSchemaName) {
        this.indexSchemaName = indexSchemaName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getTableQName() {
        return this.baseSchemaName + "." + this.baseTableName;
    }

    public String getIndexTableQName() {
        return this.indexTableQName;
    }

    public void setIndexTableQName(String indexTableName) {
        this.indexTableQName = indexTableName;
    }

    public int getIndexSubType() {
        return this.indexSubType;
    }

    public void setIndexSubType(int indexSubType) {
        this.indexSubType = indexSubType;
    }

    public String getJcpropTableName() {
        return this.jcpropTableName;
    }

    public void setJcpropTableName(String jcpropTableName) {
        this.jcpropTableName = jcpropTableName;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    public synchronized String getIndexPartition() {
        return this.indexPartition;
    }

    public void setIndexPartition(String indexPartition) {
        this.indexPartition = indexPartition;
    }

    public boolean isJchemTable() {
        return this.jchemTable;
    }

    public void setJchemTable(boolean jchemTable) {
        this.jchemTable = jchemTable;
    }

    public String getIndexedColumn() {
        return this.indexedColumn;
    }

    public void setIndexedColumn(String indexedColumn) {
        this.indexedColumn = indexedColumn;
    }

    public String getUserAssignedId() {
        return this.userAssignedId;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public String toString() {
        return "TableOpInfo[baseSchemaName=" + this.baseSchemaName + ", baseTableName=" + this.baseTableName + ", indexSchemaName=" + this.indexSchemaName + ", indexName=" + this.indexName + ", indexPartition=" + this.indexPartition + ", indexTableQName=" + this.indexTableQName + ", indexSubType=" + this.indexSubType + ", jcpropTableName=" + this.jcpropTableName + ", indexedColumn=" + this.indexedColumn + ", jchemTable=" + this.jchemTable + ", userInfo=" + this.sessionInfo + "]";
    }
}

