/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.tunnel.search;

import java.io.Serializable;

public class PredicateInfo
implements Serializable {
    private double start;
    private double stop;
    private int opFlag;

    public PredicateInfo(double start, double stop, int opFlag) {
        this.start = start;
        this.stop = stop;
        this.opFlag = opFlag;
    }

    public PredicateInfo(String start, String stop, int opFlag) throws Exception {
        this.start = start == null ? Double.NaN : Double.parseDouble(start);
        this.stop = stop == null ? Double.NaN : Double.parseDouble(stop);
        this.opFlag = opFlag;
    }

    public double getStart() {
        return this.start;
    }

    public double getStop() {
        return this.stop;
    }

    public int getOpFlag() {
        return this.opFlag;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.nullOrDouble(this.start));
        sb.append("/");
        sb.append(this.nullOrDouble(this.stop));
        sb.append("/");
        sb.append(this.getOpFlag());
        return sb.toString();
    }

    private String nullOrDouble(double v) {
        return Double.isNaN(v) ? "null" : String.valueOf(v);
    }
}

