/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util;

import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.InHouseGeneratorParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DecimalStringFpParser
implements InHouseGeneratorParser<int[]> {
    private static final Logger logger = Logger.getLogger(DecimalStringFpParser.class.getName());
    private BufferedReader br;
    private String lastLine;
    private DecimalFormat decForm;

    @Override
    public void setReader(BufferedReader b) {
        this.br = b;
    }

    @Override
    public int[] readLine() throws IOException, ParseException {
        String line = this.br.readLine();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("line=" + line);
        }
        this.lastLine = line;
        if (line == null) {
            return null;
        }
        return this.getIntArray(line);
    }

    public int[] getIntArray(String line) throws ParseException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("line=" + line);
        }
        ArrayList<Integer> l = new ArrayList<Integer>();
        String prevToken = null;
        StringTokenizer stringTokenizer = new StringTokenizer(line, "\t");
        while (stringTokenizer.hasMoreTokens()) {
            String no = stringTokenizer.nextToken();
            if (this.decForm == null) {
                CFParameters cfParams = new CFParameters();
                this.decForm = cfParams.getDecForm();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("decForm=" + this.decForm);
                }
            }
            try {
                l.add(new Integer(this.decForm.parse(no).intValue()));
            }
            catch (NumberFormatException nfe) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("NFE in " + line + " with " + no + " after " + prevToken);
                }
                throw nfe;
            }
            prevToken = no;
        }
        StringBuffer debugBuffer = null;
        if (logger.isLoggable(Level.FINER)) {
            debugBuffer = new StringBuffer();
        }
        int[] intArr = new int[l.size()];
        for (int i = 0; i < intArr.length; ++i) {
            intArr[i] = (Integer)l.get(i);
            if (!logger.isLoggable(Level.FINER)) continue;
            if (debugBuffer.length() > 0) {
                debugBuffer.append(", ");
            }
            debugBuffer.append(intArr[i]);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Returning " + debugBuffer.toString());
        }
        return intArr;
    }

    @Override
    public String getLastLine() {
        return null;
    }
}

