/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util.cpool;

import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.jchem.cartridge.util.cpool.JCartDataSource;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleDataSource;

public class Oracle10gDataSource
implements JCartDataSource {
    private static final Logger logger = Logger.getLogger(Oracle10gDataSource.class.getName());
    public static final String PROPERTY_PREFIX = "oracle.connection.cache.";
    private OracleDataSource ods;
    private String login;
    private String password;

    public Oracle10gDataSource(String url, String login, String password) throws IOException, SQLException {
        this.login = login;
        this.password = password;
        this.ods = new OracleDataSource();
        this.ods.setDriverType("thin");
        this.ods.setURL(url);
        this.ods.setConnectionCachingEnabled(true);
        String cacheName = login.toUpperCase();
        try {
            Oracle10gDataSource.cacheManager().createCache(cacheName, this.ods, this.getProperties());
        }
        catch (SQLException sqlException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Failed to create cache with name " + cacheName);
            }
            throw sqlException;
        }
    }

    private Properties getProperties() throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<Object, Object> entry : JccConfig.getInstance().entrySet()) {
            if (!((String)entry.getKey()).startsWith(PROPERTY_PREFIX)) continue;
            String name = ((String)entry.getKey()).substring(PROPERTY_PREFIX.length());
            String value = (String)entry.getValue();
            properties.setProperty(name, value);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Returning " + properties);
        }
        return properties;
    }

    public static OracleConnectionCacheManager cacheManager() throws SQLException {
        return OracleConnectionCacheManager.getConnectionCacheManagerInstance();
    }

    @Override
    public void close() throws Exception {
        this.ods.close();
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Connection borrowed", new Exception());
        }
        try {
            return this.ods.getConnection(this.login, this.password);
        }
        catch (SQLException sqlException) {
            int errorCode = sqlException.getErrorCode();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Error code: " + errorCode);
            }
            if (errorCode == 17143) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Invalid or Stale Connection found in the Connection Cache for " + this.login + ". Purging this cache...");
                }
                this.purge(false);
                return this.ods.getConnection(this.login, this.password);
            }
            throw sqlException;
        }
    }

    @Override
    public void reinitialize() throws Exception {
        Oracle10gDataSource.cacheManager().reinitializeCache(this.login, this.getProperties());
    }

    @Override
    public synchronized void resetPassword(String password) throws SQLException {
        this.password = password;
        Oracle10gDataSource.cacheManager().purgeCache(this.login.toUpperCase(), false);
    }

    @Override
    public synchronized void purge(boolean cleanupCheckedOutConnections) throws SQLException {
        Oracle10gDataSource.cacheManager().purgeCache(this.login.toUpperCase(), cleanupCheckedOutConnections);
    }

    @Override
    public String getLogin() {
        return this.login;
    }
}

