/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cluster;

import chemaxon.jchem.cluster.JChemMasterNode;
import chemaxon.jchem.cluster.JChemNodeClient;
import chemaxon.jchem.cluster.NodeManager;
import chemaxon.jchem.cluster.monitor.HeartBeatMonitor;
import chemaxon.jchem.cluster.monitor.HeartBeatMonitorImpl;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class JChemMasterNodeImpl
extends UnicastRemoteObject
implements JChemMasterNode {
    private static JChemMasterNodeImpl masterInstance;
    private HeartBeatMonitorImpl heartBeatMonitorImpl;
    private Thread nodeRepearThread;

    protected JChemMasterNodeImpl(HeartBeatMonitorImpl heartBeatMonitorImpl) throws RemoteException {
        this.heartBeatMonitorImpl = heartBeatMonitorImpl;
        this.nodeRepearThread = new Thread(heartBeatMonitorImpl);
        this.nodeRepearThread.start();
    }

    @Override
    public HeartBeatMonitor getHeartBeatMonitor() throws RemoteException {
        return this.heartBeatMonitorImpl;
    }

    public JChemNodeClient[] getJChemNodes(String host, int port) throws RemoteException {
        return this.heartBeatMonitorImpl.getJChemNodeClients();
    }

    public synchronized JChemMasterNodeImpl getInstance() {
        return masterInstance;
    }

    public static synchronized void start(int port, long heartBeatInterval) throws Exception {
        if (masterInstance == null) {
            HeartBeatMonitorImpl heartBeatMonitorImpl = new HeartBeatMonitorImpl(masterInstance, heartBeatInterval);
            masterInstance = new JChemMasterNodeImpl(heartBeatMonitorImpl);
            NodeManager nodeManager = new NodeManager(port, masterInstance);
            nodeManager.start();
        }
    }
}

