/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cluster;

import chemaxon.jchem.cluster.JChemNode;
import chemaxon.jchem.cluster.NodeManager;
import chemaxon.jchem.cluster.search.JcSearchNode;
import java.rmi.RemoteException;

public class JChemNodeClient
implements JChemNode {
    private String hostname;
    private int port;
    private JChemNode stub;
    private long timeStamp;

    public JChemNodeClient(String hostname, int port) throws RemoteException {
        this.hostname = hostname;
        this.port = port;
        this.updateTimeStamp();
        this.createStub();
    }

    public void updateTimeStamp() {
        this.timeStamp = System.currentTimeMillis();
    }

    public int hashCode() {
        return (this.hostname + this.port).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JChemNodeClient)) {
            return false;
        }
        JChemNodeClient other = (JChemNodeClient)obj;
        return other.hostname.equals(this.hostname) && other.port == this.port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void createStub() throws RemoteException {
        if (this.stub != null) {
            throw new IllegalStateException("Stub alread exists");
        }
        try {
            this.stub = (JChemNode)NodeManager.getRemoteStub(this.hostname, this.port);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception c) {
            throw new RuntimeException(c);
        }
    }

    @Override
    public int getAvailableProcessors() throws RemoteException {
        this.checkStub(true);
        return this.stub.getAvailableProcessors();
    }

    @Override
    public JcSearchNode getJcSearchNode() throws RemoteException {
        throw new RuntimeException("Unimplemented");
    }

    public void reapNode() throws RemoteException {
        this.stub = null;
    }

    private void checkStub(boolean mustHaveStub) {
        if (mustHaveStub == (this.stub != null)) {
            return;
        }
        if (mustHaveStub) {
            throw new IllegalStateException("Stub does not exists");
        }
        throw new IllegalStateException("Stub already exists");
    }
}

