/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cluster;

import chemaxon.jchem.cluster.JChemNodeImpl;
import chemaxon.jchem.cluster.monitor.HeartBeatGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NodeManager
extends Thread {
    private static Logger logger = Logger.getLogger(NodeManager.class.getName());
    public static final int DEFAULT_PORT = 1099;
    private static NodeManager instance;
    private Remote entryPoint;
    private int port;
    private volatile boolean accept = true;
    private ServerSocket serverSocket;
    private Throwable error;
    private CountDownLatch startSignal = new CountDownLatch(1);

    public NodeManager(int port, Remote entryPoint) throws RemoteException {
        this.entryPoint = entryPoint;
        this.port = port == -1 ? 1099 : port;
    }

    @Override
    public void run() {
        block4: {
            try {
                this.serverSocket = new ServerSocket(this.port);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Listening on network interface " + this.serverSocket.getInetAddress() + " at port " + this.port + "...");
                }
                this.startSignal.countDown();
                while (this.accept) {
                    Socket clientSocket = this.serverSocket.accept();
                    new RemoteRefDispenser(clientSocket).start();
                }
            }
            catch (Throwable tbl) {
                if (!this.accept) break block4;
                this.error = tbl;
            }
        }
    }

    public void shutdown() {
        this.accept = false;
        Thread t = new Thread(){

            @Override
            public void run() {
                block2: {
                    try {
                        NodeManager.this.serverSocket.close();
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(Level.SEVERE)) break block2;
                        logger.log(Level.SEVERE, "error", exception);
                    }
                }
            }
        };
        t.start();
    }

    public static void startNoWait(int port, Remote entryPoint) throws Exception {
        NodeManager.start(port, entryPoint, true);
    }

    public static void start(int port, Remote entryPoint) throws Exception {
        NodeManager.start(port, entryPoint, false);
    }

    public static void start(int port, Remote entryPoint, boolean noWait) throws Exception {
        instance = new NodeManager(port, entryPoint);
        instance.start();
        NodeManager.instance.startSignal.await();
        if (!noWait) {
            instance.join();
        }
        if (NodeManager.instance.error != null) {
            Throwable error = NodeManager.instance.error;
            System.err.println(error.getMessage());
            logger.log(Level.FINE, "error", error);
            System.exit(1);
        }
    }

    public static void shutdownInstance() {
        instance.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getRemoteStub(String host, int port) throws Exception {
        Socket s = new Socket(host, port);
        try {
            ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
            Object object = ois.readObject();
            return object;
        }
        finally {
            s.close();
        }
    }

    public static String getProperty(String[] args, String cmdLineOpt, String propKey, String dfltValue) throws Exception {
        String propValue = NodeManager.getPropertyFromArgs(args, cmdLineOpt);
        if (propValue == null) {
            propValue = NodeManager.getPropertyFromFile(propKey);
        }
        if (propValue == null) {
            propValue = dfltValue;
        }
        return propValue;
    }

    public static String getProperty(String propKey, String dfltValue) throws Exception {
        String propValue = NodeManager.getPropertyFromFile(propKey);
        if (propValue == null) {
            propValue = dfltValue;
        }
        return propValue;
    }

    private static String getPropertyFromArgs(String[] args, String cmdLineOpt) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals(cmdLineOpt)) continue;
            return args[i + 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPropertyFromFile(String propKey) throws Exception {
        String propValue = null;
        File f = new File("node_manager.properties");
        if (f.exists()) {
            Properties props = new Properties();
            FileInputStream istream = new FileInputStream(f);
            try {
                props.load(istream);
            }
            finally {
                ((InputStream)istream).close();
            }
            return props.getProperty(propKey);
        }
        return propValue;
    }

    public static void main(String[] args) throws Exception {
        String port = NodeManager.getProperty(args, "local_port", "local.port", "-1");
        String masterHost = NodeManager.getProperty(args, "master_host", "master.host", "-1");
        String masterPort = NodeManager.getProperty(args, "master_port", "master.port", "-1");
        try {
            HeartBeatGenerator heartBeatGenerator = new HeartBeatGenerator(masterHost, Integer.parseInt(masterPort), Integer.parseInt(port));
            NodeManager.start(Integer.parseInt(port), new JChemNodeImpl(heartBeatGenerator));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class RemoteRefDispenser
    extends Thread {
        private Socket s;

        public RemoteRefDispenser(Socket s) {
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ObjectOutputStream oos = null;
            try {
                Remote remote = NodeManager.this.entryPoint;
                synchronized (remote) {
                    oos = new ObjectOutputStream(this.s.getOutputStream());
                    oos.writeObject(RemoteObject.toStub(NodeManager.this.entryPoint));
                }
            }
            catch (Throwable tbl) {
                tbl.printStackTrace();
            }
            finally {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (Throwable tbl) {
                    tbl.printStackTrace();
                }
            }
        }
    }
}

