/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cluster.monitor;

import chemaxon.jchem.cluster.JChemNodeImpl;
import chemaxon.jchem.cluster.NodeManager;
import chemaxon.jchem.cluster.monitor.HeartBeatMonitor;
import chemaxon.jchem.cluster.util.Trace;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.rmi.RemoteException;
import org.neilja.net.interruptiblermi.InterruptibleRMIThreadFactory;

public class HeartBeatGenerator
extends Thread {
    private JChemNodeImpl node;
    private long connectRetryInterval = 1000L;
    private String masterHost;
    private int masterPort;
    private long beatInterval = 5000L;
    private int slavePort;
    private long beatCount;

    public HeartBeatGenerator(String masterHost, int masterPort, int slavePort) {
        this.masterHost = masterHost;
        this.masterPort = masterPort;
        this.slavePort = slavePort;
    }

    public void setNode(JChemNodeImpl node) {
        this.node = node;
    }

    @Override
    public void run() {
        this.setName("HeartBeatGenerator - TimeoutWatcher");
        try {
            while (true) {
                HeartBeatMonitor hm = this.connect();
                this.beat(hm);
                this.node.shutdownWorkers();
            }
        }
        catch (Throwable tbl) {
            Trace.err(tbl);
            return;
        }
    }

    public HeartBeatMonitor connect() throws Exception {
        int failCount = 0;
        String masterDescriptor = this.masterHost + ":" + this.masterPort;
        SocketException error = null;
        while (true) {
            try {
                if (failCount == 0) {
                    Trace.info("Trying to connect to " + masterDescriptor + "...");
                }
                HeartBeatMonitor hm = (HeartBeatMonitor)NodeManager.getRemoteStub(this.masterHost, this.masterPort);
                Trace.info("Connected to master at " + masterDescriptor);
                return hm;
            }
            catch (ConnectException connectException) {
                error = connectException;
            }
            catch (NoRouteToHostException noRouteToHostException) {
                error = noRouteToHostException;
            }
            catch (Exception e) {
                throw e;
            }
            if (failCount % 100 == 0) {
                Trace.err("Cannot connect to master at " + masterDescriptor + ": \"" + error.getMessage() + "\"");
                Trace.err("Retrying to connect each " + this.connectRetryInterval / 1000L + " second(s)...");
                ++failCount;
            }
            Thread.sleep(this.connectRetryInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beat(HeartBeatMonitor hm) throws RemoteException, InterruptedException {
        Beater beater = new Beater(hm);
        beater.start();
        long prevBeatCount = 0L;
        while (true) {
            Beater beater2 = beater;
            synchronized (beater2) {
                long checkInterval = this.beatInterval * 2L;
                Trace.debug("About to wait " + checkInterval / 1000L + " second(s)");
                beater.wait(checkInterval);
                Trace.debug("beatCount=" + this.beatCount + ", prevBeatCount=" + prevBeatCount);
                if (this.beatCount == prevBeatCount) {
                    this.handleBeaterHung(beater);
                    return;
                }
                prevBeatCount = this.beatCount;
            }
        }
    }

    private void handleBeaterHung(Beater beater) {
        boolean recoverable = false;
        Throwable error = beater.getError();
        if (error != null) {
            if (error instanceof ConnectException) {
                recoverable = true;
            } else if (error instanceof RemoteException) {
                recoverable = true;
            }
        } else {
            recoverable = true;
        }
        if (recoverable) {
            Trace.err("Possible problem with the master node.");
            beater.stopWork();
            return;
        }
        throw new RuntimeException(error);
    }

    public static void main(String[] args) throws Exception {
        String masterHost = "localhost";
        if (args.length > 0) {
            masterHost = args[0];
        }
        HeartBeatGenerator nh = new HeartBeatGenerator(masterHost, 1099, 1099);
        nh.start();
        nh.join();
    }

    private class Beater
    extends Thread {
        private HeartBeatMonitor hm;
        private Thread iRmiClientThread;
        private Throwable error;
        private volatile boolean goOn = true;

        public Beater(HeartBeatMonitor hm) {
            this.hm = hm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            String threadName = "HeartBeatGenerator - Beater";
            this.setName("HeartBeatGenerator - Beater");
            try {
                while (true) {
                    long start = System.currentTimeMillis();
                    this.doInterruptibleRMICall("HeartBeatGenerator - Beater");
                    long end = System.currentTimeMillis();
                    Trace.debug("\"Safe\" heart beat took " + (end - start) + " millisecond(s)");
                    if (this.goOn) {
                        Trace.debug("About to wait " + HeartBeatGenerator.this.beatInterval / 1000L + " second(s)");
                        this.wait(HeartBeatGenerator.this.beatInterval);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable tbl) {
                this.error = tbl;
                HeartBeatGenerator heartBeatGenerator = HeartBeatGenerator.this;
                synchronized (heartBeatGenerator) {
                    HeartBeatGenerator.this.notify();
                }
            }
            Trace.debug("Beater finishing...");
        }

        private void doInterruptibleRMICall(final String parentThreadName) throws Throwable {
            final Beater synch = this;
            Runnable iRmiClientRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block24: {
                        try {
                            Object object = synch;
                            synchronized (object) {
                            }
                            Beater.this.setName(parentThreadName + " - InterruptibleRMICaller");
                            long l_beatInterval = Beater.this.hm.beat(HeartBeatGenerator.this.slavePort);
                            Object object2 = synch;
                            synchronized (object2) {
                                HeartBeatGenerator.this.beatCount++;
                                HeartBeatGenerator.this.beatInterval = l_beatInterval;
                            }
                        }
                        catch (Throwable tbl) {
                            if (Thread.interrupted()) {
                                Trace.info("iRmiClientThread has been interrupted: " + tbl.getMessage());
                                break block24;
                            }
                            Object object = synch;
                            synchronized (object) {
                                Beater.this.error = tbl;
                            }
                        }
                        finally {
                            Object l_beatInterval = synch;
                            synchronized (l_beatInterval) {
                                synch.notifyAll();
                            }
                        }
                    }
                }
            };
            this.iRmiClientThread = InterruptibleRMIThreadFactory.getInstance().newThread(iRmiClientRunnable);
            this.iRmiClientThread.start();
            this.wait();
            this.iRmiClientThread = null;
            if (this.error != null) {
                throw this.error;
            }
        }

        public synchronized Throwable getError() {
            return this.error;
        }

        public synchronized void stopWork() {
            this.goOn = false;
            if (this.iRmiClientThread != null) {
                this.iRmiClientThread.interrupt();
            }
            this.interrupt();
        }
    }
}

