/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.CacheRegistrationUtil;
import chemaxon.jchem.db.CommitablePreparedStatement;
import chemaxon.jchem.db.CommitableStatement;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.JChemCache;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.jchem.db.TableInfo;
import chemaxon.util.ConnectionHandler;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

final class CachePool
implements Serializable {
    private static Logger logger = Logger.getLogger(CachePool.class.getName());
    private static final int MEGABYTE_SIZE = 0x100000;
    private static final int HOUR_IN_MS = 3600000;
    Hashtable<String, JChemCache> cacheHash = new Hashtable();
    long maxCacheMemory = -1L;
    public static final int DETECT = -1;
    public static final double DEFAULT_EXPIRATION_TIME = 0.0;
    private double expirationTime = 0.0;
    static long cacheRegistrationTimeout = 86400000L;
    static long cacheAdministrationTimeout = 3600000L;

    CachePool() {
    }

    public synchronized void setMemSize(int maxCacheSizeMB, int minFreeMemMB) {
        if (this.maxCacheMemory >= 0L) {
            return;
        }
        long maxCacheSize = maxCacheSizeMB;
        long minFreeMem = minFreeMemMB;
        if (maxCacheSize != -1L) {
            if (maxCacheSize < 0L) {
                maxCacheSize = 0L;
            }
            maxCacheSize *= 0x100000L;
        }
        if (minFreeMem != -1L) {
            if (minFreeMem < 0L) {
                minFreeMem = 0L;
            }
            minFreeMem *= 0x100000L;
        }
        if (minFreeMem != 0L || maxCacheSize == -1L) {
            Runtime rt = Runtime.getRuntime();
            long max = 0L;
            try {
                max = rt.maxMemory();
            }
            catch (NoSuchMethodError e) {
                this.maxCacheMemory = Long.MAX_VALUE;
                return;
            }
            System.gc();
            long total = rt.totalMemory();
            long free = rt.freeMemory();
            long available = max - total + free;
            if (minFreeMem == -1L) {
                minFreeMem = available / 10L;
                if (minFreeMem < 0x1400000L) {
                    minFreeMem = 0x1400000L;
                }
                if (minFreeMem > 0x6400000L) {
                    minFreeMem = 0x6400000L;
                }
            }
            long toAllocate = available - minFreeMem;
            if (maxCacheSize == -1L && (maxCacheSize = available - minFreeMem) < 0L) {
                maxCacheSize = 0L;
            }
            this.maxCacheMemory = toAllocate < maxCacheSize ? toAllocate : maxCacheSize;
        } else {
            this.maxCacheMemory = maxCacheSize;
        }
        if (this.maxCacheMemory < 0L) {
            this.maxCacheMemory = 0L;
        }
    }

    public synchronized JChemCache getCache(String hashKey) {
        JChemCache cache = this.cacheHash.get(hashKey);
        return cache;
    }

    public synchronized void clear() {
        this.cacheHash.clear();
    }

    public long getTotalCacheSize() {
        long result = 0L;
        Enumeration<JChemCache> e = this.cacheHash.elements();
        while (e.hasMoreElements()) {
            result += e.nextElement().getSize();
        }
        return result;
    }

    public synchronized void put(String structureTableHashKey, JChemCache cache) {
        this.cacheHash.put(structureTableHashKey, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean dropOneTableCache(String hashKey) {
        Enumeration<String> e = this.cacheHash.keys();
        if (hashKey == null) {
            hashKey = "";
        }
        long oldestSearch = Long.MAX_VALUE;
        String cacheToRemove = null;
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.equals(hashKey)) continue;
            JChemCache cache = this.cacheHash.get(key);
            int searcherCount = 0;
            List<JChemSearch> list = cache.getSearchers();
            synchronized (list) {
                searcherCount = cache.getSearchers().size();
            }
            if (searcherCount != 0 || cache.getLastSearch() >= oldestSearch) continue;
            oldestSearch = cache.getLastSearch();
            cacheToRemove = key;
        }
        if (cacheToRemove != null) {
            String tableNameToDrop = cacheToRemove.startsWith("PT_ID_") ? cacheToRemove.substring(cacheToRemove.indexOf(".") + 1) : cacheToRemove;
            logger.log(Level.FINER, "Table " + tableNameToDrop + " is dropped in dropOneTableCache()");
            System.err.println("WARNING: Due to lack of memory the following table had to be dropped from the cache: " + tableNameToDrop);
            this.cacheHash.remove(cacheToRemove);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void purgeExpiredTables(String tableToExclude, String hashKey, List<String> existingTables) {
        StringBuffer logMsg = null;
        boolean finerLogEnabled = logger.isLoggable(Level.FINER);
        boolean finestLogEnabled = logger.isLoggable(Level.FINEST);
        if (hashKey.startsWith("PT_ID_")) {
            String ptid = hashKey.substring(0, hashKey.indexOf("."));
            if (tableToExclude == null) {
                tableToExclude = "";
            }
            if (finerLogEnabled) {
                logger.log(Level.FINER, "Purging expired tables");
            }
            if (finestLogEnabled) {
                logMsg = new StringBuffer("\n Property table ID: " + ptid + "\n");
                logMsg.append(" Table to exclude: " + tableToExclude + "\n");
                logMsg.append(" Hash key: " + hashKey + "\n");
                logMsg.append(" Existing tables\n");
                for (String key : existingTables) {
                    logMsg.append("** " + key + "\n");
                }
                logMsg.append("\n");
                logMsg.append(" Table(s) found\n");
                logger.log(Level.FINEST, logMsg.toString());
            }
            Vector<String> cachesToDelete = new Vector<String>();
            Enumeration<String> k = this.cacheHash.keys();
            logMsg = new StringBuffer(" Table(s) found\n");
            while (k.hasMoreElements()) {
                String tableName;
                String key = k.nextElement();
                if (!key.contains(ptid)) continue;
                String string = tableName = key.startsWith("PT_ID_") ? key.substring(key.indexOf(".") + 1) : key;
                if (finestLogEnabled) {
                    logMsg.append("** Hash key: " + key + "\n");
                    logMsg.append("**** Tablename: " + tableName + "\n");
                }
                if (key.equals(hashKey) || existingTables.contains(tableName)) continue;
                cachesToDelete.add(key);
            }
            if (finestLogEnabled) {
                logger.log(Level.FINEST, logMsg.toString());
            }
            if (finerLogEnabled) {
                logMsg = new StringBuffer(" Table(s) deleted from cachepool:\n");
            }
            Enumeration d = cachesToDelete.elements();
            while (d.hasMoreElements()) {
                String table = (String)d.nextElement();
                this.cacheHash.remove(table);
                if (!finerLogEnabled) continue;
                logMsg.append("** " + table + "\n");
            }
            if (finerLogEnabled) {
                logMsg.append("\n");
                logger.log(Level.FINER, logMsg.toString());
            }
        } else if (finerLogEnabled) {
            logger.log(Level.FINER, " No appropriate property table identifier exists!\n\n");
        }
        if (this.expirationTime <= 0.0) {
            return;
        }
        if (finerLogEnabled) {
            logMsg = new StringBuffer(" Cashes removed due to expiration:\n");
        }
        Enumeration<String> e = this.cacheHash.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.equals(hashKey)) continue;
            JChemCache cache = this.cacheHash.get(key);
            double elapsedHours = System.currentTimeMillis() - cache.getLastSearch();
            elapsedHours /= 3600000.0;
            int searcherCount = 0;
            List<JChemSearch> list = cache.getSearchers();
            synchronized (list) {
                searcherCount = cache.getSearchers().size();
            }
            if (!(elapsedHours > this.expirationTime) || searcherCount != 0) continue;
            this.cacheHash.remove(key);
            if (!finerLogEnabled) continue;
            logMsg.append("** " + key + "\n");
        }
        if (finerLogEnabled) {
            logMsg.append("\n");
            logger.log(Level.FINER, logMsg.toString());
        }
    }

    public synchronized void setExpirationTime(double expirationTime) {
        this.expirationTime = expirationTime;
    }

    public synchronized Hashtable<String, Long> getCachedTables(boolean performLog) {
        boolean finestLogEnabled;
        Hashtable<String, Long> result = new Hashtable<String, Long>();
        ArrayList<String> keys = new ArrayList<String>();
        Enumeration<String> e = this.cacheHash.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            keys.add(key);
        }
        Collections.sort(keys);
        int size = keys.size();
        boolean bl = finestLogEnabled = logger.isLoggable(Level.FINEST) && performLog;
        if (finestLogEnabled) {
            logger.log(Level.FINEST, "\nLoaded caches:");
        }
        for (int x = 0; x < size; ++x) {
            String key = (String)keys.get(x);
            JChemCache cache = this.cacheHash.get(key);
            long memSize = cache.getSize();
            result.put(key, new Long(memSize));
            if (!finestLogEnabled) continue;
            logger.log(Level.FINEST, "** Hash key: " + key + ", estimated size: " + memSize);
        }
        return result;
    }

    boolean freeMemoryIfNecessary(JChemCache sCache) {
        long totalSize = this.getTotalCacheSize();
        while (totalSize > this.maxCacheMemory) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "\nTrying to drop a structure cache  due to lack of sufficient memory!\nCurrent cache estimated size: " + sCache.getSize() + "\nTotal estimated size:" + totalSize + "\nMax. size:" + this.maxCacheMemory);
            }
            if (this.dropOneTableCache(sCache.cacheHashKey)) {
                if (logger.isLoggable(Level.FINEST)) {
                    this.getCachedTables(true);
                }
            } else {
                return false;
            }
            totalSize = this.getTotalCacheSize();
        }
        return true;
    }

    static void setCacheRegistrationTimeout(long value) {
        cacheRegistrationTimeout = value;
    }

    static void setCacheAdministrationTimeout(long value) {
        cacheAdministrationTimeout = value;
    }

    static void manageRegistration(String cacheID, boolean permanent, long registrationTime, ConnectionHandler conh, JChemObserverImpl obs) throws SQLException {
        if (CachePool.isRegistered(cacheID, conh, obs)) {
            if (!permanent) {
                CachePool.updateCacheRegistration(cacheID, registrationTime, conh, obs);
            }
        } else {
            CachePool.tryRegistration(cacheID, permanent, registrationTime, conh, obs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRegistered(String cacheID, ConnectionHandler conh, JChemObserverImpl obs) throws SQLException {
        boolean ret = false;
        String crTable = DatabaseProperties.getCacheRegistrationTableName(conh);
        String sql = "SELECT cache_id FROM " + crTable + " WHERE " + "cache_id" + "='" + cacheID + "'";
        if (JChemCache.logger.isLoggable(Level.FINER)) {
            JChemCache.logger.log(Level.FINER, "\nSQL for deciding whether cache is registered:\n  " + sql);
        }
        CommitableStatement stmt = CommitableStatement.create(conh);
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                if (rs.next()) {
                    ret = true;
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        obs.lockStateAfterTableRegistered(crTable, conh);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeLogsForExpiredCaches(ConnectionHandler conh, ArrayList<String> expiredCacheIds, List<String> tableNames, JChemObserverImpl obs) throws SQLException {
        boolean finerLogEnabled = JChemCache.logger.isLoggable(Level.FINER);
        boolean finestLogEnabled = JChemCache.logger.isLoggable(Level.FINEST);
        block5: for (int i = 0; i < tableNames.size(); ++i) {
            String tableName = tableNames.get(i);
            String logTableToPurge = TableInfo.getLogTableName(tableName);
            String sql_deletelog = "DELETE FROM " + logTableToPurge + " WHERE " + "cache_id" + "=?";
            if (finerLogEnabled) {
                JChemCache.logger.log(Level.FINER, "\nSQL for purging expired log records from table " + logTableToPurge + "\n  " + sql_deletelog);
            }
            CommitablePreparedStatement pstmt = CommitablePreparedStatement.create(conh, sql_deletelog);
            try {
                for (int j = 0; j < expiredCacheIds.size(); ++j) {
                    String cacheID = expiredCacheIds.get(j);
                    if (finestLogEnabled) {
                        JChemCache.logger.log(Level.FINEST, "** Cache ID: " + cacheID);
                    }
                    pstmt.setString(1, cacheID);
                    try {
                        pstmt.execute();
                        obs.lockStateAfterLogTablePurge(logTableToPurge, conh);
                    }
                    catch (SQLException e) {
                        if (finerLogEnabled) {
                            JChemCache.logger.log(Level.FINER, "Could not purge or commit deletion of expired cache-records from table " + logTableToPurge + ".", e);
                        }
                        obs.lockStateAfterLogTablePurgeException(logTableToPurge, conh);
                        pstmt.close();
                        pstmt.close();
                        continue block5;
                    }
                }
            }
            catch (Throwable throwable) {
                pstmt.close();
                throw throwable;
            }
            {
                continue;
            }
            pstmt.close();
        }
    }

    static void removeLogsForExpiredCaches(ConnectionHandler conh, ArrayList<String> expiredCacheIds, boolean indexTable, JChemObserverImpl obs) throws SQLException {
        DatabaseProperties dbProps = new DatabaseProperties(conh, indexTable);
        CachePool.removeLogsForExpiredCaches(conh, expiredCacheIds, dbProps.getStructureTableNames(), obs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteExpiredCacheRegistrationsAndLogs(String excludedCacheID, ConnectionHandler conh, JChemObserverImpl obs) throws SQLException {
        boolean finerLogEnabled = JChemCache.logger.isLoggable(Level.FINER);
        Connection con = conh.getConnection();
        String timestampInPast = new Timestamp(System.currentTimeMillis() - cacheRegistrationTimeout).toString();
        String crTable = DatabaseProperties.getCacheRegistrationTableName(conh);
        String sql_postfix = " FROM " + crTable + " WHERE (" + "registration_time" + "<'" + timestampInPast + "')" + " AND (" + "is_protected" + "=0)" + " AND " + "cache_id" + "<>'" + excludedCacheID + "'";
        String sql_retrive = "SELECT cache_id" + sql_postfix + " GROUP BY " + "cache_id";
        if (finerLogEnabled) {
            JChemCache.logger.log(Level.FINER, "\nSQL for selecting temporary caches when deleting expired cache registrations:\n  " + sql_retrive);
        }
        ArrayList<String> temp_caches = new ArrayList<String>();
        CommitableStatement stmt = CommitableStatement.create(conh);
        try {
            ResultSet rs = stmt.executeQuery(sql_retrive);
            try {
                while (rs.next()) {
                    temp_caches.add(rs.getString(1));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        if (temp_caches.size() > 0) {
            CachePool.removeLogsForExpiredCaches(conh, temp_caches, true, obs);
            CachePool.removeLogsForExpiredCaches(conh, temp_caches, false, obs);
            String sql_delete = "DELETE " + sql_postfix;
            if (finerLogEnabled) {
                JChemCache.logger.log(Level.FINER, "\nSQL for removing cache registrations:\n  " + sql_delete);
            }
            CommitableStatement stmtForDelete = CommitableStatement.create(conh);
            try {
                stmtForDelete.executeUpdate(sql_delete);
                obs.lockStateAfterCRTableDeleteMarked(crTable, conh);
            }
            finally {
                stmtForDelete.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateCacheRegistration(String cacheID, long registrationTime, ConnectionHandler conh, JChemObserverImpl obs) throws SQLException {
        String timestamp = new Timestamp(registrationTime).toString();
        String crTable = DatabaseProperties.getCacheRegistrationTableName(conh);
        String sql = "UPDATE " + crTable + " SET " + "registration_time" + "='" + timestamp + "'" + " WHERE " + "cache_id" + "='" + cacheID + "'";
        if (JChemCache.logger.isLoggable(Level.FINER)) {
            JChemCache.logger.log(Level.FINER, "\nSQL for updating registration:\n  " + sql);
        }
        CommitableStatement stmt = CommitableStatement.create(conh);
        try {
            stmt.executeUpdate(sql);
            obs.lockStateAfterCRTableDeleteMarked(crTable, conh);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteMarkedLogRecords(String logTableName, String markID, ConnectionHandler conh, JChemObserverImpl obs) throws SQLException {
        CommitableStatement stmt = CommitableStatement.create(conh);
        String sql = "DELETE FROM " + logTableName + " WHERE " + "cache_id" + "='" + markID + "'";
        if (JChemCache.logger.isLoggable(Level.FINER)) {
            JChemCache.logger.log(Level.FINER, "\nSQL for deleting marked log records:\n  " + sql);
        }
        try {
            stmt.executeUpdate(sql);
            obs.lockStateAfterCRTableDeleteMarked(logTableName, conh);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void markLogRecords(String cacheID, String logTableName, String markID, ConnectionHandler conh, JChemObserverImpl obs) throws SQLException {
        CommitableStatement stmt = CommitableStatement.create(conh);
        String sql = "UPDATE " + logTableName + " SET " + "cache_id" + "='" + markID + "'" + " WHERE " + "cache_id" + "='" + cacheID + "'";
        if (JChemCache.logger.isLoggable(Level.FINER)) {
            JChemCache.logger.log(Level.FINER, "\nSQL for marking log records:\n  " + sql);
        }
        try {
            stmt.executeUpdate(sql);
            obs.lockStateAfterCRTableMark(logTableName, conh);
        }
        finally {
            stmt.close();
        }
    }

    private static void tryRegistration(String cacheID, boolean permanent, long registrationTime, ConnectionHandler conh, JChemObserverImpl obs) throws SQLException {
        String cacheRegisterTableName = DatabaseProperties.getCacheRegistrationTableName(conh);
        String propertyTableName = conh.getPropertyTable();
        CacheRegistrationUtil cru = new CacheRegistrationUtil(conh, obs);
        cru.registerCache(cacheRegisterTableName, cacheID, permanent, propertyTableName, new Timestamp(registrationTime).toString(), false);
    }
}

