/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.CacheRegistrationInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class CacheRegistrationBase {
    public static final String CACHE_ID_FIELD_NAME = "cache_id";
    public static final String CACHE_TIME_FIELD_NAME = "registration_time";
    public static final String CACHE_PROTECTED_FIELD_NAME = "is_protected";
    public static final int CACHE_ID_LENGTH = 32;
    public static final String CACHE_UPDATE_ID_FIELD_NAME = "update_id";
    public static final String CACHE_UPDATE_INFO_FIELD_NAME = "update_info";
    public static final String PROP_CACHE_REGISTRATION_TABLE_NAME = "cache.registration_table";
    public static final String PROP_CACHE_VALIDITY_TIMESTAMP = "cache.validity_timestamp";
    protected Connection con;
    protected String propertyTable;
    protected String cacheTable;

    public CacheRegistrationBase(Connection con, String propertyTable) throws SQLException {
        this.con = con;
        this.propertyTable = propertyTable;
        this.cacheTable = propertyTable + "_CR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheRegistrationInfo[] getCacheRegistrationInfos() throws SQLException {
        ArrayList<CacheRegistrationInfo> ret = new ArrayList<CacheRegistrationInfo>();
        Statement stmt = this.con.createStatement();
        try {
            String sqlCaches = "SELECT cache_id, is_protected, registration_time FROM " + this.cacheTable;
            ResultSet rs = stmt.executeQuery(sqlCaches);
            try {
                while (rs.next()) {
                    ret.add(new CacheRegistrationInfo(rs.getString(1), rs.getInt(2) != 0, rs.getString(3)));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        CacheRegistrationInfo[] cri = new CacheRegistrationInfo[ret.size()];
        ret.toArray(cri);
        return cri;
    }
}

