/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.CacheRegistrationBase;
import chemaxon.jchem.db.CacheRegistrationInfo;
import chemaxon.jchem.db.CommitablePreparedStatement;
import chemaxon.jchem.db.CommitableStatement;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.util.ConnectionHandler;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheRegistrationUtil
extends CacheRegistrationBase {
    private static final Logger logger = Logger.getLogger(CacheRegistrationUtil.class.getName());
    public static final String PROP_CACHE_REGISTRATION_SENSITIVITY = "cache.registration_sensitivity";
    public static final String CACHE_REGISTRATION_SENSITIVITY_EXCEPTION = "EXCEPTION";
    public static final String CACHE_REGISTRATION_SENSITIVITY_LOG = "LOG";
    public static final String CACHE_REGISTRATION_SENSITIVITY_NONE = "NONE";
    protected static String cacheID = CacheRegistrationUtil.generateRandomID();
    protected static boolean permanent = false;
    private ConnectionHandler conh = null;
    private final JChemObserverImpl obs;

    public CacheRegistrationUtil(ConnectionHandler conh) throws SQLException {
        super(conh.getConnection(), conh.getPropertyTable());
        this.conh = conh;
        this.obs = JChemObserverImpl.create(null);
    }

    CacheRegistrationUtil(ConnectionHandler conh, JChemObserverImpl obs) throws SQLException {
        super(conh.getConnection(), conh.getPropertyTable());
        this.conh = conh;
        this.obs = obs;
    }

    public void registerCache() throws SQLException {
        this.registerCache(this.cacheTable, cacheID, permanent, this.propertyTable, new Timestamp(System.currentTimeMillis()).toString(), true);
    }

    public void registerPermanentCache(String cacheID) throws SQLException {
        CacheRegistrationUtil.cacheID = cacheID;
        this.registerCache(this.cacheTable, cacheID, true, this.propertyTable, new Timestamp(System.currentTimeMillis()).toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerCache(String registerTablename, String cacheID, boolean permanent, String propertyTableName, String timestamp, boolean updateTimestamp) throws SQLException {
        String sql = this.getCacheRegisterer(registerTablename, cacheID, timestamp, permanent);
        Connection c = null;
        c = this.con.getAutoCommit() ? this.con : DriverManager.getConnection(this.conh.getUrl(), this.conh.getLoginName(), this.conh.getPassword());
        Statement stmt = c.createStatement();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nSQL for cache registration:\n  " + sql);
        }
        try {
            stmt.execute(sql);
            if (updateTimestamp) {
                this.updateValidityTimestamp(timestamp, c);
            }
            if (!c.getAutoCommit()) {
                c.commit();
            }
        }
        catch (SQLException e) {
            DatabaseProperties dp = new DatabaseProperties(this.conh, false);
            String sensitivity = dp.getProperty(PROP_CACHE_REGISTRATION_SENSITIVITY);
            if (sensitivity == null || sensitivity.equalsIgnoreCase(CACHE_REGISTRATION_SENSITIVITY_EXCEPTION)) {
                throw e;
            }
        }
        finally {
            stmt.close();
        }
        this.obs.lockStateAfterRegisteringCache(registerTablename, this.conh);
    }

    public void unRegisterCache() throws SQLException {
        this.unRegisterCache(this.cacheTable, cacheID, this.propertyTable);
    }

    public void unRegisterCache(String cacheID) throws SQLException {
        this.unRegisterCache(this.cacheTable, cacheID, this.propertyTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unRegisterCache(String registerTablename, String cacheID, String propertyTablename) throws SQLException {
        CommitableStatement stmt = CommitableStatement.create(this.conh);
        String sql = this.getCacheUnregisterer(registerTablename, cacheID);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nSQL for cache unregistration:\n  " + sql);
        }
        try {
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
        this.obs.lockStateAfterUnregistring(registerTablename, this.conh);
        this.updateTimestamp(new Timestamp(System.currentTimeMillis()).toString(), this.con);
        ArrayList<String> del_id = new ArrayList<String>();
        del_id.add(cacheID);
        CachePool.removeLogsForExpiredCaches(this.conh, del_id, false, this.obs);
        CachePool.removeLogsForExpiredCaches(this.conh, del_id, true, this.obs);
    }

    void updateValidityTimestamp(String timestamp) throws SQLException {
        this.updateValidityTimestamp(timestamp, this.con);
    }

    void updateValidityTimestamp(String timestamp, Connection c) throws SQLException {
        if (!this.timestampExists(c)) {
            this.addTimestamp(timestamp, c);
        } else {
            this.updateTimestamp(timestamp, c);
        }
    }

    protected boolean timestampExists(Connection c) throws SQLException {
        return this.getTimestamp(c) != null;
    }

    public ArrayList getRegisteredCacheIDs() throws SQLException {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nCall to CacheRegistrationBase.getCacheRegistrationInfos()");
        }
        CacheRegistrationInfo[] cri = this.getCacheRegistrationInfos();
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < cri.length; ++i) {
            ret.add(cri[i].getCacheId());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCacheIDRegistered(String cacheID) throws SQLException {
        String sql = "SELECT cache_id FROM " + this.cacheTable + " WHERE " + "cache_id" + " = ?";
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nSQL for checking existence of registered cache ID " + cacheID + ":\n" + sql);
        }
        CommitablePreparedStatement pstmt = CommitablePreparedStatement.create(this.conh, sql);
        try {
            boolean bl;
            pstmt.setString(1, cacheID);
            ResultSet rs = pstmt.executeQuery();
            try {
                boolean ret = rs.next();
                this.obs.lockStateAfterIsCacheIDRegistered(this.cacheTable, this.conh);
                bl = ret;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return bl;
        }
        finally {
            pstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTimestamp(Connection c) throws SQLException {
        String ret = null;
        CommitableStatement stmt = CommitableStatement.create(this.conh);
        try {
            String sql = this.getTimestampReader();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "\nSQL for checking existence of timestamp:\n" + sql);
            }
            ResultSet rs = stmt.executeQuery(sql);
            try {
                if (rs.next()) {
                    ret = rs.getString(1);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        this.obs.lockStateAfterGettingTimestamp(this.propertyTable, this.conh);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTimestamp(String timestamp, Connection c) throws SQLException {
        CommitableStatement stmt = CommitableStatement.create(this.conh);
        String sql = this.getTimestampInserter(timestamp);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nSQL for adding timestamp:\n" + sql);
        }
        try {
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
        this.obs.lockStateAfterAddingTimestamp(this.propertyTable, this.conh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTimestamp(String timestamp, Connection c) throws SQLException {
        CommitableStatement stmt = CommitableStatement.create(this.conh);
        String sql = this.getTimestampUpdater(timestamp);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nSQL for updating timestamp:\n" + sql);
        }
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
        this.obs.lockStateAfterUpdatingTimestamp(this.propertyTable, this.conh);
    }

    protected String getCacheRegisterer(String registerTablename, String cacheID, String timestamp, boolean isProtected) {
        return "INSERT INTO " + registerTablename + " (" + "cache_id" + ", " + "registration_time" + ", " + "is_protected" + ") " + " VALUES ('" + cacheID + "', '" + timestamp + "', " + (isProtected ? 1 : 0) + ")";
    }

    private String getCacheUnregisterer(String registerTablename, String cacheID) {
        return "DELETE FROM " + registerTablename + " WHERE " + "cache_id" + "='" + cacheID + "'";
    }

    private String getTimestampReader() {
        return "SELECT prop_value FROM " + this.propertyTable + " WHERE " + "prop_name" + " = '" + "cache.validity_timestamp" + "'";
    }

    private String getTimestampInserter(String timestamp) {
        String sql = "INSERT INTO " + this.propertyTable + " (prop_name, prop_value) VALUES (" + "'" + "cache.validity_timestamp" + "', " + "'" + timestamp + "')";
        return sql;
    }

    private String getTimestampUpdater(String timestamp) {
        return "UPDATE " + this.propertyTable + " SET prop_value = '" + timestamp + "'" + " WHERE " + "prop_name" + "='" + "cache.validity_timestamp" + "'";
    }

    static String generateRandomID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static void setPermanentCacheID(String cacheIdentifier) throws IllegalArgumentException {
        if (cacheID == null) {
            throw new IllegalArgumentException("Cache ID cannot be null!");
        }
        if (cacheID.length() == 0) {
            throw new IllegalArgumentException("Cache ID cannot be empty!");
        }
        if (cacheID.length() > 32) {
            throw new IllegalArgumentException("Cache ID cannot be longer than 32 characters!");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nPermanent cache ID set to " + cacheID);
        }
        cacheID = cacheIdentifier;
        permanent = true;
    }

    public static String getCacheID() {
        return cacheID;
    }

    public static boolean isPermanent() {
        return permanent;
    }

    public static void resetCacheID() {
        cacheID = CacheRegistrationUtil.generateRandomID();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nCache ID set to " + cacheID);
        }
    }
}

