/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.util.ConnectionHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class CommitablePreparedStatement {
    private final Connection con;
    private final boolean commitable;
    private final PreparedStatement pstmt;

    public CommitablePreparedStatement(Connection con, boolean commitable, String sql) {
        this.con = con;
        this.commitable = commitable;
        try {
            this.pstmt = con.prepareStatement(sql);
        }
        catch (SQLException ex) {
            throw new IllegalArgumentException("PreparedStatement cannot be created using connection.", ex);
        }
    }

    public static CommitablePreparedStatement create(ConnectionHandler connh, String sql) {
        try {
            return new CommitablePreparedStatement(connh.getConnection(), !connh.getConnection().getAutoCommit() && connh.isCommitable(), sql);
        }
        catch (SQLException se) {
            throw new IllegalArgumentException("Autocommit state cannot be determined.", se);
        }
    }

    public boolean execute() throws SQLException {
        boolean ret = this.pstmt.execute();
        if (this.commitable) {
            this.con.commit();
        }
        return ret;
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet ret = this.pstmt.executeQuery();
        if (this.commitable) {
            this.con.commit();
        }
        return ret;
    }

    public void setString(int i, String s) throws SQLException {
        this.pstmt.setString(i, s);
    }

    public void close() throws SQLException {
        this.pstmt.close();
    }
}

