/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.util.ConnectionHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class CommitableStatement {
    private final Connection con;
    private final boolean commitable;
    private final Statement stmt;

    public CommitableStatement(Connection con, boolean commitable) {
        this.con = con;
        this.commitable = commitable;
        try {
            this.stmt = con.createStatement();
        }
        catch (SQLException ex) {
            throw new IllegalArgumentException("Statement cannot be created using connection.", ex);
        }
    }

    public static CommitableStatement create(ConnectionHandler connh) {
        try {
            return new CommitableStatement(connh.getConnection(), !connh.getConnection().getAutoCommit() && connh.isCommitable());
        }
        catch (SQLException se) {
            throw new IllegalArgumentException("Autocommit state cannot be determined.", se);
        }
    }

    public boolean execute(String sql) throws SQLException {
        boolean ret = this.stmt.execute(sql);
        if (this.commitable) {
            this.con.commit();
        }
        return ret;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet ret = this.stmt.executeQuery(sql);
        if (this.commitable) {
            this.con.commit();
        }
        return ret;
    }

    public int executeUpdate(String sql) throws SQLException {
        int ret = this.stmt.executeUpdate(sql);
        if (this.commitable) {
            this.con.commit();
        }
        return ret;
    }

    public void close() throws SQLException {
        this.stmt.close();
    }
}

