/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.SQLToFileHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.Transfer;
import chemaxon.jchem.db.TransferException;
import chemaxon.util.ConnectionHandler;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class Exporter
implements Transfer {
    private static final Logger logger = Logger.getLogger(Exporter.class.getName());
    private String tname = null;
    private String fieldList = null;
    private String conditions = null;
    private OutputStream os = null;
    private int format = 0;
    private boolean defaults = false;
    Properties props = new Properties();
    SQLToFileHandler handler = null;
    TableInfo tableFields = null;
    ConnectionHandler conh = null;
    String sysEol;
    String eol = this.sysEol = System.getProperty("line.separator");
    String delimiter = "\t";
    String quotation = "\"";
    boolean jtfWithStructure = true;
    boolean initialized = false;
    private int[] idList = null;
    private String customSelect = null;
    private String[] outputFieldNames = null;
    private Map<String, String> outputFieldConversion = null;

    public void setConnectionHandler(ConnectionHandler conh) {
        this.conh = conh;
    }

    public ConnectionHandler getConnectionHandler() {
        return this.conh;
    }

    public void setTableName(String tname) {
        this.tname = tname;
    }

    public String getTableName() {
        return this.tname;
    }

    public void setFieldList(String fieldList) {
        this.fieldList = fieldList;
    }

    public String getFieldList() {
        return this.fieldList;
    }

    public void setConditions(String conditions) {
        this.conditions = conditions;
    }

    public String getConditions() {
        return this.conditions;
    }

    public void setIDList(int[] list) {
        this.idList = list;
    }

    public int[] getIDList() {
        return this.idList;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void setFormat(int format2) {
        this.format = format2;
    }

    public int getFormat() {
        return this.format;
    }

    public void setDefaults(boolean b) {
        this.defaults = b;
    }

    public boolean isDefaults() {
        return this.defaults;
    }

    public void setEol(String eol) {
        this.eol = eol;
    }

    public void setSelectStatement(String sql) {
        this.customSelect = sql;
    }

    public void setOutputFieldNames(String fieldNames) {
        StringTokenizer st = new StringTokenizer(fieldNames);
        int count = st.countTokens();
        this.outputFieldNames = new String[count];
        for (int x = 0; x < count; ++x) {
            this.outputFieldNames[x] = st.nextToken();
        }
    }

    public String[] getOutputFieldNames() {
        return this.outputFieldNames;
    }

    public void setOutputFieldConversion(String fieldNameConversion) {
        if (fieldNameConversion == null) {
            this.outputFieldConversion = null;
        } else {
            String[] fieldArr;
            this.outputFieldConversion = new HashMap<String, String>();
            for (String fieldConversion : fieldArr = fieldNameConversion.split("[|]")) {
                String[] fieldConversionArr;
                if (fieldConversion.equals("") || (fieldConversionArr = fieldConversion.split(":")).length != 2) continue;
                this.outputFieldConversion.put(fieldConversionArr[0].toLowerCase(), fieldConversionArr[1]);
            }
        }
    }

    public Map<String, String> getOutputFieldConversion() {
        return this.outputFieldConversion;
    }

    public String getEol() {
        return this.eol;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setQuotation(String quotation) {
        this.quotation = quotation;
    }

    public String getQuotation() {
        return this.quotation;
    }

    public void setJtfWithStructure(boolean b) {
        this.jtfWithStructure = b;
    }

    public boolean isJtfWithStructure() {
        return this.jtfWithStructure;
    }

    public boolean writeNext() throws TransferException {
        if (!this.initialized) {
            this.init();
        }
        boolean wrote = false;
        try {
            wrote = this.handler.writeNext();
            if (!wrote) {
                this.handler.close();
            }
        }
        catch (Exception e) {
            logger.throwing("Exporter", "writeNext", e);
            throw new TransferException("Unexpected error during DB export: " + e.getMessage(), e);
        }
        return wrote;
    }

    public int writeAll() throws TransferException {
        if (!this.initialized) {
            this.init();
        }
        int counter = 0;
        while (this.writeNext()) {
            ++counter;
        }
        return counter;
    }

    private void init() throws TransferException {
        try {
            this.initialized = true;
            String error = null;
            if (this.conh == null) {
                error = "ConectionHandler not specified.";
            }
            if (this.tname == null && this.customSelect == null) {
                error = "Name of table not specified.";
            }
            if (this.os == null) {
                error = "OutputStream not specified.";
            }
            if (this.format == -1) {
                error = "Format not specified.";
            }
            if (error != null) {
                throw new TransferException(error);
            }
            if (this.conditions == null) {
                this.conditions = "";
            }
            if (this.eol == null) {
                this.eol = this.sysEol;
            }
            if (this.eol.length() == 0) {
                this.eol = this.sysEol;
            }
            if (this.delimiter == null) {
                this.delimiter = "\t";
            }
            if (this.delimiter.length() == 0) {
                this.delimiter = "\t";
            }
            if (this.quotation == null) {
                this.quotation = "\"";
            }
            this.tableFields = null;
            if (this.customSelect == null) {
                this.tname = TableInfo.getTableNameWithSchema(this.conh.getConnection(), this.tname);
                this.tableFields = TableInfo.getTableInfo(this.conh, this.props, this.tname);
                this.tableFields.autoConnectFieldsForExport();
                if (this.fieldList != null) {
                    this.tableFields.selectFields(this.fieldList);
                }
                if (this.fieldList == null && this.defaults) {
                    this.tableFields.selectDefaults(this.format);
                }
            }
            this.handler = new SQLToFileHandler(this.conh, this.tname, this.os, this.tableFields, this.format, this.conditions, this.eol, this.delimiter, this.quotation, this.jtfWithStructure, this.idList, this.customSelect, this.outputFieldNames, this.outputFieldConversion);
        }
        catch (Exception e) {
            logger.throwing("Exporter", "init", e);
            throw new TransferException("Unexpected error during DB export init: " + e.getMessage(), e);
        }
    }
}

