/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.common.util.IntVector;
import chemaxon.descriptors.MarkushDescriptor;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.ReactionFingerprint;
import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.CacheRegistrationUtil;
import chemaxon.jchem.db.CacheType;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.FingerprintHandler;
import chemaxon.jchem.db.JChemCache;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.jchem.db.MarkushTableInfo;
import chemaxon.jchem.db.ScreenedQueueHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.sss.screen.DefaultMarkushScreenOptions;
import chemaxon.sss.screen.handler.ScreenHandler;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.util.BinaryDataUtil;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FakeGeneralCache
extends JChemCache {
    static final Logger logger = Logger.getLogger(FakeGeneralCache.class.getName());
    private int data_cd_id;
    private final int[] data_intFP;
    private String data_structure;
    private String data_flags;
    private boolean data_noRingsInFP;
    private byte[] data_markushData;
    private byte[][] data_markushDescriptorData;
    int fpColumnCount;
    int cfpColumnCount;
    Connection con = null;
    String[] markushDescriptorNames = MarkushTableInfo.getMarkushDescriptorNames();
    String[] markushDescriptorTables;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FakeGeneralCache(ConnectionHandler conh, String tableName, String cacheHashKey, int columnsToCache, int initialCapacity, boolean indexTable, CachePool cachePool, String timeStamp, JChemObserverImpl jcoImpl) throws SQLException, DatabaseSearchException {
        super(conh, tableName, cacheHashKey, TableInfo.getLogTableName(tableName), CacheRegistrationUtil.getCacheID(), initialCapacity, cachePool, timeStamp, indexTable, jcoImpl);
        this.con = conh.getConnection();
        this.dbProp = new DatabaseProperties(conh, indexTable);
        this.fpColumnCount = columnsToCache;
        if (this.fpColumnCount == 0) {
            int numberOfBits = 0;
            numberOfBits = FingerprintHandler.getNumberOfBits(conh, tableName, indexTable);
            if (numberOfBits == Integer.MIN_VALUE) {
                throw new DatabaseSearchException("No fingerprint information for " + tableName + "\n" + " Run \"jcman -t\" or check the JChemProperties table for structure tables");
            }
            this.cfpColumnCount = BinaryDataUtil.translateBitCountToIntCount(numberOfBits);
            this.fpColumnCount = this.cfpColumnCount + FingerprintHandler.getNumberOfStructuralFPColumns(conh, tableName, indexTable);
        }
        this.data_intFP = new int[this.fpColumnCount];
        int tableType = this.dbProp.getTableType(tableName);
        switch (tableType) {
            case 1: {
                this.cacheType = CacheType.REACTION;
                break;
            }
            case 3: {
                this.cacheType = CacheType.MARKUSH;
                break;
            }
            case 4: {
                this.cacheType = CacheType.QUERY;
                break;
            }
            default: {
                this.cacheType = CacheType.STRUCTURE;
            }
        }
        if (this.cacheType.isMarkush()) {
            int descLength = this.markushDescriptorNames.length;
            this.markushDescriptorTables = new String[descLength];
            for (int descIndex = 0; descIndex < descLength; ++descIndex) {
                this.markushDescriptorTables[descIndex] = MDTableHandler.getMDTableName(tableName, this.markushDescriptorNames[descIndex]);
                Statement stmt = null;
                try {
                    stmt = this.con.createStatement();
                    stmt.execute("SELECT * FROM " + this.markushDescriptorTables[descIndex] + " WHERE 1 = 0");
                    continue;
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, e.getMessage());
                    }
                    this.markushDescriptorTables = new String[0];
                    this.markushDescriptorNames = new String[0];
                    descLength = 0;
                    continue;
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
        } else {
            this.markushDescriptorTables = new String[0];
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nFake general tructure cache created.\n** Cache ID: " + this.cacheID + "\n** Table name: " + tableName + "\n** Logtable name: " + this.logTableName + "\n** Cache hash key: " + cacheHashKey + "\n** FP columns: " + this.fpColumnCount);
        }
    }

    private PreparedStatement createPreparedStatement() throws SQLException {
        String sql = this.getSQLSelectionString() + " WHERE " + "a" + "." + "cd_id" + "=?";
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\nSQL for cache " + this.tableName + " loading in createResultSet(): \n  " + sql);
        }
        PreparedStatement pstmt = this.con.prepareStatement(sql);
        return pstmt;
    }

    private String getAllIDSQLString() {
        StringBuffer sb = new StringBuffer("SELECT ");
        sb.append("a.");
        sb.append("cd_id");
        sb.append(" FROM ");
        sb.append(this.tableName);
        sb.append(" a");
        sb.append(" ORDER BY ");
        sb.append("a.");
        sb.append("cd_id");
        return sb.toString();
    }

    private String getRowcountSQLString() {
        StringBuffer sb = new StringBuffer("SELECT COUNT(*) FROM ");
        sb.append(this.tableName);
        return sb.toString();
    }

    protected String getSQLSelectionString(int id) {
        StringBuffer whereClause = new StringBuffer(" WHERE ");
        whereClause.append("a");
        whereClause.append(".");
        whereClause.append("cd_id");
        whereClause.append(" = ");
        whereClause.append(id);
        return this.getSQLSelectionString() + whereClause.toString();
    }

    @Override
    protected String getSQLSelectionString() {
        int i;
        StringBuffer sb = new StringBuffer("SELECT ");
        sb.append("a.");
        sb.append("cd_id");
        sb.append(",");
        for (int i2 = 0; i2 < this.fpColumnCount; ++i2) {
            sb.append(" a.");
            sb.append("cd_fp");
            sb.append(i2 + 1);
            sb.append(",");
        }
        sb.append(" a.");
        sb.append(this.getStructureFieldName());
        sb.append(",");
        sb.append(" a.");
        sb.append("cd_flags");
        int descLength = this.markushDescriptorTables.length;
        if (this.cacheType.isMarkush()) {
            sb.append(",");
            sb.append(" a.");
            sb.append("cd_markush");
            for (i = 0; i < descLength; ++i) {
                sb.append(", a" + i + "." + "md_data");
            }
        }
        sb.append(" FROM ");
        if (this.cacheType.isMarkush()) {
            for (i = 0; i < descLength; ++i) {
                sb.append("(");
            }
        }
        sb.append(this.tableName);
        sb.append(" a");
        if (this.cacheType.isMarkush()) {
            for (i = 0; i < descLength; ++i) {
                sb.append(" LEFT OUTER JOIN ");
                sb.append(this.markushDescriptorTables[i]);
                sb.append(" a" + i);
                sb.append(" ON a.cd_id = a" + i);
                sb.append(".cd_id");
                sb.append(")");
            }
        }
        return sb.toString();
    }

    @Override
    protected void resetCache() {
        this.fails.clear();
    }

    @Override
    protected void ensureCapacity(int newCapacity) {
    }

    @Override
    public synchronized int loadCache(ConnectionHandler conh, boolean registerCache) throws SQLException {
        this.con = conh.getConnection();
        this.dbProp = new DatabaseProperties(conh, this.indexTable);
        return 1;
    }

    @Override
    public int getFPColumnCount() {
        if (this.cacheType.isMarkush()) {
            return 0;
        }
        return this.fpColumnCount;
    }

    @Override
    public final int getID(int index) {
        return this.getAllIdsAsIntArray()[index];
    }

    @Override
    public final void putScreenedToQueue(int[] fp, int[] fp_noRing, Molecule query, JChemSearchOptions searchOptions, boolean forFullSearch, IntVector candidatesVector, boolean candidatesContainIndices, IntVector hitsForZeroMatchCount, ScreenedQueueHandler sqh) throws DatabaseSearchException {
        IntVector ids;
        IntVector indices;
        if (candidatesContainIndices) {
            indices = candidatesVector;
            ids = this.convertIndicesToID(indices.cloneIntVector());
        } else {
            ids = candidatesVector;
            indices = this.convertIDsToIndices(ids.cloneIntVector());
        }
        if (!this.cacheType.isMarkush()) {
            this.putScreenedToQueueStructure(fp, fp_noRing, indices, ids, searchOptions.getSearchType() == 6, forFullSearch, hitsForZeroMatchCount, sqh);
        } else if (!searchOptions.isMarkushScreeningEnabled()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Markush screening disabled");
            }
            sqh.put(ids, indices, false);
        } else {
            this.putMarkushScreenedToQueue(query, searchOptions, indices, ids, hitsForZeroMatchCount, sqh);
        }
    }

    @Override
    protected final void putScreenedToQueue0(int[] fp, int[] fp_noRing, Molecule query, JChemSearchOptions searchOptions, boolean isIndices, IntVector candidates, boolean forFullSearch, ScreenedQueueHandler sqh, IntVector hitsForZeroMatchCount) throws DatabaseSearchException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void putScreenedToQueueStructure(int[] fp, int[] fp_noRing, IntVector indices, IntVector ids, boolean forSuperstructure, boolean forFullSearch, IntVector hitsForZeroMatchCount, ScreenedQueueHandler sqh) {
        if (this.cacheType.isReaction()) {
            this.putScreenedReactionToQueue(fp, fp_noRing, indices, ids, forSuperstructure, forFullSearch, hitsForZeroMatchCount, sqh);
            return;
        }
        boolean notScreenedIsNeeded = hitsForZeroMatchCount != null;
        try {
            PreparedStatement pstmt = this.createPreparedStatement();
            try {
                int id = -1;
                int index = -1;
                int size = indices.size();
                for (int i = 0; i < size; ++i) {
                    index = indices.get(i);
                    id = ids.get(i);
                    if (id == -1 || index == -1) continue;
                    pstmt.setInt(1, id);
                    ResultSet rs = pstmt.executeQuery();
                    try {
                        if (!rs.next()) continue;
                        this.processResultSet(rs);
                        boolean match = true;
                        int p = 0;
                        int[] d = this.data_intFP;
                        int x = 0;
                        while (x < this.fpColumnCount && match) {
                            int query;
                            int n = query = this.data_noRingsInFP ? fp_noRing[x] : fp[x];
                            match = forFullSearch && !this.data_noRingsInFP ? query == d[p] : (forSuperstructure ? (d[p] & query) == d[p] : (d[p] & query) == query);
                            ++x;
                            ++p;
                        }
                        if (!match && notScreenedIsNeeded) {
                            hitsForZeroMatchCount.addElement(id);
                        }
                        if (!match) continue;
                        sqh.put(id, index, false);
                        continue;
                    }
                    finally {
                        rs.close();
                    }
                }
            }
            finally {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        sqh.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void putScreenedReactionToQueue(int[] fp, int[] fp_noRing, IntVector indices, IntVector ids, boolean forSuperstructure, boolean forFullSearch, IntVector hitsForZeroMatchCount, ScreenedQueueHandler sqh) {
        boolean notScreenedIsNeeded = hitsForZeroMatchCount != null;
        try {
            PreparedStatement pstmt = this.createPreparedStatement();
            try {
                int id = -1;
                int index = -1;
                int size = indices.size();
                for (int i = 0; i < size; ++i) {
                    index = indices.get(i);
                    id = ids.get(i);
                    if (id == -1 || index == -1) continue;
                    pstmt.setInt(1, id);
                    ResultSet rs = pstmt.executeQuery();
                    try {
                        if (!rs.next()) continue;
                        this.processResultSet(rs);
                        int[] d = this.data_intFP;
                        int p = 0;
                        int totalCols = this.fpColumnCount;
                        int[] t_fp = new int[this.fpColumnCount];
                        System.arraycopy(d, p, t_fp, 0, this.fpColumnCount);
                        int[] r_fp = ReactionFingerprint.getChemicalHashedFingerprint(t_fp, this.cfpColumnCount);
                        int structuralKeyColumns = this.fpColumnCount - this.cfpColumnCount;
                        totalCols = r_fp.length + structuralKeyColumns;
                        int[] fp_new = new int[totalCols];
                        System.arraycopy(r_fp, 0, fp_new, 0, r_fp.length);
                        System.arraycopy(t_fp, this.cfpColumnCount, fp_new, r_fp.length, structuralKeyColumns);
                        t_fp = fp_new;
                        boolean match = true;
                        for (int x = 0; x < totalCols && match; ++x) {
                            int query = this.data_noRingsInFP ? fp_noRing[x] : fp[x];
                            int target = t_fp[x];
                            match = forFullSearch && !this.data_noRingsInFP ? query == target : (forSuperstructure ? (target & query) == target : (target & query) == query);
                        }
                        if (!match && notScreenedIsNeeded) {
                            hitsForZeroMatchCount.addElement(id);
                        }
                        if (!match) continue;
                        sqh.put(id, index, false);
                        continue;
                    }
                    finally {
                        rs.close();
                    }
                }
            }
            finally {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        sqh.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void putMarkushScreenedToQueue(Molecule query, JChemSearchOptions searchOptions, IntVector indices, IntVector ids, IntVector hitsForZeroMatchCount, ScreenedQueueHandler sqh) throws DatabaseSearchException {
        int descLength = this.markushDescriptorNames.length;
        MarkushDescriptor[] queryDesc = new MarkushDescriptor[descLength];
        for (int descIndex = 0; descIndex < descLength; ++descIndex) {
            try {
                queryDesc[descIndex] = this.createMarkushDescriptor(this.markushDescriptorNames[descIndex]);
                DefaultMarkushScreenOptions screenOptions = new DefaultMarkushScreenOptions(searchOptions);
                queryDesc[descIndex].generateQueryDescriptor(query, screenOptions);
                continue;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Error in first phase of Markush screening: " + e.getMessage());
                    logger.severe("Cache screening accepts all candidates ...");
                }
                sqh.put(ids, indices, false);
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Markush screening finished");
                }
                throw new DatabaseSearchException(e);
            }
        }
        MarkushDescriptor[] targetDescriptors = new MarkushDescriptor[descLength];
        for (int descIndex = 0; descIndex < descLength; ++descIndex) {
            try {
                targetDescriptors[descIndex] = this.createMarkushDescriptor(this.markushDescriptorNames[descIndex]);
                continue;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Error while creating " + this.markushDescriptorNames[descIndex] + "markush descriptor for target: " + e.getMessage());
                    logger.severe("Cache screening accepts all candidates ...");
                }
                sqh.put(ids, indices, false);
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Markush screening finished");
                }
                throw new DatabaseSearchException(e);
            }
        }
        boolean notScreenedIsNeeded = hitsForZeroMatchCount != null;
        try {
            PreparedStatement pstmt = this.createPreparedStatement();
            try {
                int id = -1;
                int index = -1;
                int size = indices.size();
                for (int i = 0; i < size; ++i) {
                    index = indices.get(i);
                    id = ids.get(i);
                    if (id == -1 || index == -1) continue;
                    pstmt.setInt(1, id);
                    ResultSet rs = pstmt.executeQuery();
                    try {
                        if (!rs.next()) continue;
                        this.processResultSet(rs);
                        boolean match = true;
                        for (int descIndex = 0; descIndex < descLength && match; ++descIndex) {
                            if (this.data_markushDescriptorData[descIndex] == null) continue;
                            targetDescriptors[descIndex].fromData(this.data_markushDescriptorData[descIndex]);
                            match = queryDesc[descIndex].acceptTarget(targetDescriptors[descIndex]);
                        }
                        if (!match) {
                            if (!notScreenedIsNeeded) continue;
                            hitsForZeroMatchCount.addElement(id);
                            continue;
                        }
                        sqh.put(id, index, false);
                        continue;
                    }
                    finally {
                        rs.close();
                    }
                }
            }
            finally {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        sqh.flush();
    }

    @Override
    public IntVector getBeforeEnumScreened(int[] fp, int[] fpNoRing, byte[] queryDescr, JChemSearchOptions searchOptions, IntVector candidates, boolean isIndices, IntVector nonHits) {
        return candidates.cloneIntVector();
    }

    private final MarkushDescriptor createMarkushDescriptor(String descName) throws SQLException {
        String type = this.dbProp.getMDTableProperty(this.tableName, descName, "Type");
        String settings = this.dbProp.getMDTableProperty(this.tableName, descName, "Settings");
        assert (type != null);
        MarkushDescriptor desc = (MarkushDescriptor)MolecularDescriptor.newInstance(type);
        desc.setParameters(settings);
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadRecord(int index) throws SQLException {
        int id = this.getID(index);
        String sql = this.getSQLSelectionString(id);
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                if (rs.next()) {
                    this.processResultSet(rs);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    @Override
    public final void getSimilarityDescriptor(int index, int[] fp) {
        try {
            this.loadRecord(index);
            for (int x = 0; x < this.fpColumnCount; ++x) {
                fp[x] = this.data_intFP[x];
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void getSimilarityDescritporInBytes(int index, byte[] fp) {
        try {
            this.loadRecord(index);
            int[] d = this.data_intFP;
            int p = 0;
            int j = 0;
            for (int x = 0; x < this.fpColumnCount; ++x) {
                int i = d[p];
                fp[j++] = (byte)(i >>> 24 & 0xFF);
                fp[j++] = (byte)(i >>> 16 & 0xFF);
                fp[j++] = (byte)(i >>> 8 & 0xFF);
                fp[j++] = (byte)(i & 0xFF);
                ++p;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String getStructureFieldName() {
        if (this.cacheType.isQuery()) {
            return "cd_smarts";
        }
        return "cd_smiles";
    }

    @Override
    public final byte[] getStructureStringInBytes(int index) {
        try {
            this.loadRecord(index);
            if (this.cacheType.isMarkush()) {
                return this.data_markushData;
            }
            byte[] bytes = null;
            if (this.data_structure != null) {
                try {
                    bytes = this.data_structure.getBytes("ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    this.fails.put(this.data_cd_id, e);
                }
            }
            return bytes;
        }
        catch (SQLException sex) {
            sex.printStackTrace();
            return null;
        }
    }

    @Override
    public final String getStructureString(int index) {
        if (this.cacheType.isMarkush()) {
            return "";
        }
        try {
            this.loadRecord(index);
            return this.data_structure;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStructureCount() {
        String sql = this.getRowcountSQLString();
        int rowCount = 0;
        try {
            Statement stmt = this.con.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(sql);
                try {
                    if (rs.next()) {
                        rowCount = rs.getInt(1);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntVector getAllIDs() {
        String sql = this.getAllIDSQLString();
        IntVector result = new IntVector();
        try {
            Statement stmt = this.con.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(sql);
                try {
                    while (rs.next()) {
                        result.addElement(rs.getInt(1));
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private int[] getAllIdsAsIntArray() {
        IntVector cdIds = this.getAllIDs();
        int[] cd_id = cdIds.toArray();
        return cd_id;
    }

    @Override
    public ScreenHandler getScreenHandler() {
        return null;
    }

    @Override
    public IntVector getAllIndices() {
        int rowCount = this.getStructureCount();
        IntVector result = new IntVector(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            result.addElement(i);
        }
        return result;
    }

    @Override
    public IntVector convertIndicesToID(IntVector list) {
        IntVector cdIds = this.getAllIDs();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.set(i, cdIds.get(list.get(i)));
        }
        return list;
    }

    @Override
    public IntVector convertIDsToIndices(IntVector list) {
        int j = 0;
        int index = -1;
        int[] cd_id = this.getAllIdsAsIntArray();
        for (int i = 0; i < list.size(); ++i) {
            index = this.findID(list.get(i), cd_id);
            if (index == -1) continue;
            list.set(j, index);
            ++j;
        }
        list.setSize(j);
        return list;
    }

    @Override
    public int findID(int key) {
        int[] cd_id = this.getAllIdsAsIntArray();
        return this.findID(key, cd_id);
    }

    private int findID(int key, int[] cd_id) {
        int pos = Arrays.binarySearch(cd_id, 0, cd_id.length, key);
        return pos >= 0 ? pos : -1;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    protected boolean processResultSet(ResultSet rs) {
        block4: {
            int columnIndex = 1;
            this.data_cd_id = -1;
            try {
                int i;
                this.data_cd_id = rs.getInt(columnIndex++);
                for (i = 0; i < this.fpColumnCount; ++i) {
                    this.data_intFP[i] = rs.getInt(columnIndex++);
                }
                this.data_structure = rs.getString(columnIndex++);
                this.data_flags = rs.getString(columnIndex++);
                this.data_noRingsInFP = UpdateHandler.flagsIndicateNoRingInfoInFP(this.data_flags);
                this.data_markushData = DatabaseTools.readBytes(rs, columnIndex++);
                this.data_markushDescriptorData = new byte[this.markushDescriptorTables.length][];
                for (i = 0; i < this.markushDescriptorTables.length; ++i) {
                    this.data_markushDescriptorData[i] = rs.getBytes(columnIndex++);
                }
            }
            catch (Exception e) {
                if (this.data_cd_id == -1) break block4;
                this.fails.put(this.data_cd_id, e);
            }
        }
        return true;
    }
}

