/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.cdmarkush.CDMarkushToDB;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.sss.screen.CombinedFingerprint;
import chemaxon.sss.search.SearchUtil;
import chemaxon.struc.Molecule;
import chemaxon.util.BinaryDataUtil;
import chemaxon.util.ConnectionHandler;
import java.io.IOException;
import java.sql.SQLException;

public final class FingerprintHandler {
    public static int getNumberOfBits(ConnectionHandler conh, String tableName, boolean indexTable) throws SQLException {
        DatabaseProperties prop = new DatabaseProperties(conh, indexTable);
        try {
            return prop.getTableIntProperty(tableName, "fingerprint.numberOfBits");
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("The table \"" + tableName + "\" " + "doesn't exist or size of fingerprint is not " + "properly set in property table \"" + conh.getPropertyTable() + "\".", e);
        }
    }

    public static int getNumberOfStructuralFPColumns(ConnectionHandler conh, String tableName, boolean indexTable) throws SQLException {
        DatabaseProperties prop = new DatabaseProperties(conh, indexTable);
        try {
            return prop.getTableIntProperty(tableName, "fingerprint.numberOfStrucFPCols");
        }
        catch (NumberFormatException e) {
            throw new SQLException("The number of structural fingerprint columns is not properly set for table \"" + tableName + "\" " + "in property table \"" + conh.getPropertyTable() + "\".", e);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    public static int getNumberOfCombinedFPColumns(ConnectionHandler conh, String tableName, boolean indexTable) throws SQLException {
        int numberOfBits = FingerprintHandler.getNumberOfBits(conh, tableName, indexTable);
        if (numberOfBits == Integer.MIN_VALUE) {
            throw new SQLException("No fingerprint information for " + tableName + "\n" + " Run \"jcman -t\" or check the JChemProperties table" + " for structure tables");
        }
        return BinaryDataUtil.translateBitCountToIntCount(numberOfBits);
    }

    public static CombinedFingerprint getCombinedFingerprint(ConnectionHandler conh, String tableName, boolean indexTable) throws IOException, SQLException, StandardizerException {
        return FingerprintHandler.getCombinedFingerprint(conh, tableName, indexTable, FingerprintHandler.getNumberOfStructuralFPColumns(conh, tableName, indexTable), FingerprintHandler.getNumberOfCombinedFPColumns(conh, tableName, indexTable), TableInfo.getStandardizer(conh, tableName, indexTable), false);
    }

    public static CombinedFingerprint getCombinedFingerprint(ConnectionHandler conh, String tableName, boolean indexTable, int numStrucFPCols, int numCFPCols, Standardizer standardizer, boolean reactionFP) throws IOException, SQLException {
        String structuralKeys = FingerprintHandler.getStructuralKeys(conh, tableName, indexTable);
        int numberOfOnes = FingerprintHandler.getNumberOfOnes(conh, tableName, indexTable);
        int numberOfEdges = FingerprintHandler.getNumberOfEdges(conh, tableName, indexTable);
        return new CombinedFingerprint(numStrucFPCols, structuralKeys, standardizer, numCFPCols, numberOfEdges, numberOfOnes, reactionFP);
    }

    public static int[][] getFingerprints(Molecule mol, CombinedFingerprint cfp, int tableType, boolean withRings, boolean withBranchCalculation, CDMarkushToDB markushToDB) {
        int[][] fingerprints;
        if (markushToDB != null) {
            fingerprints = markushToDB.calcFingerprints(cfp);
        } else {
            Molecule molToScreen = TableInfo.hasOnlyMustFragmentForScreen(tableType) ? SearchUtil.getMustFragment(mol) : mol;
            fingerprints = cfp.getCombinedFingerprints(molToScreen, null, false, false, withRings, withBranchCalculation);
        }
        return fingerprints;
    }

    public static String getStructuralKeys(ConnectionHandler conh, String tableName, boolean indexTable) throws SQLException {
        DatabaseProperties prop = new DatabaseProperties(conh, indexTable);
        return prop.getTableProperty(tableName, "fingerprint.structuralKeys");
    }

    public static int getNumberOfBytes(ConnectionHandler conh, String tableName, boolean indexTable) throws SQLException {
        return BinaryDataUtil.translateBitCountToByteCount(FingerprintHandler.getNumberOfBits(conh, tableName, indexTable));
    }

    public static int getNumberOfInts(ConnectionHandler conh, String tableName, boolean indexTable) throws SQLException {
        return BinaryDataUtil.translateBitCountToIntCount(FingerprintHandler.getNumberOfBits(conh, tableName, indexTable));
    }

    public static int getNumberOfOnes(ConnectionHandler conh, String tableName, boolean indexTable) throws SQLException {
        DatabaseProperties prop = new DatabaseProperties(conh, indexTable);
        try {
            return prop.getTableIntProperty(tableName, "fingerprint.numberOfOnes");
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("The table \"" + tableName + "\" " + "doesn't exist or number of ones in fingerprint is not " + "properly set in property table \"" + conh.getPropertyTable() + "\".", e);
        }
    }

    public static int getNumberOfEdges(ConnectionHandler conh, String tableName, boolean indexTable) throws SQLException {
        DatabaseProperties prop = new DatabaseProperties(conh, indexTable);
        try {
            return prop.getTableIntProperty(tableName, "fingerprint.numberOfEdges");
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("The table \"" + tableName + "\" " + "doesn't exist or number of edges in fingerprint is not " + "properly set in property table \"" + conh.getPropertyTable() + "\".", e);
        }
    }

    public static void save(ConnectionHandler conh, String tableName, int numberOfBits, int numberOfOnes, int numberOfEdges, int structuralKeyColumnCount, String structuralKeys) throws SQLException {
        DatabaseProperties prop = new DatabaseProperties(conh, false);
        prop.setTableProperty(tableName, "fingerprint.numberOfBits", Integer.toString(numberOfBits));
        prop.setTableProperty(tableName, "fingerprint.numberOfOnes", Integer.toString(numberOfOnes));
        prop.setTableProperty(tableName, "fingerprint.numberOfEdges", Integer.toString(numberOfEdges));
        prop.setTableProperty(tableName, "fingerprint.numberOfStrucFPCols", Integer.toString(structuralKeyColumnCount));
        prop.setTableProperty(tableName, "fingerprint.structuralKeys", structuralKeys);
    }

    public static boolean targetContainsQuery(int[] FPQuery, int[] FPTarget) {
        int size = FPQuery.length;
        for (int x = 0; x < size; ++x) {
            int query = FPQuery[x];
            int target = FPTarget[x];
            if ((query & target) == query) continue;
            return false;
        }
        return true;
    }

    public static boolean targetContainsQuery(byte[] FPQuery, byte[] FPTarget) {
        int size = FPQuery.length;
        for (int x = 0; x < size; ++x) {
            byte query = FPQuery[x];
            byte target = FPTarget[x];
            if ((query & target) == query) continue;
            return false;
        }
        return true;
    }
}

