/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.agent.NoSize;
import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.descriptors.ReactionFingerprint;
import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.CacheRegistrationUtil;
import chemaxon.jchem.db.CacheType;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.FingerprintHandler;
import chemaxon.jchem.db.JChemCache;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.ScreenedQueueHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.marvin.io.formats.smiles.CxsmilesImport;
import chemaxon.sss.screen.handler.AfterEnumSHCreator;
import chemaxon.sss.screen.handler.ScreenHandler;
import chemaxon.sss.screen.handler.ScreenHandlerBytes;
import chemaxon.sss.screen.handler.UnsupportedMoleculeException;
import chemaxon.sss.screen.options.DefaultScreenOptions;
import chemaxon.sss.screen.options.ScreenOptions;
import chemaxon.sss.screen.util.ServiceUtil;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.sss.search.bracket.PolymerMatcher;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.util.BinaryDataUtil;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import chemaxon.util.SmilesCompressor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.logging.Level;

final class GeneralCache
extends JChemCache {
    private static final int BLOCK_SIZE = 32768;
    private int[][] data = null;
    private int[] intFP;
    private int block;
    private int pos;
    private BitSet noRingInfoInFP;
    private int[] blockIndex;
    private short[] positionInBlock;
    private short[] smilesLength;
    private int fpColumnCount;
    private int cfpColumnCount;
    private byte[][] screenBytesAfter;
    private ScreenHandler sh;
    private ScreenHandlerBytes shb;
    private boolean compressSmiles = true;
    @NoSize
    private SmilesCompressor smilesCompressor = null;
    CxsmilesImport cxsmilesImport;
    private static final int MEMORY_CHECK_SAMPLING = 10000;

    public GeneralCache(ConnectionHandler conh, String tableName, String cacheHashKey, int columnsToCache, int initialCapacity, boolean indexTable, CachePool cachePool, String timeStamp, JChemObserverImpl jcoImpl) throws SQLException, DatabaseSearchException {
        super(conh, tableName, cacheHashKey, TableInfo.getLogTableName(tableName), CacheRegistrationUtil.getCacheID(), initialCapacity, cachePool, timeStamp, indexTable, jcoImpl);
        if (this.compressSmiles) {
            this.smilesCompressor = new SmilesCompressor();
        }
        this.fpColumnCount = columnsToCache;
        if (this.fpColumnCount == 0) {
            int numberOfBits = 0;
            numberOfBits = FingerprintHandler.getNumberOfBits(conh, tableName, indexTable);
            if (numberOfBits == Integer.MIN_VALUE) {
                throw new DatabaseSearchException("No fingerprint information for " + tableName + "\n" + " Run \"jcman -t\" or check the JChemProperties table for structure tables");
            }
            this.cfpColumnCount = BinaryDataUtil.translateBitCountToIntCount(numberOfBits);
            this.fpColumnCount = this.cfpColumnCount + FingerprintHandler.getNumberOfStructuralFPColumns(conh, tableName, indexTable);
        }
        this.intFP = new int[this.fpColumnCount];
        int tableType = this.dbProp.getTableType(tableName);
        switch (tableType) {
            case 1: {
                this.cacheType = CacheType.REACTION;
                break;
            }
            case 3: {
                this.cacheType = CacheType.MARKUSH;
                break;
            }
            case 4: {
                this.cacheType = CacheType.QUERY;
                break;
            }
            case 2: {
                this.cacheType = CacheType.ANY;
                break;
            }
            case 0: {
                this.cacheType = CacheType.STRUCTURE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported table type of code: " + tableType);
            }
        }
        if (this.cacheType.isQuery()) {
            this.compressSmiles = false;
        }
        AfterEnumSHCreator shcAfter = ServiceUtil.loadService(AfterEnumSHCreator.class);
        this.sh = shcAfter.constructScreenHandler();
        this.shb = this.sh.getBytesHandler();
        this.resetCache();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("\nStructure cache created.\n** Cache ID: " + this.cacheID + "\n** Table name: " + tableName + "\n** Logtable name: " + this.logTableName + "\n** Cache hash key: " + cacheHashKey + "\n** FP columns: " + this.fpColumnCount);
        }
    }

    @Override
    protected String getSQLSelectionString() {
        StringBuffer sb = new StringBuffer("SELECT ");
        sb.append("a.");
        sb.append("cd_id");
        sb.append(",");
        for (int i = 0; i < this.fpColumnCount; ++i) {
            sb.append(" a.");
            sb.append("cd_fp");
            sb.append(i + 1);
            sb.append(",");
        }
        if (this.cacheType.isQuery()) {
            sb.append(" a.");
            sb.append("cd_smarts");
        } else {
            sb.append(" a.");
            sb.append("cd_smiles");
        }
        sb.append(",");
        sb.append(" a.");
        sb.append("cd_flags");
        sb.append(" FROM ");
        sb.append(this.tableName);
        sb.append(" a");
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(sb.toString());
        }
        return sb.toString();
    }

    @Override
    protected final boolean processResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 1;
        int cd_id = -1;
        try {
            cd_id = rs.getInt(columnIndex++);
            for (int i = 0; i < this.fpColumnCount; ++i) {
                this.intFP[i] = rs.getInt(columnIndex++);
            }
            String smiles = DatabaseTools.readString(rs, columnIndex++);
            String flags = rs.getString(columnIndex++);
            boolean noRingInFP = UpdateHandler.flagsIndicateNoRingInfoInFP(flags);
            return this.addStructure(cd_id, smiles, this.intFP, noRingInFP);
        }
        catch (Exception e) {
            if (cd_id != -1) {
                this.fails.put(cd_id, e);
            }
            return true;
        }
    }

    @Override
    void initImporter() {
        this.cxsmilesImport = new CxsmilesImport();
        this.cxsmilesImport.setOptions("c");
    }

    private final boolean addStructure(int cd_id, String smiles, int[] intFP, boolean noRingsInFP) {
        if (this.itemCount % 10000 == 0 && !this.cachePool.freeMemoryIfNecessary(this)) {
            return false;
        }
        this.ensureCapacity(this.itemCount + 1);
        this.cd_id[this.itemCount] = cd_id;
        this.noRingInfoInFP.set(this.itemCount, noRingsInFP);
        this.addData(intFP, false);
        this.blockIndex[this.itemCount] = this.block;
        this.positionInBlock[this.itemCount] = (short)(this.pos - intFP.length);
        int length = 0;
        byte[] bytes = null;
        if (smiles != null) {
            try {
                bytes = smiles.getBytes("ASCII");
                if (this.compressSmiles) {
                    bytes = this.smilesCompressor.compress(bytes);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error while compressing id=" + cd_id + ", smiles=" + smiles + ", intFP=" + Arrays.toString(intFP) + ", noRingsInFP=" + noRingsInFP, e);
            }
            this.addData(bytes);
            length = bytes.length;
            if (this.cacheType.isStructure()) {
                Molecule mol = new Molecule();
                mol.setValenceCheckState(MoleculeGraph.ValenceCheckState.OFF);
                this.screenBytesAfter[this.itemCount] = null;
                try {
                    this.cxsmilesImport.readMol(smiles, mol);
                    Molecule generalRepresentation = PolymerMatcher.getGeneralRepresentation(mol);
                    this.screenBytesAfter[this.itemCount] = this.shb.generateTargetDescriptor(generalRepresentation);
                }
                catch (IOException e) {
                    logger.log(Level.FINER, "Unable to load structure with cd_id: " + cd_id + " structure '" + smiles + "'");
                }
                catch (UnsupportedMoleculeException e) {
                    logger.log(Level.FINER, "Can't generate descriptor for structure with cd_id: " + cd_id + " structure '" + smiles + "'");
                }
            }
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("ERROR: compressed smiles exceeded maximum length");
        }
        this.smilesLength[this.itemCount] = (short)length;
        ++this.itemCount;
        return true;
    }

    private final void addData(byte[] bytes) {
        int size = BinaryDataUtil.translateBitCountToIntCount(bytes.length << 3);
        int[] ints = BinaryDataUtil.getBytesInInts(bytes, 0, size);
        this.addData(ints, true);
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.data = new int[1][];
        this.data[0] = new int[32768];
        this.noRingInfoInFP = new BitSet(this.initialCapacity);
        this.blockIndex = new int[this.initialCapacity];
        this.positionInBlock = new short[this.initialCapacity];
        this.smilesLength = new short[this.initialCapacity];
        this.screenBytesAfter = new byte[this.initialCapacity][];
        this.pos = 0;
        this.block = 0;
    }

    private final void addData(int[] ints, boolean canCrossBoundary) {
        int size = ints.length;
        int x = 0;
        if (this.pos + size >= 32768) {
            this.addBlock();
            if (canCrossBoundary) {
                while (this.pos < 32768) {
                    this.data[this.block - 1][this.pos++] = ints[x++];
                }
            }
            this.pos = 0;
        }
        for (int i = x; i < size; ++i) {
            this.data[this.block][this.pos++] = ints[i];
        }
    }

    private void addBlock() {
        ++this.block;
        if (this.block >= this.data.length) {
            int[][] newData = new int[(int)(1.25f * (float)this.data.length) + 1][];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.block] = new int[32768];
    }

    @Override
    protected final void ensureCapacity(int newCapacity) {
        super.ensureCapacity(newCapacity);
        if (this.blockIndex.length < this.cd_id.length) {
            int newSize = this.cd_id.length;
            this.blockIndex = ArrayTools.extendArray(this.blockIndex, newSize);
            this.positionInBlock = ArrayTools.extendArray(this.positionInBlock, newSize);
            this.smilesLength = ArrayTools.extendArray(this.smilesLength, newSize);
            this.noRingInfoInFP.or(new BitSet(newSize));
            byte[][] newBytes = new byte[newSize][];
            System.arraycopy(this.screenBytesAfter, 0, newBytes, 0, this.screenBytesAfter.length);
            this.screenBytesAfter = newBytes;
        }
    }

    @Override
    public int getFPColumnCount() {
        return this.fpColumnCount;
    }

    @Override
    public final void getSimilarityDescriptor(int index, int[] fp) {
        System.arraycopy(this.data[this.blockIndex[index]], this.positionInBlock[index], fp, 0, this.fpColumnCount);
    }

    @Override
    protected final void putScreenedToQueue0(int[] fp, int[] fp_noRing, Molecule query, JChemSearchOptions searchOptions, boolean isFPEquivalenceRequired, IntVector candidates, boolean isIndices, ScreenedQueueHandler sqh, IntVector nonHits) throws DatabaseSearchException {
        boolean useScreenHandler;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Start screening structures");
        }
        assert (!this.cacheType.isMarkush());
        if (!this.cacheType.isMarkush()) {
            useScreenHandler = true;
            if (!this.cacheType.isStructure() || searchOptions.getSearchType() != 2) {
                useScreenHandler = false;
            }
        } else {
            throw new DatabaseSearchException("Unable to handle markush tables with this cache implementation!");
        }
        this.putScreenedToQueueStructure(fp, fp_noRing, query, searchOptions, useScreenHandler, isFPEquivalenceRequired, candidates, isIndices, nonHits, sqh);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(sqh.getScreenedCount() + " structures passed the screening process");
            logger.finer("Finished screening structures");
        }
    }

    private final void putScreenedToQueueStructure(int[] fp, int[] fp_noRing, Molecule query, JChemSearchOptions searchOptions, boolean useScreenHandler, boolean isFPEquivalenceRequired, IntVector candidates, boolean isIndices, IntVector nonHits, ScreenedQueueHandler sqh) {
        byte[] queryDescr;
        DefaultScreenOptions screenOptions;
        boolean useHandler;
        boolean notScreenedIsNeeded;
        boolean isSuperstructure;
        block14: {
            boolean bl = isSuperstructure = searchOptions.getSearchType() == 6;
            if (this.cacheType.isReaction()) {
                this.putScreenedReactionToQueue(fp, fp_noRing, isSuperstructure, isFPEquivalenceRequired, candidates, isIndices, nonHits, sqh);
                return;
            }
            notScreenedIsNeeded = nonHits != null;
            useHandler = useScreenHandler && this.cacheType.isStructure();
            screenOptions = null;
            queryDescr = null;
            if (useHandler) {
                try {
                    screenOptions = new DefaultScreenOptions(searchOptions);
                    Molecule generalRepresentation = PolymerMatcher.getGeneralRepresentation(query);
                    queryDescr = this.shb.generateQueryDescriptor(generalRepresentation, screenOptions);
                    useHandler = true;
                }
                catch (Exception e) {
                    useHandler = false;
                    if (!logger.isLoggable(Level.FINER)) break block14;
                    String screenName = this.shb != null ? this.shb.getClass().getCanonicalName() : "null";
                    logger.log(Level.FINER, "Descriptor generation failed for query structure (screen method: " + screenName + ")");
                }
            }
        }
        int size = candidates.size();
        for (int i = 0; i < size; ++i) {
            boolean match;
            int index = this.getIndex(candidates.get(i), isIndices);
            if (index == -1) continue;
            boolean bl = match = useHandler ? this.getHandlerMatch(this.shb, queryDescr, screenOptions, this.screenBytesAfter[index]) : true;
            if (match) {
                int x;
                int[] fpQuery = this.noRingInfoInFP.get(index) ? fp_noRing : fp;
                boolean noRingInfo = this.noRingInfoInFP.get(index);
                int block = this.blockIndex[index];
                int p = this.positionInBlock[index];
                int[] d = this.data[block];
                if (isFPEquivalenceRequired && !noRingInfo) {
                    x = 0;
                    while (x < this.fpColumnCount && match) {
                        match = fpQuery[x] == d[p];
                        ++x;
                        ++p;
                    }
                } else if (isSuperstructure) {
                    x = 0;
                    while (x < this.fpColumnCount && match) {
                        match = (d[p] & fpQuery[x]) == d[p];
                        ++x;
                        ++p;
                    }
                } else {
                    x = 0;
                    while (x < this.fpColumnCount && match) {
                        match = (d[p] & fpQuery[x]) == fpQuery[x];
                        ++x;
                        ++p;
                    }
                }
            }
            if (!match) {
                if (!notScreenedIsNeeded) continue;
                nonHits.addElement(this.cd_id[index]);
                continue;
            }
            sqh.put(this.cd_id[index], index, false);
        }
    }

    private final void putScreenedReactionToQueue(int[] fp, int[] fp_noRing, boolean forSuperstructure, boolean isFPEquivalnceRequired, IntVector candidates, boolean isIndices, IntVector nonHits, ScreenedQueueHandler sqh) {
        boolean notScreenedIsNeeded = nonHits != null;
        int size = candidates.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(candidates.get(i), isIndices);
            if (index == -1) continue;
            boolean noRingInfo = this.noRingInfoInFP.get(index);
            int block = this.blockIndex[index];
            int[] d = this.data[block];
            short p = this.positionInBlock[index];
            int totalCols = this.fpColumnCount;
            int[] t_fp = new int[this.fpColumnCount];
            System.arraycopy(d, p, t_fp, 0, this.fpColumnCount);
            int[] r_fp = ReactionFingerprint.getChemicalHashedFingerprint(t_fp, this.cfpColumnCount);
            int structuralKeyColumns = this.fpColumnCount - this.cfpColumnCount;
            totalCols = r_fp.length + structuralKeyColumns;
            int[] fp_new = new int[totalCols];
            System.arraycopy(r_fp, 0, fp_new, 0, r_fp.length);
            System.arraycopy(t_fp, this.cfpColumnCount, fp_new, r_fp.length, structuralKeyColumns);
            t_fp = fp_new;
            boolean match = true;
            for (int x = 0; x < totalCols && match; ++x) {
                int query = noRingInfo ? fp_noRing[x] : fp[x];
                int target = t_fp[x];
                match = isFPEquivalnceRequired && !noRingInfo ? query == target : (forSuperstructure ? (target & query) == target : (target & query) == query);
            }
            if (!match) {
                if (!notScreenedIsNeeded) continue;
                nonHits.addElement(this.cd_id[index]);
                continue;
            }
            sqh.put(this.cd_id[index], index, false);
        }
    }

    @Override
    public IntVector getBeforeEnumScreened(int[] fp, int[] fpNoRing, byte[] queryDescr, JChemSearchOptions searchOptions, IntVector candidates, boolean isIndices, IntVector nonHits) {
        int searchType = searchOptions.getSearchType();
        if (!this.cacheType.isStructure() || searchType != 2 && searchType != 4 && searchType != 7) {
            return null;
        }
        IntVector screened = new IntVector();
        boolean notScreenedIsNeeded = nonHits != null;
        boolean useHandler = false;
        DefaultScreenOptions screenOptions = null;
        if (queryDescr != null) {
            try {
                screenOptions = new DefaultScreenOptions(searchOptions);
                useHandler = true;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Unsupported search options: " + searchOptions);
                }
                useHandler = false;
            }
        }
        int size = candidates.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(candidates.get(i), isIndices);
            if (index == -1) continue;
            boolean match = true;
            if (useHandler) {
                match = this.getHandlerMatch(this.shb, queryDescr, screenOptions, this.screenBytesAfter[index]);
            }
            int[] fpQuery = this.noRingInfoInFP.get(index) ? fpNoRing : fp;
            int block = this.blockIndex[index];
            int p = this.positionInBlock[index];
            int[] d = this.data[block];
            int x = 0;
            while (x < this.fpColumnCount && match) {
                match = (d[p] & fpQuery[x]) == fpQuery[x];
                ++x;
                ++p;
            }
            if (!match) {
                if (!notScreenedIsNeeded) continue;
                nonHits.addElement(this.cd_id[index]);
                continue;
            }
            screened.add(index);
        }
        return screened;
    }

    private boolean getHandlerMatch(ScreenHandlerBytes shb, byte[] queryDescr, ScreenOptions screenOptions, byte[] targetDescr) {
        return targetDescr == null || shb.accept(queryDescr, targetDescr, screenOptions);
    }

    @Override
    public final void getSimilarityDescritporInBytes(int index, byte[] fp) {
        int size = this.fpColumnCount;
        int block = this.blockIndex[index];
        int p = this.positionInBlock[index];
        int[] d = this.data[block];
        int j = 0;
        for (int x = 0; x < size; ++x) {
            int i = d[p];
            fp[j++] = (byte)(i >>> 24 & 0xFF);
            fp[j++] = (byte)(i >>> 16 & 0xFF);
            fp[j++] = (byte)(i >>> 8 & 0xFF);
            fp[j++] = (byte)(i & 0xFF);
            ++p;
        }
    }

    @Override
    public final byte[] getStructureStringInBytes(int index) {
        short length = this.smilesLength[index];
        if (length == 0) {
            return null;
        }
        byte[] result = new byte[length];
        int block = this.blockIndex[index];
        int p = this.positionInBlock[index] + this.fpColumnCount;
        short x = 0;
        boolean endOfString = false;
        while (!endOfString) {
            if (p >= 32768) {
                p = 0;
                ++block;
            }
            int i = this.data[block][p];
            for (int y = 0; y < 4 && !endOfString; ++y) {
                result[x] = BinaryDataUtil.getByte(i, 3 - y);
                if (++x != length) continue;
                endOfString = true;
            }
            ++p;
        }
        if (this.compressSmiles) {
            result = this.smilesCompressor.decompress(result);
        }
        return result;
    }

    @Override
    public final String getStructureString(int index) {
        if (this.cacheType.isMarkush()) {
            return null;
        }
        byte[] bytes = this.getStructureStringInBytes(index);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ScreenHandler getScreenHandler() {
        return null;
    }

    @Override
    public long getSize() {
        long result = 4L * (long)this.block * 32768L + 16L;
        if (this.data != null) {
            result += (long)this.data.length * 4L + 16L;
        }
        if (this.cd_id != null) {
            result += (long)this.cd_id.length * 4L + 16L;
        }
        if (this.noRingInfoInFP != null) {
            result += (long)(this.noRingInfoInFP.size() / 8 + 8);
        }
        if (this.blockIndex != null) {
            result += (long)this.blockIndex.length * 4L + 16L;
        }
        if (this.positionInBlock != null) {
            result += (long)this.positionInBlock.length * 2L + 16L;
        }
        if (this.smilesLength != null) {
            result += (long)this.smilesLength.length * 2L + 16L;
        }
        if (this.screenBytesAfter != null) {
            result += (long)(this.screenBytesAfter.length * 16);
            for (int i = 0; i < this.screenBytesAfter.length; ++i) {
                if (this.screenBytesAfter[i] == null) continue;
                result += (long)this.screenBytesAfter[i].length;
            }
        }
        return result;
    }

    @Override
    protected void swap(int i1, int i2) {
        super.swap(i1, i2);
        int tmp2 = this.blockIndex[i1];
        this.blockIndex[i1] = this.blockIndex[i2];
        this.blockIndex[i2] = tmp2;
        short tmp3 = this.positionInBlock[i1];
        this.positionInBlock[i1] = this.positionInBlock[i2];
        this.positionInBlock[i2] = tmp3;
        short tmp4 = this.smilesLength[i1];
        this.smilesLength[i1] = this.smilesLength[i2];
        this.smilesLength[i2] = tmp4;
        boolean tmp5 = this.noRingInfoInFP.get(i1);
        this.noRingInfoInFP.set(i1, this.noRingInfoInFP.get(i2));
        this.noRingInfoInFP.set(i2, tmp5);
        byte[] bytes = this.screenBytesAfter[i1];
        this.screenBytesAfter[i1] = this.screenBytesAfter[i2];
        this.screenBytesAfter[i2] = bytes;
    }
}

