/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.agent.NoSize;
import chemaxon.agent.ObjectSizeInfo;
import chemaxon.agent.SizeInfoFactory;
import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.CacheRegistrationUtil;
import chemaxon.jchem.db.CacheType;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.jchem.db.ScreenedQueueHandler;
import chemaxon.sss.screen.handler.ScreenHandler;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class JChemCache {
    static Logger logger = Logger.getLogger(JChemCache.class.getName());
    public static final int STATUS_LOADED = 1;
    public static final int STATUS_UPDATED = 2;
    public static final int STATUS_UNSUCCESFUL = 4;
    public static final int STATUS_OUT_OF_MEMORY = 8;
    public static final String SMARTS_SEPARATOR = Character.valueOf('\u001e').toString();
    protected static final float CAPACITY_INCREMENT_RATIO = 1.5f;
    protected static final float DATA_INCREMENT_RATIO = 1.25f;
    protected static final int DB_CHUNK_SIZE = 2000;
    protected static final int MAX_IN_CLAUSE_SIZE = 1000;
    public static final int FETCH_SIZE = 2000;
    protected static final String TABLE_ALIAS = "a";
    protected int initialCapacity;
    @NoSize
    private final List<JChemSearch> searchers = Collections.synchronizedList(new ArrayList());
    private long lastSearch = Long.MAX_VALUE;
    private final String timeStamp;
    protected final String tableName;
    protected final String logTableName;
    protected final String cacheID;
    protected String cacheHashKey = null;
    protected int[] cd_id;
    protected int itemCount = 0;
    protected int invalidItems = 0;
    protected boolean loaded = false;
    protected int rdbms;
    @NoSize
    protected Connection con = null;
    @NoSize
    protected DatabaseProperties dbProp = null;
    @NoSize
    protected CachePool cachePool;
    protected final Map<Integer, Exception> fails;
    protected boolean isRegistered = false;
    protected long registrationTime = 0L;
    protected boolean readOnlyDatabase = false;
    protected boolean indexTable = false;
    protected CacheType cacheType;
    final JChemObserverImpl observer;

    JChemCache(ConnectionHandler conh, String tableName, String cacheHashKey, String logTableName, String cacheID, int initialCapacity, CachePool cachePool, String timeStamp, boolean indexTable, JChemObserverImpl jcoImpl) throws SQLException {
        this.tableName = tableName;
        this.logTableName = logTableName;
        this.cacheID = cacheID;
        this.fails = new HashMap<Integer, Exception>();
        this.initialCapacity = initialCapacity;
        this.cachePool = cachePool;
        this.timeStamp = timeStamp;
        this.indexTable = indexTable;
        this.dbProp = new DatabaseProperties(conh, indexTable);
        this.con = conh.getConnection();
        this.rdbms = DatabaseOptions.getDBMSType(this.con);
        this.cacheHashKey = cacheHashKey;
        this.observer = jcoImpl;
    }

    private void setLastSearch(long lastSearch) {
        this.lastSearch = lastSearch;
    }

    public final long getLastSearch() {
        return this.lastSearch;
    }

    public final String getTimeStamp() {
        return this.timeStamp;
    }

    public final List<JChemSearch> getSearchers() {
        return this.searchers;
    }

    public final Map<Integer, Exception> getFails() {
        return this.fails;
    }

    public final void addSearcher(JChemSearch searcher) {
        this.searchers.add(searcher);
    }

    public final void removeSearcher(JChemSearch searcher) {
        this.searchers.remove(searcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int loadCache(ConnectionHandler conh, boolean registerCache) throws SQLException {
        boolean cacheAdministration;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cache " + this.tableName + " loading started for " + this.tableName);
        }
        this.observer.lockStateBeforeCacheLoad(this.logTableName, conh);
        int status = 0;
        this.con = conh.getConnection();
        this.setLastSearch(System.currentTimeMillis());
        boolean bl = cacheAdministration = System.currentTimeMillis() - CachePool.cacheAdministrationTimeout > this.registrationTime;
        if (cacheAdministration) {
            Vector<String> allTables = DatabaseProperties.getExistingTables(conh);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Purging tables:");
                for (String table : allTables) {
                    logger.finer(table);
                }
            }
            this.cachePool.purgeExpiredTables(this.tableName, this.cacheHashKey, allTables);
        }
        this.dbProp = new DatabaseProperties(conh, this.indexTable);
        this.readOnlyDatabase = this.dbProp.isDatabaseReadonly();
        if (!this.readOnlyDatabase && registerCache && cacheAdministration) {
            boolean permanentCache = CacheRegistrationUtil.isPermanent();
            this.isRegistered = false;
            CachePool.deleteExpiredCacheRegistrationsAndLogs(this.cacheID, conh, this.observer);
            this.registrationTime = System.currentTimeMillis();
            CachePool.manageRegistration(this.cacheID, permanentCache, this.registrationTime, conh, this.observer);
            String timestamp = new Timestamp(System.currentTimeMillis()).toString();
            CacheRegistrationUtil cru = new CacheRegistrationUtil(conh, this.observer);
            cru.updateValidityTimestamp(timestamp);
            this.isRegistered = true;
        }
        if (!this.isRegistered || !this.isValid(conh)) {
            CachePool cachePool = this.cachePool;
            synchronized (cachePool) {
                if (this.cachePool.maxCacheMemory == 0L) {
                    status |= 4;
                    status |= 8;
                } else {
                    status |= this.load(conh);
                }
                if ((status & 4) > 0) {
                    this.cachePool.cacheHash.remove(this.cacheHashKey);
                    this.logTableCacheFailure();
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cache " + this.tableName + " loading finished");
        }
        this.observer.lockStateAfterCacheLoad(this.logTableName, conh);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int load(ConnectionHandler conh) throws SQLException {
        block28: {
            block27: {
                status = 0;
                this.con = conh.getConnection();
                isCommitNeeded = conh.isCommitable() != false && this.con.getAutoCommit() == false;
                finerLogEnabled = JChemCache.logger.isLoggable(Level.FINER);
                if (this.loaded && (this.isRegistered || this.readOnlyDatabase)) break block27;
                al = new ArrayList<String>();
                al.add(this.cacheID);
                table = new ArrayList<String>(1);
                table.add(this.tableName);
                CachePool.removeLogsForExpiredCaches(conh, al, table, this.observer);
                if (finerLogEnabled) {
                    JChemCache.logger.finer("\nTotal loading of cache for table " + this.tableName);
                }
                status |= 1;
                status |= this.load((IntVector)null);
                break block28;
            }
            if (this.readOnlyDatabase) break block28;
            status |= 2;
            updates = new IntVector();
            inserts = new IntVector();
            deletes = new IntVector();
            loadByComparingIDList = false;
            loadAll = false;
            cacheMarker = CacheRegistrationUtil.generateRandomID();
            CachePool.markLogRecords(this.cacheID, this.logTableName, cacheMarker, conh, this.observer);
            sql = "SELECT update_info FROM " + this.logTableName + " WHERE " + "cache_id" + "='" + cacheMarker + "'";
            if (finerLogEnabled) {
                JChemCache.logger.finer("\nSQL for selecting marked log records:\n  " + sql);
            }
            pstmt = this.con.prepareStatement(sql);
            try {
                rs = pstmt.executeQuery();
lbl34:
                // 2 sources

                try {
                    while (rs.next()) {
                        block29: {
                            change = rs.getString(1);
                            if (change == null || change.equals("Updates")) {
                                loadAll = true;
                                break;
                            }
                            if (change.startsWith("Update:")) {
                                num = change.substring(7);
                                updates.addElement(Integer.parseInt(num));
                                continue;
                            }
                            if (!change.startsWith("Insert:")) break block29;
                            ids = change.substring(7);
                            nums = ids.split(";");
                            for (i = 0; i < nums.length; ++i) {
                                inserts.addElement(Integer.parseInt(nums[i]));
                            }
                            ** GOTO lbl34
                        }
                        if (change.startsWith("Deleted:")) {
                            num = change.substring(8);
                            deletes.addElement(Integer.parseInt(num));
                            continue;
                        }
                        if (!"Inserts".equals(change) && !"Deletes".equals(change)) continue;
                        loadByComparingIDList = true;
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                pstmt.close();
            }
            if (loadAll) {
                if (finerLogEnabled) {
                    JChemCache.logger.finer("Total reload of cache " + this.tableName + "!");
                }
                status |= this.load((IntVector)null);
                status |= 1;
            } else {
                if (loadByComparingIDList) {
                    if (finerLogEnabled) {
                        JChemCache.logger.finer("Load of cache " + this.tableName + " by comparing ID list");
                    }
                    idList = this.getMissingMarkDeleted(updates, JChemCache.logger);
                    status |= this.load(idList);
                } else {
                    if (finerLogEnabled) {
                        JChemCache.logger.finer("Loading inserted structures only into " + this.tableName);
                    }
                    this.markAsInvalid(deletes);
                    status |= this.load(inserts);
                }
                if ((status & 4) > 0) {
                    return status;
                }
                this.markAsInvalid(updates);
                if (10 * this.invalidItems > this.itemCount) {
                    if (finerLogEnabled) {
                        JChemCache.logger.finer("Total reload of " + this.tableName + ", number of invalid cache rows is greater than 10%!" + "\nInvalid rows: " + this.invalidItems + "\nRow count: " + this.itemCount);
                    }
                    status |= this.load((IntVector)null);
                    status |= 1;
                } else {
                    if (finerLogEnabled) {
                        JChemCache.logger.finer("Loading updated structures only in " + this.tableName);
                    }
                    status |= this.load(updates);
                }
            }
            CachePool.deleteMarkedLogRecords(this.logTableName, cacheMarker, conh, this.observer);
        }
        if ((status & 4) > 0) {
            return status;
        }
        this.sort();
        this.loaded = true;
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int load(IntVector idList) throws SQLException {
        int status = 0;
        this.initImporter();
        if (idList == null) {
            this.resetCache();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Cache " + this.tableName + " is reset");
            }
        } else if (idList.size() == 0) {
            return status;
        }
        if (DatabaseOptions.getDBMSType(this.con) == 8) {
            if (idList == null) {
                return this.loadHSQLDB();
            }
            return this.loadHSQLDBList(idList);
        }
        if (DatabaseOptions.getDBMSType(this.con) == 3 && idList == null) {
            String qstring = this.getSQLSelectionString();
            return this.loadMySQL(qstring);
        }
        boolean prevAutoCommit = false;
        if (this.rdbms == 7 && (prevAutoCommit = this.con.getAutoCommit())) {
            this.con.setAutoCommit(false);
        }
        boolean moreBatchToRead = false;
        int bpos = 0;
        do {
            String qstring = this.getSQLSelectionString();
            if (idList != null) {
                StringBuffer sb = new StringBuffer(" WHERE a.cd_id IN (");
                int endPos = bpos + 1000;
                if (endPos > idList.size() - 1) {
                    endPos = idList.size();
                    moreBatchToRead = false;
                } else {
                    moreBatchToRead = true;
                }
                for (int x = bpos; x < endPos; ++x) {
                    int cd_id = idList.get(x);
                    if (x != bpos) {
                        sb.append(',');
                    }
                    sb.append(cd_id);
                }
                sb.append(')');
                qstring = this.getSQLSelectionString() + sb.toString();
                bpos = endPos;
            }
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.con.createStatement();
                DatabaseOptions.setFetchSize(stmt, 2000, this.rdbms);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("\nSQL for cache " + this.tableName + " loading in load() (general case): \n  " + qstring);
                }
                rs = stmt.executeQuery(qstring);
                while (rs.next()) {
                    if (this.processResultSet(rs)) continue;
                    status |= 8;
                    rs.close();
                    stmt.close();
                    int n = status |= 4;
                    return n;
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        } while (moreBatchToRead);
        if (this.rdbms == 7 && prevAutoCommit) {
            this.con.setAutoCommit(true);
        }
        this.logCacheLoad(status, "load() (general case)");
        return status;
    }

    void initImporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadMySQL(String statement) throws SQLException {
        int status = 0;
        int minid = -1;
        int maxid = -1;
        int blockSize = 2000;
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT MIN(cd_id) FROM " + this.tableName);
            try {
                if (!rs.next()) {
                    throw new SQLException("Can't get lowest cd_id");
                }
                minid = rs.getInt(1);
            }
            finally {
                rs.close();
            }
            rs = stmt.executeQuery("SELECT MAX(cd_id) FROM " + this.tableName);
            try {
                if (!rs.next()) {
                    throw new SQLException("Can't get highest cd_id");
                }
                maxid = rs.getInt(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        if (minid == -1 || maxid == -1) {
            throw new SQLException("Can't get lowest or highest CD_ID");
        }
        int current_id = minid;
        String newStatement = statement + " WHERE " + TABLE_ALIAS + "." + "cd_id" + ">=? AND " + TABLE_ALIAS + "." + "cd_id" + "<?";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("\nSQL for cache " + this.tableName + " loading in loadMySQL(): \n  " + newStatement);
        }
        PreparedStatement pstmt = this.con.prepareStatement(newStatement);
        try {
            DatabaseOptions.setFetchSize(pstmt, 2000, this.rdbms);
            while (current_id <= maxid) {
                pstmt.setInt(1, current_id);
                pstmt.setInt(2, current_id + 2000);
                ResultSet rs = pstmt.executeQuery();
                try {
                    while (rs.next()) {
                        if (this.processResultSet(rs)) continue;
                        status |= 8;
                        int n = status |= 4;
                        return n;
                    }
                }
                finally {
                    rs.close();
                }
                current_id += 2000;
            }
        }
        finally {
            pstmt.close();
        }
        this.logCacheLoad(status, "loadMySQL()");
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadHSQLDB() throws SQLException {
        int status = 0;
        int blockSize = 1024;
        String sql = this.getSQLSelectionString() + " WHERE " + "cd_id" + ">?" + " ORDER BY " + "cd_id" + " ASC";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("\nSQL for cache " + this.tableName + " loading in loadHSQLDB(): \n  " + sql);
        }
        PreparedStatement pstmt = this.con.prepareStatement(sql);
        try {
            boolean success;
            DatabaseOptions.setFetchSize(pstmt, blockSize, this.rdbms);
            pstmt.setMaxRows(blockSize);
            int maxId = 0;
            block6: do {
                pstmt.setInt(1, maxId);
                ResultSet rs = pstmt.executeQuery();
                success = false;
                try {
                    while (rs.next()) {
                        success = true;
                        if (!this.processResultSet(rs)) {
                            status |= 8;
                            status |= 4;
                            success = false;
                            continue block6;
                        }
                        maxId = this.cd_id[this.itemCount - 1];
                    }
                }
                finally {
                    rs.close();
                }
            } while (success);
        }
        finally {
            pstmt.close();
        }
        this.logCacheLoad(status, "loadHSQLDB()");
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadHSQLDBList(IntVector idList) throws SQLException {
        int status = 0;
        String sql = this.getSQLSelectionString() + " WHERE " + TABLE_ALIAS + "." + "cd_id" + "=?";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("\nSQL for cache " + this.tableName + " loading in loadHSQLDBList(): \n  " + sql);
        }
        PreparedStatement pstmt = this.con.prepareStatement(sql);
        try {
            for (int x = 0; x < idList.size(); ++x) {
                int cd_id = 0;
                cd_id = idList.get(x);
                pstmt.setInt(1, cd_id);
                ResultSet rs = pstmt.executeQuery();
                try {
                    if (!rs.next()) {
                        rs.close();
                        continue;
                    }
                    if (this.processResultSet(rs)) continue;
                    status |= 8;
                    status |= 4;
                    rs.close();
                    break;
                }
                finally {
                    rs.close();
                }
            }
        }
        finally {
            pstmt.close();
        }
        this.logCacheLoad(status, "loadHSQLDBList()");
        return status;
    }

    private void markAsInvalid(IntVector idList) {
        for (int x = 0; x < idList.size(); ++x) {
            int idx = this.findID(idList.get(x));
            if (idx == -1) continue;
            this.fails.remove(this.cd_id[idx]);
            this.cd_id[idx] = -1;
            ++this.invalidItems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntVector getMissingMarkDeleted(IntVector exclude, Logger logger) throws SQLException {
        IntVector newList = new IntVector();
        boolean[] found = new boolean[this.cd_id.length];
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.createStatement();
            DatabaseOptions.setFetchSize(stmt, 2000, this.rdbms);
            exclude.sort();
            String sql = "SELECT cd_id FROM " + this.tableName;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Cache " + this.tableName + " start marking missing and deleted records");
                logger.finer("\nSQL for selecting cd_ids:\n  " + sql);
            }
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int id = rs.getInt(1);
                int idx = this.findID(id);
                if (idx == -1) {
                    if (exclude.indexOfWithBinarySearch(id) != -1) continue;
                    newList.addElement(id);
                    continue;
                }
                found[idx] = true;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        for (int x = 0; x < this.itemCount; ++x) {
            if (found[x]) continue;
            this.cd_id[x] = -1;
            ++this.invalidItems;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cache " + this.tableName + " finished marking invalid and deleted records");
        }
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid(ConnectionHandler conh) throws SQLException {
        this.con = conh.getConnection();
        if (!this.loaded) {
            return false;
        }
        boolean ret = false;
        Statement stmt = this.con.createStatement();
        try {
            String sql = "SELECT cache_id FROM " + this.logTableName + " WHERE " + "cache_id" + "='" + this.cacheID + "'";
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("\nSQL for checking new log records for this cache: \n" + sql);
            }
            ResultSet rs = stmt.executeQuery(sql);
            try {
                ret = !rs.next();
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return ret;
    }

    private void logCacheLoad(int status, String dbName) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("\nCache " + this.tableName + " loading is ended in " + dbName + "." + "\nCache status: " + status);
            logger.finer(this.itemCount + " structures loaded into cache");
            this.logCachedTables();
        }
    }

    private void logTableCacheFailure() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("\nCache " + this.tableName + " load was unsuccesful, " + "(hash key: " + this.cacheHashKey + ") has been removed from cache pool.");
        }
        this.logCachedTables();
    }

    private void logCachedTables() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("\nLoaded caches:");
            Hashtable<String, Long> cachedTables = this.cachePool.getCachedTables(false);
            for (Map.Entry element : cachedTables.entrySet()) {
                logger.finer("** Hash key: " + (String)element.getKey() + ", estimated size: " + element.getValue());
            }
        }
    }

    public abstract int getFPColumnCount();

    public int getID(int index) {
        return this.cd_id[index];
    }

    public int findID(int key) {
        int pos = Arrays.binarySearch(this.cd_id, 0, this.itemCount, key);
        return pos >= 0 ? pos : -1;
    }

    public IntVector getAllIDs() {
        IntVector result = new IntVector(this.itemCount);
        for (int x = 0; x < this.itemCount; ++x) {
            int id = this.cd_id[x];
            if (id == -1) continue;
            result.addElement(id);
        }
        return result;
    }

    public IntVector getAllIndices() {
        IntVector result = new IntVector(this.itemCount);
        for (int x = 0; x < this.itemCount; ++x) {
            if (this.cd_id[x] == -1) continue;
            result.add(x);
        }
        return result;
    }

    public IntVector convertIndicesToID(IntVector list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.set(i, this.cd_id[list.get(i)]);
        }
        return list;
    }

    public IntVector convertIDsToIndices(IntVector list) {
        int j = 0;
        int index = -1;
        for (int i = 0; i < list.size(); ++i) {
            index = this.findID(list.get(i));
            if (index == -1) continue;
            list.set(j, index);
            ++j;
        }
        list.setSize(j);
        return list;
    }

    public int getStructureCount() {
        return this.itemCount;
    }

    protected void acceptAllScreenCandidates(IntVector candidates, boolean isIndices, ScreenedQueueHandler sqh, boolean checkDuplicates) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Cache " + this.tableName + " screening accepts all candidates ...");
        }
        int size = candidates.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(candidates.get(i), isIndices);
            if (index == -1) continue;
            sqh.put(this.cd_id[index], index, checkDuplicates);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Cache " + this.tableName + " all candidates accepted");
        }
    }

    protected void ensureCapacity(int newCapacity) {
        if (this.cd_id.length < newCapacity) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Cache " + this.tableName + " ensuring capacity for " + newCapacity + " structures");
            }
            int oldSize = this.cd_id.length;
            int newSize = Math.max((int)((float)oldSize * 1.5f) + 100, newCapacity + 1);
            this.cd_id = ArrayTools.extendArray(this.cd_id, newSize);
        }
    }

    protected abstract String getSQLSelectionString();

    protected abstract boolean processResultSet(ResultSet var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putScreenedToQueue(int[] fp, int[] fp_noRing, Molecule query, JChemSearchOptions searchOptions, boolean isFPEquivalenceRequired, IntVector candidates, boolean isIndices, IntVector nonHits, ScreenedQueueHandler sqh) throws DatabaseSearchException {
        try {
            this.putScreenedToQueue0(fp, fp_noRing, query, searchOptions, isFPEquivalenceRequired, candidates, isIndices, sqh, nonHits);
        }
        finally {
            sqh.close();
        }
    }

    public abstract IntVector getBeforeEnumScreened(int[] var1, int[] var2, byte[] var3, JChemSearchOptions var4, IntVector var5, boolean var6, IntVector var7);

    protected final int getIndex(int value, boolean isIndex) {
        if (isIndex) {
            if (this.itemCount <= value || this.cd_id[value] == -1) {
                return -1;
            }
            return value;
        }
        return this.findID(value);
    }

    protected abstract void putScreenedToQueue0(int[] var1, int[] var2, Molecule var3, JChemSearchOptions var4, boolean var5, IntVector var6, boolean var7, ScreenedQueueHandler var8, IntVector var9) throws DatabaseSearchException;

    protected void resetCache() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cache " + this.tableName + " reseting");
        }
        this.cd_id = new int[this.initialCapacity];
        this.itemCount = 0;
        this.invalidItems = 0;
        this.fails.clear();
    }

    public abstract void getSimilarityDescriptor(int var1, int[] var2) throws UnsupportedOperationException;

    public abstract void getSimilarityDescritporInBytes(int var1, byte[] var2);

    public abstract byte[] getStructureStringInBytes(int var1);

    public abstract ScreenHandler getScreenHandler();

    public abstract String getStructureString(int var1);

    public abstract long getSize();

    public long getInstrumentedSize() {
        SizeInfoFactory sf = new SizeInfoFactory();
        ObjectSizeInfo osi = sf.getBestImplementationUCanget();
        return osi.deepSizeOf((Object)this);
    }

    private void sort() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cache " + this.tableName + " sorting structures by cd_id");
        }
        this.sort1(0, this.itemCount);
    }

    private void sort1(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.compare(j - 1, j); --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        int v = this.cd_id[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.cd_id[b] <= v) {
                if (this.cd_id[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.cd_id[c] >= v) {
                if (this.cd_id[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort1(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort1(n - s, s);
        }
    }

    private boolean compare(int i1, int i2) {
        return this.cd_id[i1] > this.cd_id[i2];
    }

    private int med3(int a, int b, int c) {
        int av = this.cd_id[a];
        int bv = this.cd_id[b];
        int cv = this.cd_id[c];
        return av < bv ? (bv < cv ? b : (av < cv ? c : a)) : (bv > cv ? b : (av > cv ? c : a));
    }

    private void vecswap(int a, int b, int n) {
        int aa = a;
        int bb = b;
        int i = 0;
        while (i < n) {
            this.swap(aa, bb);
            ++i;
            ++aa;
            ++bb;
        }
    }

    protected void swap(int i1, int i2) {
        int tmp = this.cd_id[i1];
        this.cd_id[i1] = this.cd_id[i2];
        this.cd_id[i2] = tmp;
    }
}

