/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.JChemObserver;
import chemaxon.util.ConnectionHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

final class JChemObserverImpl
implements JChemObserver {
    private final List<JChemObserver> list;
    private final boolean empty;

    private JChemObserverImpl(List<JChemObserver> list) {
        this.list = list;
        this.empty = list.isEmpty();
    }

    @Override
    public void lockStateBeforeCacheLoad(String tableName, ConnectionHandler ch) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateBeforeCacheLoad(tableName, ch);
        }
    }

    @Override
    public void lockStateAfterCacheLoad(String tableName, ConnectionHandler ch) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterCacheLoad(tableName, ch);
        }
    }

    static JChemObserverImpl create(JChemObserver obs) {
        ServiceLoader<JChemObserver> loader = ServiceLoader.load(JChemObserver.class);
        ArrayList<JChemObserver> list = new ArrayList<JChemObserver>();
        Iterator<JChemObserver> it = loader.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        if (obs != null) {
            list.add(obs);
        }
        return new JChemObserverImpl(list);
    }

    @Override
    public void lockStateAfterLogTablePurge(String logTableToPurge, ConnectionHandler conh) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterLogTablePurge(logTableToPurge, conh);
        }
    }

    @Override
    public void lockStateAfterLogTablePurgeException(String logTableToPurge, ConnectionHandler conh) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterLogTablePurgeException(logTableToPurge, conh);
        }
    }

    @Override
    public void lockStateAfterCRTableMark(String logTableName, ConnectionHandler conh) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterCRTableMark(logTableName, conh);
        }
    }

    @Override
    public void lockStateAfterCRTableDeleteMarked(String logTableName, ConnectionHandler conh) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterCRTableDeleteMarked(logTableName, conh);
        }
    }

    @Override
    public void lockStateAfterTableRegistered(String crTable, ConnectionHandler conh) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterTableRegistered(crTable, conh);
        }
    }

    @Override
    public void lockStateAfterRegisteringCache(String registerTablename, ConnectionHandler conh) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterRegisteringCache(registerTablename, conh);
        }
    }

    @Override
    public void lockStateAfterUnregistring(String registerTablename, ConnectionHandler conh) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterUnregistring(registerTablename, conh);
        }
    }

    @Override
    public void lockStateAfterIsCacheIDRegistered(String cacheTable, ConnectionHandler conh) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterIsCacheIDRegistered(cacheTable, conh);
        }
    }

    @Override
    public void lockStateAfterGettingTimestamp(String cacheTable, ConnectionHandler conh) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterGettingTimestamp(cacheTable, conh);
        }
    }

    @Override
    public void lockStateAfterAddingTimestamp(String propertyTable, ConnectionHandler conh) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterAddingTimestamp(propertyTable, conh);
        }
    }

    @Override
    public void lockStateAfterUpdatingTimestamp(String propertyTable, ConnectionHandler conh) {
        if (this.empty) {
            return;
        }
        for (JChemObserver jChemObserver : this.list) {
            jChemObserver.lockStateAfterUpdatingTimestamp(propertyTable, conh);
        }
    }
}

