/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.FingerprintHandler;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.MarkushCacheBase;
import chemaxon.jchem.db.ScreenedQueueHandler;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.util.BinaryDataUtil;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.logging.Level;

abstract class MarkushFPCacheBase
extends MarkushCacheBase {
    protected static final int BLOCK_SIZE = 32768;
    protected int[][] data;
    protected int block;
    protected short pos;
    protected int fpColumnCount;
    protected final int[] intFP;
    protected BitSet noRingInfoInFP;
    protected int[] blockIndex;
    protected short[] positionInBlock;

    public MarkushFPCacheBase(ConnectionHandler conh, String tableName, String cacheHashKey, int columnsToCache, int initialCapacity, boolean indexTable, CachePool cachePool, String timeStamp, JChemObserverImpl jcoImpl) throws SQLException, DatabaseSearchException {
        super(conh, tableName, cacheHashKey, initialCapacity, indexTable, cachePool, timeStamp, jcoImpl);
        this.fpColumnCount = columnsToCache;
        if (this.fpColumnCount == 0) {
            int numberOfBits = 0;
            numberOfBits = FingerprintHandler.getNumberOfBits(conh, tableName, indexTable);
            if (numberOfBits == Integer.MIN_VALUE) {
                throw new DatabaseSearchException("No fingerprint information for " + tableName + "\n" + " Run \"jcman -t\" or check the JChemProperties table for structure tables");
            }
            int cfpColumnCount = BinaryDataUtil.translateBitCountToIntCount(numberOfBits);
            this.fpColumnCount = cfpColumnCount + FingerprintHandler.getNumberOfStructuralFPColumns(conh, tableName, indexTable);
        }
        this.intFP = new int[this.fpColumnCount];
    }

    @Override
    protected boolean processResultSet(ResultSet rs) {
        int columnIndex = 1;
        int cd_id = -1;
        try {
            cd_id = rs.getInt(columnIndex++);
            for (int i = 0; i < this.fpColumnCount; ++i) {
                this.intFP[i] = rs.getInt(columnIndex++);
            }
            String flags = rs.getString(columnIndex++);
            boolean noRingsInFP = UpdateHandler.flagsIndicateNoRingInfoInFP(flags);
            byte[] markushData = DatabaseTools.readBytes(rs, columnIndex++);
            byte[][] markushDescriptorData = new byte[this.markushDescriptorTables.length][];
            for (int i = 0; i < this.markushDescriptorTables.length; ++i) {
                markushDescriptorData[i] = rs.getBytes(columnIndex++);
            }
            return this.addStructure(cd_id, this.intFP, noRingsInFP, markushData, markushDescriptorData);
        }
        catch (Exception e) {
            if (cd_id != -1) {
                this.fails.put(cd_id, e);
            }
            return true;
        }
    }

    protected void addData(int[] intFP) {
        if (this.pos + this.fpColumnCount >= 32768) {
            this.addBlock();
            this.pos = 0;
        }
        for (int i = 0; i < this.fpColumnCount; ++i) {
            short s = this.pos;
            this.pos = (short)(s + 1);
            this.data[this.block][s] = intFP[i];
        }
    }

    protected void addBlock() {
        ++this.block;
        if (this.block >= this.data.length) {
            int[][] newData = new int[(int)(1.25f * (float)this.data.length) + 1][];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.block] = new int[32768];
    }

    protected abstract boolean addStructure(int var1, int[] var2, boolean var3, byte[] var4, byte[][] var5) throws SQLException;

    @Override
    protected void putMarkushScreenedToQueue(int[] fp, int[] fp_noRing, Molecule query, JChemSearchOptions searchOptions, boolean isSuperstructure, boolean isFullSearch, IntVector candidates, boolean isIndices, ScreenedQueueHandler sqh, IntVector nonHits) throws DatabaseSearchException {
        this.putMarkushScreenedToQueue(fp, fp_noRing, query, searchOptions, candidates, isIndices, sqh, nonHits);
    }

    protected final boolean acceptMarkushTarget(int index, int[] fp, int[] fp_noRing, boolean isSuperstructure) {
        int[] queryFp;
        boolean match = true;
        boolean noRingInfo = this.noRingInfoInFP.get(index);
        int block = this.blockIndex[index];
        int p = this.positionInBlock[index];
        int[] d = this.data[block];
        int[] nArray = queryFp = noRingInfo ? fp_noRing : fp;
        if (isSuperstructure) {
            int x = 0;
            while (x < this.fpColumnCount && match) {
                match = (d[p] & queryFp[x]) == d[p];
                ++x;
                ++p;
            }
        } else {
            int x = 0;
            while (x < this.fpColumnCount && match) {
                match = (d[p] & queryFp[x]) == queryFp[x];
                ++x;
                ++p;
            }
        }
        return match;
    }

    protected abstract void putMarkushScreenedToQueue(int[] var1, int[] var2, Molecule var3, JChemSearchOptions var4, IntVector var5, boolean var6, ScreenedQueueHandler var7, IntVector var8) throws DatabaseSearchException;

    @Override
    public final void getSimilarityDescriptor(int index, int[] fp) {
        System.arraycopy(this.data[this.blockIndex[index]], this.positionInBlock[index], fp, 0, this.fpColumnCount);
    }

    @Override
    public final void getSimilarityDescritporInBytes(int index, byte[] fp) {
        int size = this.fpColumnCount;
        int block = this.blockIndex[index];
        int p = this.positionInBlock[index];
        int[] d = this.data[block];
        int j = 0;
        for (int x = 0; x < size; ++x) {
            int i = d[p];
            fp[j++] = (byte)(i >>> 24 & 0xFF);
            fp[j++] = (byte)(i >>> 16 & 0xFF);
            fp[j++] = (byte)(i >>> 8 & 0xFF);
            fp[j++] = (byte)(i & 0xFF);
            ++p;
        }
    }

    @Override
    public int getFPColumnCount() {
        return this.fpColumnCount;
    }

    @Override
    protected String getSQLSelectionString() {
        int i;
        StringBuffer sb = new StringBuffer("SELECT ");
        sb.append("a.");
        sb.append("cd_id");
        sb.append(",");
        for (int i2 = 0; i2 < this.fpColumnCount; ++i2) {
            sb.append(" a.");
            sb.append("cd_fp");
            sb.append(i2 + 1);
            sb.append(",");
        }
        sb.append(" a.");
        sb.append("cd_flags");
        int descLength = this.markushDescriptorTables.length;
        sb.append(",");
        sb.append(" a.");
        sb.append("cd_markush");
        for (i = 0; i < descLength; ++i) {
            sb.append(", a" + i + "." + "md_data");
        }
        sb.append(" FROM ");
        for (i = 0; i < descLength; ++i) {
            sb.append("(");
        }
        sb.append(this.tableName);
        sb.append(" a");
        for (i = 0; i < descLength; ++i) {
            sb.append(" LEFT OUTER JOIN ");
            sb.append(this.markushDescriptorTables[i]);
            sb.append(" a" + i);
            sb.append(" ON a.cd_id = a" + i);
            sb.append(".cd_id");
            sb.append(")");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("SQL selection string: " + sb.toString());
        }
        return sb.toString();
    }

    @Override
    protected void ensureCapacity(int newCapacity) {
        super.ensureCapacity(newCapacity);
        if (this.blockIndex.length < this.cd_id.length) {
            int newSize = this.cd_id.length;
            this.blockIndex = ArrayTools.extendArray(this.blockIndex, newSize);
            this.positionInBlock = ArrayTools.extendArray(this.positionInBlock, newSize);
            this.noRingInfoInFP.or(new BitSet(newSize));
        }
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.data = new int[1][];
        this.data[0] = new int[32768];
        this.noRingInfoInFP = new BitSet(this.initialCapacity);
        this.blockIndex = new int[this.initialCapacity];
        this.positionInBlock = new short[this.initialCapacity];
        this.block = 0;
        this.pos = 0;
    }

    @Override
    protected void swap(int i1, int i2) {
        super.swap(i1, i2);
        int btmp = this.blockIndex[i1];
        this.blockIndex[i1] = this.blockIndex[i2];
        this.blockIndex[i2] = btmp;
        short ptmp = this.positionInBlock[i1];
        this.positionInBlock[i1] = this.positionInBlock[i2];
        this.positionInBlock[i2] = ptmp;
        boolean rtmp = this.noRingInfoInFP.get(i1);
        this.noRingInfoInFP.set(i1, this.noRingInfoInFP.get(i2));
        this.noRingInfoInFP.set(i2, rtmp);
    }
}

