/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.common.util.IntVector;
import chemaxon.descriptors.MarkushDescriptor;
import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.MarkushFPCacheBase;
import chemaxon.jchem.db.ScreenedQueueHandler;
import chemaxon.sss.screen.DefaultMarkushScreenOptions;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.sss.search.options.HomologyTranslationOption;
import chemaxon.sss.search.options.MarkushScreeningType;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.sql.SQLException;
import java.util.logging.Level;

final class MarkushFPDataCache
extends MarkushFPCacheBase {
    private byte[][][] markushDescriptorData;

    public MarkushFPDataCache(ConnectionHandler conh, String tableName, String cacheHashKey, int columnsToCache, int initialCapacity, boolean indexTable, CachePool cachePool, String timeStamp, JChemObserverImpl jcoImpl) throws SQLException, DatabaseSearchException {
        super(conh, tableName, cacheHashKey, columnsToCache, initialCapacity, indexTable, cachePool, timeStamp, jcoImpl);
        this.resetCache();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("\nMarkush(fingerprint, raw data) cache created.\n** Cache ID: " + this.cacheID + "\n** Table name: " + tableName + "\n** Logtable name: " + this.logTableName + "\n** Cache hash key: " + cacheHashKey);
        }
    }

    @Override
    protected void putMarkushScreenedToQueue(int[] fp, int[] fp_noRing, Molecule query, JChemSearchOptions searchOptions, IntVector candidates, boolean isIndices, ScreenedQueueHandler sqh, IntVector nonHits) throws DatabaseSearchException {
        int descLength = this.markushDescriptorNames.length;
        MarkushDescriptor[] queryDesc = new MarkushDescriptor[descLength];
        for (int descIndex = 0; descIndex < descLength; ++descIndex) {
            try {
                queryDesc[descIndex] = this.createMarkushDescriptor(descIndex);
                DefaultMarkushScreenOptions screenOptions = new DefaultMarkushScreenOptions(searchOptions);
                queryDesc[descIndex].generateQueryDescriptor(query, screenOptions);
                continue;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Error in first phase of Markush screening: " + e.getMessage());
                }
                this.acceptAllScreenCandidates(candidates, isIndices, sqh, false);
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Markush screening finished");
                }
                throw new DatabaseSearchException(e);
            }
        }
        boolean notScreenedIsNeeded = nonHits != null;
        boolean useFingerprints = searchOptions.getHomologyBroadTranslation() == HomologyTranslationOption.NONE && searchOptions.getHomologyNarrowTranslation() == HomologyTranslationOption.NONE;
        useFingerprints &= searchOptions.getMarkushScreeningType(MarkushScreeningType.FINGERPRINT);
        boolean useAtomstat = searchOptions.getMarkushScreeningType(MarkushScreeningType.ATOMSTAT);
        MarkushDescriptor[] targetDescriptors = new MarkushDescriptor[descLength];
        for (int descIndex = 0; descIndex < descLength; ++descIndex) {
            try {
                targetDescriptors[descIndex] = this.createMarkushDescriptor(descIndex);
                continue;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Error while creating " + this.markushDescriptorNames[descIndex] + "markush descriptor for target: " + e.getMessage());
                }
                this.acceptAllScreenCandidates(candidates, isIndices, sqh, false);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Markush screening finished");
                }
                return;
            }
        }
        int size = candidates.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(candidates.get(i), isIndices);
            if (index == -1) continue;
            boolean match = true;
            if (useFingerprints) {
                match = this.acceptMarkushTarget(index, fp, fp_noRing, searchOptions.getSearchType() == 6);
            }
            if (useAtomstat) {
                for (int descIndex = 0; descIndex < descLength && match; ++descIndex) {
                    if (this.markushDescriptorData[index][descIndex] == null) continue;
                    targetDescriptors[descIndex].fromData(this.markushDescriptorData[index][descIndex]);
                    match = queryDesc[descIndex].acceptTarget(targetDescriptors[descIndex]);
                }
            }
            if (!match) {
                if (!notScreenedIsNeeded) continue;
                nonHits.addElement(this.cd_id[index]);
                continue;
            }
            sqh.put(this.cd_id[index], index, false);
        }
    }

    @Override
    protected boolean addStructure(int cd_id, int[] intFP, boolean noRingsInFP, byte[] markushData, byte[][] markushDescriptorData) {
        if (this.itemCount % 2000 == 0 && !this.cachePool.freeMemoryIfNecessary(this)) {
            return false;
        }
        this.ensureCapacity(this.itemCount + 1);
        this.cd_id[this.itemCount] = cd_id;
        this.noRingInfoInFP.set(this.itemCount, noRingsInFP);
        this.addData(intFP);
        this.blockIndex[this.itemCount] = this.block;
        this.positionInBlock[this.itemCount] = (short)(this.pos - this.fpColumnCount);
        this.markushData[this.itemCount] = markushData;
        this.markushDescriptorData[this.itemCount] = markushDescriptorData;
        ++this.itemCount;
        return true;
    }

    @Override
    protected void ensureCapacity(int newCapacity) {
        super.ensureCapacity(newCapacity);
        if (this.markushDescriptorData.length < this.cd_id.length) {
            byte[][][] newMarkushDescriptorData = new byte[this.cd_id.length][][];
            System.arraycopy(this.markushDescriptorData, 0, newMarkushDescriptorData, 0, this.markushDescriptorData.length);
            this.markushDescriptorData = newMarkushDescriptorData;
        }
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.block = 0;
        this.pos = 0;
        this.markushDescriptorData = new byte[this.initialCapacity][][];
    }

    @Override
    public long getSize() {
        long result = 0L;
        if (this.cd_id != null) {
            result += (long)this.cd_id.length * 4L + 16L;
        }
        if (this.data != null) {
            result += (long)this.data.length * 4L + 16L;
            result += (long)this.data.length * 32768L * 4L + 16L;
        }
        if (this.noRingInfoInFP != null) {
            result += (long)(this.noRingInfoInFP.size() / 8 + 8);
        }
        if (this.blockIndex != null) {
            result += (long)this.blockIndex.length * 4L + 16L;
        }
        if (this.positionInBlock != null) {
            result += (long)this.positionInBlock.length * 2L + 16L;
        }
        if (this.markushData != null) {
            result += (long)this.markushData.length * 4L + 16L;
            for (int x = 0; x < this.markushData.length; ++x) {
                byte[] markush = this.markushData[x];
                if (markush == null) continue;
                result += (long)(markush.length + 16);
            }
        }
        if (this.markushDescriptorData != null) {
            result += (long)this.markushDescriptorData.length * 4L + 16L;
            for (int i = 0; i < this.itemCount; ++i) {
                result += (long)(this.markushDescriptorData[i].length * 4 + 16);
                for (int j = 0; j < this.markushDescriptorData[i].length; ++j) {
                    if (this.markushDescriptorData[i][j] == null) continue;
                    result += (long)(this.markushDescriptorData[i][j].length + 16);
                }
            }
        }
        return result;
    }

    @Override
    protected void swap(int i1, int i2) {
        super.swap(i1, i2);
        byte[][] dtmp = this.markushDescriptorData[i1];
        this.markushDescriptorData[i1] = this.markushDescriptorData[i2];
        this.markushDescriptorData[i2] = dtmp;
    }
}

