/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.DBUtil;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.RegenerationChecker;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.ConnectionHandler;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;

public class PreRegeneration {
    private final ConnectionHandler conh;
    private final DatabaseProperties dbProps;
    public static final String PROP_PREREGEN_VERSION = "preregen.version";
    public static final String PROP_PREREGEN_VALIDITY = "preregen.validity";
    public static final String PROP_PREREGEN_STATUS = "preregen.status";
    public static final String VALUE_STATUS_READY = "1";
    public static final String VALUE_STATUS_NOT_READY = "0";
    public static final String[] EXCLUDED_TABLE_PROPS_FOR_INVALIDATION = new String[]{"preregen.validity", "preregen.status", "absolutestereo"};

    public PreRegeneration(ConnectionHandler conh) throws SQLException {
        this.conh = conh;
        this.dbProps = new DatabaseProperties(conh, false);
    }

    private static boolean isSupportedDBType(int dbmsType) {
        return dbmsType == 1 || dbmsType == 3 || dbmsType == 2 || dbmsType == 7;
    }

    public static boolean isSupportedDB(ConnectionHandler conh) throws SQLException {
        return PreRegeneration.isSupportedDBType(new DatabaseProperties((ConnectionHandler)conh, (boolean)false).dbmsType);
    }

    private void checkDB() throws SQLException {
        if (!PreRegeneration.isSupportedDBType(this.dbProps.dbmsType)) {
            throw new SQLException("Operation is not supported for this database");
        }
    }

    private String createHashFromTableProperties(Map<String, String> tableProperties) {
        String hashInput = "";
        for (String key : tableProperties.keySet()) {
            if (Arrays.asList(EXCLUDED_TABLE_PROPS_FOR_INVALIDATION).contains(key.toLowerCase())) continue;
            hashInput = hashInput + key + "*" + tableProperties.get(key) + "*";
        }
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(hashInput.getBytes());
        return Long.toString(crc.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTempTable(String jchemTableName, int regenerationType) throws SQLException {
        this.checkDB();
        String tempTableName = PreRegeneration.getTempTableName(jchemTableName);
        List<String> regenColumns = RegenerationChecker.getColumnsToRegenerate(this.conh, jchemTableName, regenerationType);
        StringBuffer columns = new StringBuffer("cd_id");
        if (!regenColumns.isEmpty()) {
            for (String column : regenColumns) {
                columns.append(",").append(column);
            }
        }
        String sql = "CREATE TABLE " + tempTableName + " AS SELECT " + columns.toString() + " FROM " + jchemTableName + " WHERE 1=2";
        if (this.dbProps.dbmsType == 2) {
            sql = "SELECT " + columns.toString() + " INTO " + tempTableName + " FROM " + jchemTableName + " WHERE 1=2";
        }
        Statement stmt = this.conh.getConnection().createStatement();
        try {
            stmt.execute(sql);
            sql = "ALTER TABLE " + tempTableName + " ADD PRIMARY KEY (" + "cd_id" + ")";
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
        this.dbProps.setTableProperty(jchemTableName, PROP_PREREGEN_VERSION, Integer.toString(VersionInfo.JCHEM_TABLE_VERSION));
        this.dbProps.setTableProperty(jchemTableName, PROP_PREREGEN_STATUS, VALUE_STATUS_NOT_READY);
        Map<String, String> tableProperties = this.dbProps.getTableProperties(jchemTableName);
        this.dbProps.setTableProperty(jchemTableName, PROP_PREREGEN_VALIDITY, this.createHashFromTableProperties(tableProperties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTempTable(String jchemTableName) throws SQLException {
        this.checkDB();
        try {
            DBUtil.dropTable(this.conh.getConnection(), PreRegeneration.getTempTableName(jchemTableName));
        }
        finally {
            this.dbProps.deleteTableProperty(jchemTableName, PROP_PREREGEN_VALIDITY);
            this.dbProps.deleteTableProperty(jchemTableName, PROP_PREREGEN_STATUS);
            this.dbProps.deleteTableProperty(jchemTableName, PROP_PREREGEN_VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRegeneratedColumns(String tempTableName) throws SQLException {
        ArrayList<String> regenColumns = new ArrayList<String>();
        Statement stmt = this.conh.getConnection().createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tempTableName + " WHERE 1=2");
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String columnName = rsmd.getColumnName(i).toLowerCase();
                    if (columnName.equals("cd_id")) continue;
                    regenColumns.add(columnName);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return regenColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyRegeneratedData(String jchemTableName) throws SQLException {
        this.checkDB();
        String tempTableName = PreRegeneration.getTempTableName(jchemTableName);
        List<String> regenColumns = this.getRegeneratedColumns(tempTableName);
        if (!regenColumns.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            boolean first = true;
            if (this.dbProps.dbmsType == 3) {
                sql.append("UPDATE ").append(jchemTableName).append(" AS t,").append(tempTableName).append(" AS s SET ");
                for (String column : regenColumns) {
                    if (!first) {
                        sql.append(",");
                    } else {
                        first = false;
                    }
                    sql.append("t.").append(column).append("=s.").append(column);
                }
                sql.append(" WHERE ").append("t.").append("cd_id").append("=").append("s.").append("cd_id").append(" AND t.").append("cd_pre_calculated").append("=1");
            } else if (this.dbProps.dbmsType == 1) {
                sql.append("MERGE INTO ").append(jchemTableName).append(" t USING ").append(tempTableName).append(" s").append(" ON (s.").append("cd_id").append("=t.").append("cd_id").append(" AND t.").append("cd_pre_calculated").append("=1").append(") WHEN MATCHED THEN UPDATE SET ");
                for (String column : regenColumns) {
                    if (!first) {
                        sql.append(",");
                    } else {
                        first = false;
                    }
                    sql.append("t.").append(column).append("=s.").append(column);
                }
            } else if (this.dbProps.dbmsType == 2) {
                sql.append("UPDATE t SET ");
                for (String column : regenColumns) {
                    if (!first) {
                        sql.append(",");
                    } else {
                        first = false;
                    }
                    sql.append("t.").append(column).append("=s.").append(column);
                }
                sql.append(" FROM ").append(tempTableName).append(" s JOIN ").append(jchemTableName).append(" t ON t.").append("cd_id").append("=s.").append("cd_id").append(" AND t.").append("cd_pre_calculated").append("=1");
            } else if (this.dbProps.dbmsType == 7) {
                sql.append("UPDATE ").append(jchemTableName).append(" AS t SET ");
                for (String column : regenColumns) {
                    if (!first) {
                        sql.append(",");
                    } else {
                        first = false;
                    }
                    sql.append(column).append("=s.").append(column);
                }
                sql.append(" FROM ").append(tempTableName).append(" AS s WHERE ").append("t.").append("cd_id").append("=s.").append("cd_id").append(" AND t.").append("cd_pre_calculated").append("=1");
            }
            Statement stmt = this.conh.getConnection().createStatement();
            try {
                stmt.executeUpdate(sql.toString());
            }
            finally {
                stmt.close();
            }
        }
    }

    public static String getTempTableName(String jchemTableName) {
        return jchemTableName + "_PR";
    }

    public boolean isValid(String jchemTableName) throws SQLException {
        String validity = this.dbProps.getTableProperty(jchemTableName, PROP_PREREGEN_VALIDITY);
        Map<String, String> tableProperties = this.dbProps.getTableProperties(jchemTableName);
        return validity != null && validity.equals(this.createHashFromTableProperties(tableProperties));
    }

    public String getStatus(String jchemTableName) throws SQLException {
        return this.dbProps.getTableProperty(jchemTableName, PROP_PREREGEN_STATUS);
    }

    public String getVersion(String jchemTableName) throws SQLException {
        return this.dbProps.getTableProperty(jchemTableName, PROP_PREREGEN_VERSION);
    }

    public int getPreRegenerationType(String jchemTableName) throws SQLException {
        this.checkDB();
        String tempTableName = PreRegeneration.getTempTableName(jchemTableName);
        List<String> regenColumns = this.getRegeneratedColumns(tempTableName);
        if (regenColumns.isEmpty()) {
            return -1;
        }
        boolean ctColumnFound = false;
        boolean cdColumnFound = false;
        for (String column : regenColumns) {
            if (column.startsWith("cd_")) {
                cdColumnFound = true;
            } else {
                ctColumnFound = true;
            }
            if (!cdColumnFound || !ctColumnFound) continue;
            break;
        }
        if (ctColumnFound) {
            if (cdColumnFound) {
                return 0;
            }
            return 1;
        }
        if (cdColumnFound) {
            return 2;
        }
        return -1;
    }

    public DatabaseProperties getDbProperties() {
        return this.dbProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preRegeneratedDataExist(String jchemTableName) throws SQLException {
        String preRegenVersion = this.getVersion(jchemTableName);
        if (preRegenVersion == null) {
            return false;
        }
        if (!this.isValid(jchemTableName)) {
            System.out.println("Precalculated data are invalid: " + jchemTableName);
            return false;
        }
        String status = this.getStatus(jchemTableName);
        if (status == null || !status.equals(VALUE_STATUS_READY)) {
            System.out.println("Precalculation has not finished: " + jchemTableName);
            return false;
        }
        Statement stmt = this.conh.getConnection().createStatement();
        try {
            stmt.execute("SELECT * FROM " + PreRegeneration.getTempTableName(jchemTableName) + " WHERE 1=2");
        }
        catch (SQLException e) {
            System.out.println("Temporary table of precalculated data does not exist: " + jchemTableName);
            boolean bl = false;
            return bl;
        }
        finally {
            stmt.close();
        }
        if (!preRegenVersion.equals("" + VersionInfo.JCHEM_TABLE_VERSION)) {
            System.out.println("Precalculated data have been generated with another version of JChem: " + jchemTableName);
            return false;
        }
        return true;
    }
}

