/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.DBUtil;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.PreRegeneration;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.db.RecalculationException;
import chemaxon.jchem.db.RegenerationChecker;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.db.Updater;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Regenerator {
    private String tableName = null;
    private String tempTableName = null;
    private boolean changeStandardization = false;
    private String standardizerConfig = null;
    private Map chemTermColCfg = null;
    private Boolean tautomerDuplicateFiltering = null;
    private ProgressWriter pw = null;
    private ConnectionHandler ch = null;
    private ConnectionHandler[] connections = null;
    private RegenThread[] regenThreads = null;
    private static final int MAX_AUTO_THREADS = 8;
    private static final int DEFAULT_THREADS = 2;
    private int threadCount = 2;
    private ResultSet idResultSet = null;
    private PreparedStatement readerStatement = null;
    private Statement idReaderStmt = null;
    private volatile int counter = 0;
    private static final int COMMIT_INTERVAL = 1000;
    private boolean autoCommit = false;
    private boolean chemTermCalcNeeded = true;
    private int regenMode = 0;
    public boolean wasError = false;
    private static final Log log = LogFactory.getLog(Regenerator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MolData getNextMolData() throws SQLException {
        MolData result = null;
        while (!this.pw.isCanceled() && this.idResultSet.next()) {
            int id = this.idResultSet.getInt(1);
            byte[] molfile = null;
            boolean chiralFlag = false;
            this.readerStatement.setInt(1, id);
            ResultSet rs = this.readerStatement.executeQuery();
            try {
                if (rs.next()) {
                    molfile = DatabaseTools.readBytes(rs, 1);
                    String flags = rs.getString(2);
                    if (flags != null && flags.indexOf(99) != -1) {
                        chiralFlag = true;
                    }
                }
            }
            finally {
                rs.close();
            }
            if (molfile == null) continue;
            result = new MolData();
            result.molString = molfile;
            result.chiralFlag = chiralFlag;
            result.id = id;
            return result;
        }
        return result;
    }

    public Regenerator(ConnectionHandler ch, String tableName, boolean changeStandardization, String standardizerConfig, Map chemTermColCfg, ProgressWriter pw, int threadCount) throws SQLException, RecalculationException {
        this(ch, tableName, changeStandardization, standardizerConfig, chemTermColCfg, null, pw, threadCount, true, 0);
    }

    public Regenerator(ConnectionHandler ch, String tableName, boolean changeStandardization, String standardizerConfig, Map chemTermColCfg, Boolean tautomerDuplicateFiltering, ProgressWriter pw, int threadCount) throws SQLException, RecalculationException {
        this(ch, tableName, changeStandardization, standardizerConfig, chemTermColCfg, tautomerDuplicateFiltering, pw, threadCount, true, 0);
    }

    public Regenerator(ConnectionHandler ch, String tableName, boolean changeStandardization, String standardizerConfig, Map chemTermColCfg, Boolean tautomerDuplicateFiltering, ProgressWriter pw, int threadCount, boolean chemTermCalcNeeded, int regenerationMode) throws SQLException, RecalculationException {
        try {
            this.threadCount = Runtime.getRuntime().availableProcessors();
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        if (this.threadCount > 8) {
            this.threadCount = 8;
        }
        if (new Updater(ch).isUpdateNeededForTable(tableName)) {
            throw new RecalculationException("Table '" + tableName + "' needs an important structural change in the database. " + "Use 'jcman u' in command line, or JCman GUI to upgrade your JChem.");
        }
        this.tableName = tableName;
        this.changeStandardization = changeStandardization;
        this.standardizerConfig = standardizerConfig;
        this.chemTermColCfg = chemTermColCfg;
        this.tautomerDuplicateFiltering = tautomerDuplicateFiltering;
        this.pw = pw;
        this.chemTermCalcNeeded = chemTermCalcNeeded;
        this.regenMode = regenerationMode;
        if (threadCount > 0) {
            this.threadCount = threadCount;
        }
        if (ch.getDriver() == null || ch.getUrl() == null) {
            this.threadCount = 1;
        }
        this.ch = ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws SQLException, PropertyNotSetException {
        int x;
        DatabaseProperties prop = new DatabaseProperties(this.ch);
        if (this.regenMode == 1) {
            PreRegeneration pr = new PreRegeneration(this.ch);
            try {
                pr.removeTempTable(this.tableName);
            }
            catch (Exception e) {
                // empty catch block
            }
            pr.createTempTable(this.tableName, this.chemTermCalcNeeded ? 0 : 2);
            this.tempTableName = PreRegeneration.getTempTableName(this.tableName);
            UpdateHandler.resetPreCalculatedValues(this.ch, this.tableName);
        }
        this.wasError = false;
        Connection con = this.ch.getConnection();
        this.tableName = TableInfo.getTableNameWithSchema(con, this.tableName);
        if (this.pw != null) {
            int rowCount = DBUtil.getRowCount(con, this.tableName);
            this.pw.setMaximum(rowCount);
        } else {
            this.pw = new ProgressWriter("", 0L, 1L);
        }
        if (this.chemTermColCfg != null) {
            TableInfo.saveChemTermColNamesAndExprs(this.ch, new DatabaseProperties(this.ch), this.tableName, this.chemTermColCfg);
        }
        String sql = "SELECT cd_id FROM " + this.tableName;
        if (this.regenMode == 2) {
            sql = sql + " WHERE cd_pre_calculated = 0";
        }
        this.idReaderStmt = con.createStatement();
        this.idResultSet = this.idReaderStmt.executeQuery(sql);
        sql = "SELECT cd_structure, cd_flags FROM " + this.tableName + " WHERE cd_id=?";
        this.readerStatement = con.prepareStatement(sql);
        boolean bl = this.autoCommit = prop.dbmsType == 7 || prop.dbmsType == 2;
        if (this.changeStandardization) {
            prop.setStandardizerConfigOption(this.tableName, this.standardizerConfig);
        }
        if (this.tautomerDuplicateFiltering != null) {
            prop.setTautomerDuplicateFilteringOption(this.tableName, this.tautomerDuplicateFiltering);
        }
        this.connections = new ConnectionHandler[this.threadCount];
        for (x = 0; x < this.threadCount; ++x) {
            this.connections[x] = new ConnectionHandler(this.ch);
            try {
                this.connections[x].connect();
                if (this.autoCommit) continue;
                this.connections[x].getConnection().setAutoCommit(false);
                continue;
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        this.regenThreads = new RegenThread[this.threadCount];
        for (x = 0; x < this.threadCount; ++x) {
            this.regenThreads[x] = new RegenThread(this.connections[x]);
        }
        for (x = 0; x < this.threadCount; ++x) {
            this.regenThreads[x].isRunning = true;
            this.regenThreads[x].start();
        }
        String notePrefix = "Molecule count: ";
        while (true) {
            boolean finished = true;
            for (int x2 = 0; x2 < this.threadCount; ++x2) {
                if (!this.regenThreads[x2].isRunning) continue;
                finished = false;
                break;
            }
            if (finished) break;
            try {
                this.pw.setProgress(this.counter);
                this.pw.setNote(notePrefix + this.counter);
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)e);
            }
        }
        try {
            if (!this.pw.isCanceled()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)TableInfo.stackTraceToString(new Throwable()));
                }
                if (this.regenMode == 0 || this.regenMode == 2) {
                    int version = RegenerationChecker.deduceTableVersion(this.tableName, prop, this.chemTermCalcNeeded ? 0 : 2);
                    prop.setTableProperty(this.tableName, "version", Integer.toString(version));
                    prop.setTableProperty(this.tableName, "JChemVersion", VersionInfo.JCHEM_VERSION);
                    TableInfo.resetTableValidityTimestamp(prop, this.tableName);
                } else if (this.regenMode == 1) {
                    prop.setTableProperty(this.tableName, "preregen.status", "1");
                }
            }
        }
        finally {
            for (int x3 = 1; x3 < this.connections.length; ++x3) {
                this.connections[x3].close();
            }
            this.readerStatement.close();
            this.idReaderStmt.close();
        }
    }

    private class MolData {
        public int id = 0;
        public byte[] molString = null;
        public boolean chiralFlag = false;

        private MolData() {
        }
    }

    private class RegenThread
    extends Thread {
        private ConnectionHandler ch = null;
        private UpdateHandler uh = null;
        private int processed = 0;
        public Throwable error = null;
        public volatile boolean canRun = true;
        public volatile boolean isRunning = false;

        public RegenThread(ConnectionHandler ch) {
            this.ch = ch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block32: {
                try {
                    this.uh = new UpdateHandler(this.ch, 0, Regenerator.this.tableName, "", true, null, null);
                    this.uh.setChemTermCalc(Regenerator.this.chemTermCalcNeeded);
                    this.uh.setEmptyStructuresAllowed(true);
                    this.uh.setIgnoreChemicalTermsExceptions(true);
                    if (Regenerator.this.tempTableName != null) {
                        this.uh.setTempTableToWrite(Regenerator.this.tempTableName);
                        if (new DatabaseProperties((ConnectionHandler)this.ch).dbmsType == 2) {
                            Statement stmt = this.ch.getConnection().createStatement();
                            try {
                                String sql = "SET IDENTITY_INSERT " + Regenerator.this.tempTableName + " ON";
                                stmt.execute(sql);
                            }
                            finally {
                                stmt.close();
                            }
                        }
                    }
                    MolData md = null;
                    int firstId = -1;
                    while (this.canRun && (md = Regenerator.this.getNextMolData()) != null) {
                        if (firstId == -1) {
                            firstId = md.id;
                        } else if (md.id == firstId) break;
                        try {
                            this.uh.setSetChiralFlag(md.chiralFlag);
                            this.uh.setID(md.id);
                            this.uh.setStructure(md.molString);
                            this.uh.execute();
                            if (!Regenerator.this.autoCommit && this.processed++ % 1000 == 0) {
                                this.ch.getConnection().commit();
                            }
                        }
                        catch (Throwable e) {
                            String message = "Error at molecule with cd_id: " + md.id;
                            Regenerator.this.pw.log(0, message, e);
                            Regenerator.this.wasError = true;
                        }
                        ProgressWriter e = Regenerator.this.pw;
                        synchronized (e) {
                            Regenerator.this.counter++;
                        }
                    }
                    if (Regenerator.this.tempTableName == null || new DatabaseProperties((ConnectionHandler)this.ch).dbmsType != 2) break block32;
                    Statement stmt = this.ch.getConnection().createStatement();
                    try {
                        String sql = "SET IDENTITY_INSERT " + Regenerator.this.tempTableName + " OFF";
                        stmt.execute(sql);
                    }
                    finally {
                        stmt.close();
                    }
                }
                catch (Throwable e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)e);
                    }
                    this.error = e;
                    Regenerator.this.wasError = true;
                }
                finally {
                    block33: {
                        try {
                            if (this.uh != null) {
                                this.uh.close();
                            }
                            if (!Regenerator.this.autoCommit) {
                                this.ch.getConnection().commit();
                            }
                        }
                        catch (SQLException e) {
                            if (!log.isErrorEnabled()) break block33;
                            log.error((Object)e);
                        }
                    }
                    this.canRun = false;
                    this.isRunning = false;
                }
            }
        }
    }
}

