/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.common.util.Base64Util;
import chemaxon.common.util.IntVector;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.FieldInfo;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.file.FieldData;
import chemaxon.jchem.file.JTFExporter;
import chemaxon.jchem.file.MolRecord;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.formats.MoleculeImporter;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;

public class SQLToFileHandler {
    private static final Logger logger = Logger.getLogger(SQLToFileHandler.class.getName());
    private static final byte[] EMPTY_MOLBYTES = "\n  Empty strycture\n\n  0  0  0  0  0  0            999 V2000\nM  END".getBytes();
    private ResultSet rs;
    private Statement stmt;
    private JTFExporter jtfExporter;
    private MolExporter exporter = null;
    private TableInfo tableInfo;
    private String lineSeparator;
    private Connection con;
    private String tableName;
    private int format;
    private String customSelect = null;
    private String[] outputFieldNames = null;
    private Map<String, String> outputFieldConversion = null;
    private String conditions = "";
    private boolean batchMode = false;
    private IntVector idsToExport = null;
    private String sql = null;
    private static final int BATCH_SIZE = 500;
    private int pos = 0;
    private OutputStream os;
    private int tableType;

    public SQLToFileHandler(ConnectionHandler conh, String tableName, OutputStream os, TableInfo tableInfo, int format2, String conditions, String eol) throws SQLException, MolExportException, IOException {
        this(conh, tableName, os, tableInfo, format2, conditions, eol, "\t", "\"", true, null, null, null, null);
    }

    public SQLToFileHandler(ConnectionHandler conh, String tableName, OutputStream os, TableInfo tableInfo, int format2, String conditions, String eol, String delimiter, String quotation, boolean jtfWithStructure, int[] idList, String customSelect, String[] outputFieldNames, Map<String, String> outputFieldConversion) throws SQLException, MolExportException, IOException {
        this.conditions = conditions;
        this.con = conh.getConnection();
        this.tableName = tableName;
        this.tableInfo = tableInfo;
        this.customSelect = customSelect;
        this.outputFieldNames = outputFieldNames;
        this.outputFieldConversion = outputFieldConversion;
        this.lineSeparator = eol;
        if (format2 == 4) {
            this.jtfExporter = new JTFExporter(os, eol, delimiter, quotation, jtfWithStructure);
        }
        DatabaseProperties dbProp = new DatabaseProperties(conh, false);
        this.tableType = dbProp.getTableType(tableName);
        this.os = os;
        this.format = format2;
        this.batchMode = false;
        this.stmt = this.con.createStatement();
        if (conditions == "" && idList != null) {
            Arrays.sort(idList);
            this.idsToExport = new IntVector(idList);
            this.batchMode = true;
        } else {
            if (customSelect == null) {
                StringBuffer sb = new StringBuffer("SELECT ");
                boolean bl = this.batchMode = idList != null || DatabaseOptions.getDBMSType(this.con) == 3;
                if (!this.batchMode) {
                    for (int i = 0; i < tableInfo.size(); ++i) {
                        FieldInfo field = tableInfo.fieldAt(i);
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(tableName + ".");
                        sb.append(field.getName());
                    }
                } else {
                    sb.append(tableName + ".");
                    sb.append("CD_ID");
                }
                sb.append("\nFROM " + tableName);
                sb.append("\n" + conditions);
                if (!this.batchMode) {
                    sb.append("\nORDER BY CD_ID");
                }
                this.sql = sb.toString();
            } else {
                this.sql = customSelect;
            }
            int dbms = DatabaseOptions.getDBMSType(this.con);
            if (customSelect != null && dbms == 3) {
                this.stmt.setFetchSize(Integer.MIN_VALUE);
            }
            DatabaseOptions.setFetchSize(this.stmt, 1000, dbms);
            if (this.batchMode) {
                this.idsToExport = new IntVector();
                if (idList != null) {
                    Arrays.sort(idList);
                }
                this.rs = this.stmt.executeQuery(this.sql);
                while (this.rs.next()) {
                    int id = this.rs.getInt(1);
                    if (idList != null && Arrays.binarySearch(idList, id) < 0) continue;
                    this.idsToExport.addElement(id);
                }
                this.rs.close();
                this.rs = null;
                this.idsToExport.sort();
            }
        }
    }

    private MolRecord dbRowToRecord(ResultSet rs) throws IOException, NumberFormatException, SQLException, MolFormatException, UnsupportedEncodingException {
        MolRecord mRec = new MolRecord("");
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        for (int columnIndex = 1; columnIndex <= cols; ++columnIndex) {
            String name = rsmd.getColumnName(columnIndex);
            String lname = name.toLowerCase();
            FieldInfo fieldInfo = null;
            if (this.customSelect == null) {
                fieldInfo = this.tableInfo.getFieldByName(name);
            }
            if (this.customSelect != null && columnIndex == 1 || lname.equals("cd_structure")) {
                byte[] bytes = DatabaseTools.readBytes(rs, columnIndex);
                String molfile = null;
                try {
                    molfile = Base64Util.encode(bytes, false);
                }
                catch (IOException e) {
                    throw new MolFormatException("Could not export to jtf format.", e);
                }
                mRec.setMolfile(molfile);
                continue;
            }
            if (this.customSelect == null && !fieldInfo.isConnected()) continue;
            mRec.addField(this.getProperty(lname, name, fieldInfo, rs, columnIndex));
        }
        return mRec;
    }

    private void writeDBRow(ResultSet rs) throws IOException, NumberFormatException, SQLException, MolFormatException, UnsupportedEncodingException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        MoleculeGraph mol = null;
        String formatString = null;
        ArrayList<FieldData> properties = null;
        for (int columnIndex = 1; columnIndex <= cols; ++columnIndex) {
            FieldData property;
            String name = rsmd.getColumnName(columnIndex);
            String lname = name.toLowerCase();
            FieldInfo fieldInfo = null;
            if (this.customSelect == null) {
                fieldInfo = this.tableInfo.getFieldByName(name);
            }
            if (this.customSelect != null && columnIndex == 1 || lname.equals("cd_structure")) {
                byte[] bytes = DatabaseTools.readBytes(rs, columnIndex);
                if (bytes == null) {
                    logger.severe("null structure bytes read from database");
                    continue;
                }
                formatString = SQLToFileHandler.getFormatString(bytes, this.tableType);
                if (formatString == null) {
                    bytes = EMPTY_MOLBYTES;
                    formatString = "mol";
                }
                MoleculeImporter importer = new MoleculeImporter(new ByteArrayInputStream(bytes), formatString);
                mol = importer.read();
                importer.close();
                if (mol == null) {
                    logger.severe("null mol structure read from database");
                    continue;
                }
                SQLToFileHandler.checkReaction(this.format, (Molecule)mol);
                ((Molecule)mol).clearProperties();
                continue;
            }
            if (this.customSelect == null && !fieldInfo.isConnected() || (property = this.getProperty(lname, name, fieldInfo, rs, columnIndex)).getValue() == null) continue;
            if (properties == null) {
                properties = new ArrayList<FieldData>();
            }
            properties.add(property);
        }
        if (properties != null) {
            for (FieldData prop : properties) {
                ((Molecule)mol).setProperty(prop.getName(), prop.getValue());
            }
        }
        if (this.exporter == null) {
            String[] fieldNames = properties != null ? mol.properties().getKeys() : null;
            String outputFormat = SQLToFileHandler.getOutputFormat(this.format);
            this.exporter = new MolExporter(this.os, outputFormat, false, fieldNames, null);
            this.exporter.setClean(2, null, MolExporter.FILTER_DIM0);
        }
        this.exporter.write((Molecule)mol);
    }

    private FieldData getProperty(String lname, String name, FieldInfo fieldInfo, ResultSet rs, int columnIndex) throws IOException, SQLException {
        Clob c;
        String value = null;
        value = fieldInfo != null && fieldInfo.getType() == 2005 ? ((c = rs.getClob(columnIndex)) == null ? null : c.getSubString(1L, (int)c.length())) : rs.getString(columnIndex);
        String fname = null;
        fname = this.customSelect == null ? (fieldInfo.isFingerprint() ? fieldInfo.getName() : fieldInfo.getOtherName()) : (this.outputFieldNames != null && this.outputFieldNames.length > columnIndex - 2 ? this.outputFieldNames[columnIndex - 2] : name);
        if (this.outputFieldConversion != null && this.outputFieldConversion.containsKey(lname)) {
            fname = this.outputFieldConversion.get(lname);
        }
        return new FieldData(fname, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFormatString(byte[] bytes, int tableType) {
        BufferedInputStream mis = null;
        String fmt = null;
        try {
            mis = new MolInputStream(new ByteArrayInputStream(bytes));
            fmt = ((MolInputStream)mis).getFormat();
        }
        catch (IOException e) {
            logger.severe("An error occured when trying to readthe following molecule from the database table:\n\n" + new String(bytes));
            logger.throwing("SQLToFileHandler", "dbRowToMol", e);
            String string = null;
            return string;
        }
        finally {
            if (mis != null) {
                try {
                    mis.close();
                }
                catch (IOException e) {}
            }
        }
        if (tableType == 4) {
            fmt = fmt.replaceFirst("smiles", "smarts");
        }
        return fmt;
    }

    private static String getOutputFormat(int format2) {
        switch (format2) {
            case 1: {
                return "mol";
            }
            case 2: {
                return "sdf";
            }
            case 7: {
                return "rxn";
            }
            case 5: {
                return "rdf";
            }
            case 6: {
                return "mrv";
            }
            case 9: {
                return "inchi";
            }
            case 8: {
                return "mol2";
            }
            case 3: {
                return "smiles";
            }
            case 12: {
                return "cxsmiles";
            }
            case 11: {
                return "smarts";
            }
            case 13: {
                return "cxsmarts";
            }
        }
        throw new IllegalArgumentException("getOutputFormat() is not implemented for this format: " + format2);
    }

    private static void checkReaction(int format2, Molecule mol) throws MolFormatException {
        switch (format2) {
            case 1: 
            case 2: 
            case 8: {
                if (!mol.isReaction()) break;
                throw new MolFormatException("Cannot export reaction to mol / mol2 / sdf format. Please try to export into rxn or rdf format.");
            }
            case 9: {
                if (!mol.isReaction()) break;
                throw new MolFormatException("Cannot export reaction to InChI format. Please try to export into smiles or cxsmiles format.");
            }
            case 5: 
            case 7: {
                if (mol.isReaction()) break;
                throw new MolFormatException("Cannot export structure to rxn / rdf format, not a reaction.");
            }
        }
    }

    public boolean writeNext() throws IOException, NumberFormatException, SQLException, MolFormatException {
        if (!this.batchMode) {
            if (this.rs == null) {
                this.rs = this.stmt.executeQuery(this.sql);
            }
            if (!this.rs.next()) {
                return false;
            }
        } else {
            boolean newRSNeeded;
            if (this.idsToExport.size() == 0) {
                return false;
            }
            boolean couldRead = false;
            if (this.rs != null) {
                couldRead = this.rs.next();
            }
            boolean bl = newRSNeeded = this.rs == null || !couldRead && this.pos < this.idsToExport.size();
            if (!couldRead && !newRSNeeded) {
                return false;
            }
            if (newRSNeeded) {
                if (this.rs != null) {
                    this.rs.close();
                }
                StringBuffer sb = new StringBuffer("SELECT ");
                for (int i = 0; i < this.tableInfo.size(); ++i) {
                    FieldInfo field = this.tableInfo.fieldAt(i);
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.tableName + ".");
                    sb.append(field.getName());
                }
                sb.append("\nFROM " + this.tableName);
                sb.append("\nWHERE CD_ID IN(");
                int size = this.idsToExport.size();
                for (int x = 0; x < 500 && this.pos < size; ++x) {
                    if (x > 0) {
                        sb.append(",");
                    }
                    sb.append(this.idsToExport.elementAt(this.pos++));
                }
                sb.append(")");
                sb.append(" ORDER BY CD_ID");
                this.rs = this.stmt.executeQuery(sb.toString());
                if (!this.rs.next()) {
                    return false;
                }
            }
        }
        if (this.format == 4) {
            this.jtfExporter.write(this.dbRowToRecord(this.rs));
        } else {
            this.writeDBRow(this.rs);
        }
        return true;
    }

    public void close() throws IOException, SQLException {
        if (this.jtfExporter != null) {
            this.jtfExporter.close();
        }
        if (this.exporter != null) {
            this.exporter.close();
        }
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    public int getResultSize() {
        try {
            if (!this.rs.last()) {
                return 0;
            }
            int size = this.rs.getRow();
            this.rs.beforeFirst();
            return size;
        }
        catch (SQLException ex) {
            System.out.println("SQL error: " + ex);
            return 0;
        }
    }
}

