/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.common.util.IntVector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScreenedHandler {
    private static final Logger logger = Logger.getLogger(ScreenedHandler.class.getName());
    private IntVector uniqueScreened = new IntVector();
    private int totalScreenedCount = 0;
    private int latestScreenedCount = 0;
    private boolean valid = false;

    ScreenedHandler() {
    }

    void incTotalScreenedCount(int i) {
        this.totalScreenedCount += i;
    }

    void addUniqueScreened(IntVector newScreenedVector) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("newScreenedVector=" + newScreenedVector + ", uniqueScreened=" + this.uniqueScreened);
        }
        this.latestScreenedCount = newScreenedVector.size();
        this.totalScreenedCount += this.latestScreenedCount;
        if (this.uniqueScreened.size() == 0) {
            this.uniqueScreened.addAll(newScreenedVector);
            this.uniqueScreened.sort();
        } else {
            int size = newScreenedVector.size();
            IntVector helper = new IntVector(size);
            for (int i = 0; i < size; ++i) {
                int element = newScreenedVector.get(i);
                if (this.uniqueScreened.indexOfWithBinarySearch(element) != -1) continue;
                helper.add(element);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("helper=" + helper);
            }
            this.uniqueScreened.addAll(helper);
            this.uniqueScreened.sort();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("uniqueScreened" + this.uniqueScreened);
        }
    }

    IntVector getUniqueScreened() {
        if (this.valid) {
            return this.uniqueScreened;
        }
        return null;
    }

    int getLatestScreenedCount() {
        if (this.valid) {
            return this.latestScreenedCount;
        }
        return -1;
    }

    int getUniqueScreenedCount() {
        if (this.valid) {
            return this.uniqueScreened.size();
        }
        return -1;
    }

    int getTotalScreenedCount() {
        if (this.valid) {
            return this.totalScreenedCount;
        }
        return -1;
    }

    void setValid(boolean value) {
        this.valid = value;
    }

    boolean isValid() {
        return this.valid;
    }
}

