/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.common.util.IntVector;
import java.util.concurrent.ArrayBlockingQueue;

class ScreenedQueueHandler {
    private ArrayBlockingQueue<int[]> screenedQueue;
    private int candidatesSize;
    private int packageSize;
    private int threadNo;
    private int[] poison = new int[0];
    private boolean closed = false;
    private int packLimit;
    private int packSizeCounter = 0;
    private boolean firstPhase = true;
    int[] screenedPack;
    private IntVector screenedIDs;

    ScreenedQueueHandler(int threadNo, int screenCandidatesSize, int packageSize) {
        this.candidatesSize = screenCandidatesSize;
        this.threadNo = threadNo;
        this.packageSize = packageSize;
        this.init();
    }

    private void init() {
        this.screenedQueue = new ArrayBlockingQueue(this.candidatesSize / this.packageSize + 1 + 1 + this.threadNo);
        this.screenedIDs = new IntVector(this.packageSize);
        this.packLimit = 2 * this.packageSize;
        this.screenedPack = new int[this.packLimit];
    }

    void put(IntVector id, IntVector index, boolean checkDuplicates) {
        int size = this.getSize(id, index);
        for (int i = 0; i < size; ++i) {
            this.put(id.get(i), index.get(i), checkDuplicates);
        }
    }

    private int getSize(IntVector id, IntVector index) {
        int size = id.size();
        if (size != index.size()) {
            throw new IllegalArgumentException("ID vector and index vector has different size.");
        }
        return size;
    }

    void put(int id, int index, boolean checkDuplicates) {
        if (this.closed) {
            throw new IllegalStateException("Screened queue is already closed!");
        }
        if (checkDuplicates && this.screenedIDs.contains(id)) {
            return;
        }
        if (this.firstPhase) {
            this.screenedQueue.add(new int[]{id, index});
            if (1 < this.packageSize) {
                this.firstPhase = false;
                this.packSizeCounter = 0;
            }
        } else {
            this.screenedPack[this.packSizeCounter++] = id;
            this.screenedPack[this.packSizeCounter++] = index;
            if (this.packSizeCounter == this.packLimit) {
                this.screenedQueue.add(this.screenedPack);
                this.screenedPack = new int[this.packLimit];
                this.packSizeCounter = 0;
            }
        }
        this.screenedIDs.add(id);
    }

    void close() {
        if (!this.closed) {
            this.flush();
            for (int i = 0; i < this.threadNo; ++i) {
                this.screenedQueue.add(this.poison);
            }
            this.candidatesSize = 0;
            this.closed = true;
        }
    }

    void flush() {
        if (this.packSizeCounter > 0) {
            int[] last = new int[this.packSizeCounter];
            System.arraycopy(this.screenedPack, 0, last, 0, this.packSizeCounter);
            this.screenedQueue.add(last);
            this.screenedPack = new int[this.packLimit];
            this.packSizeCounter = 0;
        }
    }

    int getScreenedCount() {
        return this.screenedIDs.size();
    }

    IntVector getScreenedIDs() {
        return this.screenedIDs;
    }

    ArrayBlockingQueue<int[]> getScreenedQueue() {
        return this.screenedQueue;
    }

    int[] getPoison() {
        return this.poison;
    }
}

