/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SettingsHandler {
    private final String settingsPath;
    private Properties settings;
    private final String fileSep = System.getProperty("file.separator");

    public SettingsHandler() throws IOException {
        this(new Properties());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SettingsHandler(Properties defaultSettings) throws IOException {
        File file;
        File dir;
        String chemDir = DotfileUtil.getDotDir().getAbsolutePath();
        if (chemDir.endsWith(this.fileSep)) {
            chemDir = chemDir.substring(0, chemDir.length() - 1);
        }
        if (!(dir = new File(chemDir)).exists()) {
            dir.mkdir();
        }
        this.settingsPath = chemDir + this.fileSep + ".jchem";
        if (!new File(this.settingsPath).exists()) {
            File old = new File(chemDir).getParentFile();
            if ((old = new File(old, ".jchem")).exists()) {
                old.renameTo(new File(chemDir, ".jchem"));
            }
        }
        if ((file = new File(this.settingsPath)).exists()) {
            FileInputStream input;
            block12: {
                input = null;
                try {
                    input = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError();
                }
            }
            try {
                this.settings = new Properties();
                this.settings.load(input);
                if (this.settings.getProperty("connection.propertyTable") != null) return;
                this.settings.put("connection.propertyTable", "JChemProperties");
                this.save();
                return;
            }
            catch (IOException e) {
                System.err.println("Warning: settings could not be loaded. " + e.getMessage());
                throw e;
            }
            finally {
                ((InputStream)input).close();
            }
        }
        this.settings = (Properties)defaultSettings.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        try {
            FileOutputStream out = new FileOutputStream(new File(this.settingsPath));
            try {
                this.settings.store(out, "Settings of the ChemDB system");
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            System.err.println("Warning: settings could not be saved. " + e.getMessage());
            throw e;
        }
    }

    public void save(Properties settings) throws IOException {
        this.settings = settings;
        this.save();
    }

    public void close() throws IOException {
        this.save();
    }

    public Properties getSettings() {
        return this.settings;
    }
}

