/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.formats.MolFormatException;
import chemaxon.jchem.db.DBUtil;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.FieldInfo;
import chemaxon.jchem.db.FingerprintHandler;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.jchem.db.MarkushTableInfo;
import chemaxon.jchem.db.RegenerationChecker;
import chemaxon.jchem.db.StructureTableOptions;
import chemaxon.jchem.db.TableNames;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.db.sql.TypeConverter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.MolContext;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.MolHandler;
import chemaxon.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TableInfo
implements Licensable {
    private static final Logger logger = Logger.getLogger(TableInfo.class.getName());
    private static String licenseEnvironment = "";
    public static final int IMPORT = 0;
    public static final int EXPORT = 1;
    public static final int DELETE = 2;
    public static final int REGENERATE = 3;
    public static final int OPTIONS = 4;
    private static final int DEFAULT_SMILES_LENGTH = 1000;
    private static final int DEFAULT_ORACLE_SMILES_LENGTH = 4000;
    public static final int MAX_SUFFIX_LENGTH = 4;
    public static final int MAX_ORACLE_NAME_LENGTH = 30;
    public static final int MIN_DESCRIPTOR_NAME_LENGTH = 1;
    public static final int UPDATE_INFO_LENGTH = 120;
    public static final String EMPTY_STRUCTURE_AS_STRING = "\n  Empty structure\n\n  0  0  0  0  0  0            999 V2000\nM  END";
    public static final byte[] EMPTY_STRUCTURE_AS_BYTES = "\n  Empty structure\n\n  0  0  0  0  0  0            999 V2000\nM  END".getBytes();
    FieldInfo idField = null;
    FieldInfo structureField = null;
    FieldInfo smilesField = null;
    FieldInfo formulaField = null;
    FieldInfo sortableFormulaField = null;
    FieldInfo molWeightField = null;
    FieldInfo hashField = null;
    FieldInfo flagsField = null;
    FieldInfo dateField = null;
    int counter = 0;
    Vector<FieldInfo> vector = new Vector(10);
    String tableName;
    Properties settings;
    Connection con;
    public static final String DEFAULT_STANDARDIZER_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<StandardizerConfiguration Version =\"1.0\">\n\t<Actions>\n\t\t<Aromatize ID=\"aromatize\" Type=\"general\"/>\n\t\t<RemoveExplicitH ID=\"removeexplicith\"/>\n\t</Actions>\n</StandardizerConfiguration>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableInfo(String tableName, Properties settings, ConnectionHandler conh) throws SQLException {
        this.tableName = tableName;
        this.settings = settings;
        this.con = conh.getConnection();
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE 1=2");
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                DatabaseProperties dbProps = new DatabaseProperties(conh);
                String[] ctBasedColNames = dbProps.getChemTermColumns(tableName);
                List<String> ctBasedColNameList = Arrays.asList(ctBasedColNames);
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String name = rsmd.getColumnName(i).toUpperCase();
                    int type = rsmd.getColumnType(i);
                    String typeName = rsmd.getColumnTypeName(i);
                    FieldInfo fi = new FieldInfo(name, type, typeName);
                    this.addElement(fi);
                    if (!ctBasedColNameList.contains(name)) continue;
                    fi.setChemTermBased(true);
                    String chemTermExpr = dbProps.getChemTermForColumn(tableName, name);
                    fi.setOtherName(chemTermExpr);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Markush Search", licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        licenseEnvironment = env;
    }

    private static void checkLicense() {
        LicenseHandler.getInstance().checkLicense("Markush Search", licenseEnvironment);
    }

    public final void addElement(FieldInfo fieldInfo) {
        this.vector.addElement(fieldInfo);
        this.checkFixFields(fieldInfo);
    }

    public void autoConnectFieldsForImport(Vector<String> fileFields, Properties settings) {
        this.connectFieldsForImport(fileFields, settings, true);
    }

    public void connectFieldsForImport(Vector<String> fileFields, Properties settings, boolean makePairsByName) {
        Enumeration<FieldInfo> eTable = this.elements();
        block0: while (eTable.hasMoreElements()) {
            String fromSettings;
            FieldInfo fieldInfo = eTable.nextElement();
            if (fieldInfo.isChemTermBased()) continue;
            String capTableField = fieldInfo.getName().toUpperCase();
            fieldInfo.setOtherName("[Not connected]");
            if (fieldInfo == this.getStructureField()) {
                fieldInfo.setOtherName("[Structure]");
                continue;
            }
            if (fieldInfo == this.getSmilesField()) {
                fieldInfo.setOtherName("[Smiles]");
                continue;
            }
            if (fieldInfo == this.getFormulaField()) {
                fieldInfo.setOtherName("[Formula]");
                continue;
            }
            if (fieldInfo == this.getSortableFormulaField()) {
                fieldInfo.setOtherName("[Sortable formula]");
                continue;
            }
            if (fieldInfo == this.getMolWeightField()) {
                fieldInfo.setOtherName("[Molweight]");
                continue;
            }
            if (fieldInfo.isFingerprint()) {
                fieldInfo.setOtherName("[Fingerprint]");
                continue;
            }
            if (fieldInfo.isHash()) {
                fieldInfo.setOtherName("[Hash code]");
                continue;
            }
            if (fieldInfo.isFlags()) {
                fieldInfo.setOtherName("[Flags]");
                continue;
            }
            if (fieldInfo.isDate()) {
                fieldInfo.setOtherName("[Timestamp]");
                continue;
            }
            if (fieldInfo.isPrecalculated()) {
                fieldInfo.setOtherName("[Is precalculated]");
                continue;
            }
            boolean lookForPairs = makePairsByName;
            if (fieldInfo == this.getIdField()) {
                fieldInfo.setOtherName("[Auto incrementing]");
                lookForPairs = false;
            }
            if ((fromSettings = settings.getProperty("import.ConnectFields.Field." + fieldInfo.getName())) != null && fileFields.contains(fromSettings)) {
                fieldInfo.setOtherName(fromSettings);
                continue;
            }
            if (!lookForPairs) continue;
            Enumeration<String> eFile = fileFields.elements();
            while (eFile.hasMoreElements()) {
                String fileField = eFile.nextElement();
                String capFileField = fileField.toUpperCase();
                if (!capTableField.equals(capFileField)) continue;
                fieldInfo.setOtherName(fileField);
                continue block0;
            }
        }
    }

    public void autoConnectFieldsForExport() {
        Enumeration<FieldInfo> eTable = this.elements();
        while (eTable.hasMoreElements()) {
            FieldInfo fieldInfo = eTable.nextElement();
            if (fieldInfo.isStructure()) {
                fieldInfo.setOtherName("[Structure]");
                continue;
            }
            if (fieldInfo.isFingerprint()) {
                fieldInfo.setOtherName("[Fingerprint]");
                continue;
            }
            fieldInfo.setOtherName(fieldInfo.getName());
        }
    }

    public void selectFields(ArrayList flist) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        Enumeration<FieldInfo> fenum = this.elements();
        while (fenum.hasMoreElements()) {
            FieldInfo fi = fenum.nextElement();
            fields.add(fi);
        }
        this.clear();
        for (int x = 0; x < fields.size(); ++x) {
            FieldInfo fi = (FieldInfo)fields.get(x);
            String fieldName = fi.getName().toUpperCase();
            boolean needed = false;
            for (int y = 0; y < flist.size(); ++y) {
                String selectedName = flist.get(y).toString().toUpperCase();
                if (!selectedName.equals(fieldName)) continue;
                needed = true;
                break;
            }
            if ("CD_STRUCTURE".equals(fieldName)) {
                needed = true;
            }
            if (!needed) continue;
            this.addElement(fi);
        }
    }

    public void selectFields(String fieldList) {
        ArrayList<String> flist = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(fieldList);
        while (st.hasMoreTokens()) {
            flist.add(st.nextToken());
        }
        this.selectFields(flist);
    }

    public void selectDefaults(int format2) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        Enumeration<FieldInfo> fenum = this.elements();
        while (fenum.hasMoreElements()) {
            FieldInfo fi = fenum.nextElement();
            fields.add(fi);
        }
        this.clear();
        for (int x = 0; x < fields.size(); ++x) {
            FieldInfo fi = (FieldInfo)fields.get(x);
            String name = fi.getName();
            if ((name = name.toLowerCase()).startsWith("cd_") && !fi.isId() && !fi.isStructure() || (format2 == 3 || format2 == 11) && !fi.isStructure()) continue;
            this.addElement(fi);
        }
    }

    public void checkFixFields(FieldInfo fieldInfo) {
        if (fieldInfo.isId()) {
            this.idField = fieldInfo;
        } else if (fieldInfo.isStructure()) {
            this.structureField = fieldInfo;
        } else if (fieldInfo.isSmiles()) {
            this.smilesField = fieldInfo;
        } else if (fieldInfo.isFormula()) {
            this.formulaField = fieldInfo;
        } else if (fieldInfo.isSortableFormula()) {
            this.sortableFormulaField = fieldInfo;
        } else if (fieldInfo.isMolWeight()) {
            this.molWeightField = fieldInfo;
        } else if (fieldInfo.isHash()) {
            this.hashField = fieldInfo;
        } else if (fieldInfo.isFlags()) {
            this.flagsField = fieldInfo;
        } else if (fieldInfo.isDate()) {
            this.dateField = fieldInfo;
        }
    }

    public void clearValues() {
        ++this.counter;
        Enumeration<FieldInfo> eTable = this.elements();
        while (eTable.hasMoreElements()) {
            FieldInfo fieldInfo = eTable.nextElement();
            fieldInfo.setValue(null);
        }
    }

    public Enumeration<FieldInfo> elements() {
        return this.vector.elements();
    }

    public FieldInfo fieldAt(int index) {
        return this.vector.elementAt(index);
    }

    public FieldInfo getFieldByName(String name) {
        Enumeration<FieldInfo> e = this.vector.elements();
        while (e.hasMoreElements()) {
            FieldInfo fieldInfo = e.nextElement();
            if (!fieldInfo.getName().equalsIgnoreCase(name)) continue;
            return fieldInfo;
        }
        return null;
    }

    public FieldInfo getFieldByOtherName(String name) {
        FieldInfo fieldInfo = null;
        Enumeration<FieldInfo> e = this.elements();
        while (e.hasMoreElements() && !(fieldInfo = e.nextElement()).getOtherName().equals(name)) {
        }
        return fieldInfo;
    }

    public String removeMolNameField() {
        int i = 0;
        Enumeration<FieldInfo> e = this.vector.elements();
        while (e.hasMoreElements()) {
            FieldInfo fieldInfo = e.nextElement();
            if (fieldInfo.isMolName()) {
                this.vector.remove(i);
                return fieldInfo.getName();
            }
            ++i;
        }
        return null;
    }

    public final synchronized void insertElementAt(FieldInfo fieldInfo, int index) {
        this.vector.insertElementAt(fieldInfo, index);
        this.checkFixFields(fieldInfo);
    }

    public void save(Properties settings) {
        Enumeration<FieldInfo> eTable = this.elements();
        while (eTable.hasMoreElements()) {
            FieldInfo fieldInfo = eTable.nextElement();
            if (fieldInfo.isStructure() || fieldInfo.isFingerprint()) continue;
            settings.put("import.ConnectFields.Field." + fieldInfo.getName(), fieldInfo.getOtherName());
        }
    }

    public int size() {
        return this.vector.size();
    }

    public void clear() {
        this.vector.clear();
    }

    public FieldInfo getIdField() {
        return this.idField;
    }

    public FieldInfo getStructureField() {
        return this.structureField;
    }

    public FieldInfo getSmilesField() {
        return this.smilesField;
    }

    public FieldInfo getFormulaField() {
        return this.formulaField;
    }

    public FieldInfo getSortableFormulaField() {
        return this.sortableFormulaField;
    }

    public FieldInfo getMolWeightField() {
        return this.molWeightField;
    }

    public FieldInfo getHashField() {
        return this.hashField;
    }

    public FieldInfo getFlagsField() {
        return this.flagsField;
    }

    public FieldInfo getDateField() {
        return this.dateField;
    }

    public static TableInfo getTableInfo(ConnectionHandler conh, Properties settings, String table) throws SQLException {
        return new TableInfo(table, settings, conh);
    }

    public static boolean isAbsoluteStereo(ConnectionHandler conh, String table) throws SQLException {
        return TableInfo.isAbsoluteStereo(conh, table, false);
    }

    public static boolean isAbsoluteStereo(ConnectionHandler conh, String table, boolean indexTable) throws SQLException {
        DatabaseProperties dbProp = new DatabaseProperties(conh, indexTable);
        String value = dbProp.getTableProperty(table, "absoluteStereo");
        return value == null || value.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTableEmpty2(Connection con, String tableName, String funcName) throws SQLException {
        boolean isEmpty;
        block10: {
            isEmpty = true;
            Statement stmt = con.createStatement();
            String s = "SELECT " + funcName + "(" + "cd_id" + ") FROM " + tableName;
            try {
                ResultSet rs = stmt.executeQuery(s);
                try {
                    Object x;
                    boolean b = rs.next();
                    if (!b || (x = rs.getObject(1)) == null) break block10;
                    try {
                        if (Integer.parseInt(x.toString()) > 0) {
                            isEmpty = false;
                        }
                    }
                    catch (NumberFormatException exx) {
                        if (Float.valueOf(x.toString()).floatValue() > 0.0f) {
                            isEmpty = false;
                        }
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        return isEmpty;
    }

    public static boolean isTableEmpty(Connection con, String tableName) throws SQLException {
        return TableInfo.isTableEmpty2(con, tableName, "MAX");
    }

    public static String getAutoIncrementIntDefinition(int dbmsType, DatabaseOptions dbOptions, TypeConverter tc, String tableName) {
        boolean constraintNeeded;
        StringBuffer sb = new StringBuffer();
        String idType = null;
        idType = dbmsType == 7 ? "serial" : tc.getLocalTypeByCode(4);
        sb.append(idType + " ");
        if (dbOptions.isAutoIncrementProperty && !dbOptions.isAutoIncrementByTrigger && dbmsType != 7) {
            sb.append(dbOptions.autoIncrementPropertyName + " ");
        }
        if (constraintNeeded = dbOptions.constraintNeededForPrimaryKey) {
            sb.append("CONSTRAINT Costraint_" + tableName + "_PK ");
        }
        sb.append(" NOT NULL ");
        sb.append("PRIMARY KEY");
        return sb.toString();
    }

    public static void createCacheRegistrationTable(ConnectionHandler conh, String registrationTableName) throws SQLException {
        Connection con = conh.getConnection();
        TypeConverter tc = new TypeConverter(con);
        int dbmsType = DatabaseOptions.getDBMSType(con);
        StringBuffer sb = new StringBuffer("CREATE ");
        if (dbmsType == 8) {
            sb.append("CACHED ");
        }
        Random randomNumGenerator = new Random();
        String pkName = "cache_" + Math.abs(randomNumGenerator.nextInt()) + "_pk";
        sb.append("TABLE ").append(registrationTableName).append(" (\n");
        sb.append("cache_id").append(" ").append(tc.getLocalTypeByCode(12));
        sb.append("(").append(32).append(") NOT NULL,\n");
        sb.append("registration_time").append(" ").append(tc.getLocalTypeByCode(12));
        sb.append("(30) NOT NULL,\n");
        sb.append("is_protected").append(" ").append(tc.getLocalTypeByCode(-7));
        if (dbmsType != 4) {
            sb.append(" DEFAULT 0");
        }
        sb.append(" NOT NULL,\n");
        sb.append(" CONSTRAINT ").append(pkName).append(" PRIMARY KEY (cache_id))\n");
        if (dbmsType == 3) {
            sb.append(" ENGINE=INNODB;");
        }
        TableInfo.executeSql(con, sb.toString());
    }

    public static void createCacheRegistrationTableWithProperty(ConnectionHandler conh) throws SQLException {
        DatabaseProperties dbProp = new DatabaseProperties(conh);
        String regTableName = dbProp.getCacheRegistrationTableName();
        if (regTableName == null) {
            regTableName = dbProp.setCacheRegistrationTableName();
        }
        if (!TableInfo.isTableExists(conh, regTableName)) {
            TableInfo.createCacheRegistrationTable(conh, regTableName);
        }
    }

    public static String createCreateTableStatement(ConnectionHandler conh, StructureTableOptions options, DatabaseOptions dbOptions) throws SQLException {
        Connection con = conh.getConnection();
        TypeConverter tc = new TypeConverter(con);
        int dbmsType = DatabaseOptions.getDBMSType(con);
        int sortableFormulaLength = 255;
        if (dbmsType == 1) {
            sortableFormulaLength = 500;
        }
        StringBuffer sb = new StringBuffer("CREATE ");
        if (dbmsType == 8) {
            sb.append("CACHED ");
        }
        sb.append("TABLE " + options.name + "(\n");
        sb.append("\tcd_id ");
        sb.append(TableInfo.getAutoIncrementIntDefinition(dbmsType, dbOptions, tc, options.name));
        sb.append(",\n");
        int structureColumnType = options.structureColumnType;
        if (structureColumnType == 0) {
            structureColumnType = dbmsType == 1 ? 2004 : -4;
        }
        if (structureColumnType != 2004 && structureColumnType != 2005 && structureColumnType != -4) {
            throw new IllegalArgumentException("Unsupported SQL type: " + structureColumnType);
        }
        String size = "";
        if (dbmsType == 6) {
            size = "(1M)";
        }
        String type = tc.getLocalTypeByCode(structureColumnType);
        sb.append("\tcd_structure " + type + size + " NOT NULL,\n");
        if (options.tableType == 3) {
            type = tc.getLocalTypeByCode(2004);
            sb.append("\tcd_markush " + type + ",\n");
        }
        if (options.tableType == 4) {
            type = tc.getLocalTypeByCode(2004);
            sb.append("\tcd_smarts " + type + ",\n");
        } else {
            if (dbmsType == 3) {
                sb.append("\tcd_smiles TEXT");
            } else if (dbmsType == 4) {
                sb.append("\tcd_smiles MEMO");
            } else {
                sb.append("\tcd_smiles " + tc.getLocalTypeByCode(12));
                if (dbmsType == 1) {
                    sb.append("(4000)");
                } else {
                    sb.append("(1000)");
                }
            }
            sb.append(",\n");
        }
        sb.append("\tcd_formula " + tc.getLocalTypeByCode(12) + "(" + 100 + ")");
        sb.append(",\n");
        sb.append("\tcd_sortable_formula " + tc.getLocalTypeByCode(12) + "(" + sortableFormulaLength + ")");
        sb.append(",\n");
        sb.append("\tcd_molweight " + tc.getLocalTypeByCode(8));
        sb.append(",\n");
        sb.append("\tcd_hash " + tc.getLocalTypeByCode(4) + " NOT NULL,\n");
        sb.append("\tcd_flags " + tc.getLocalTypeByCode(12) + "(" + 20 + ")");
        sb.append(",\n");
        sb.append("\tcd_timestamp " + tc.getLocalTypeByCode(93) + " NOT NULL,\n");
        sb.append("\tcd_pre_calculated " + tc.getLocalTypeByCode(-7));
        if (dbmsType != 4) {
            sb.append(" DEFAULT 0");
        }
        sb.append(" NOT NULL,\n");
        if (options.fp_numberOfInts <= 0 || options.fp_numberOfEdges <= 0 || options.fp_numberOfOnes <= 0) {
            throw new IllegalArgumentException("fp_number options must be greater than 0 in StructureTableOptions");
        }
        int fpCount = options.fp_numberOfInts;
        if (options.structuralKeyConfig != null) {
            fpCount += options.structuralKeyConfig.getNumberOfIntegersNeeded();
        }
        for (int i = 1; i <= fpCount; ++i) {
            if (i > 1) {
                sb.append(",\n");
            }
            sb.append("\tcd_fp" + i + " " + tc.getLocalTypeByCode(4) + " NOT NULL");
        }
        String extraCols = options.extraColumnDefinitions;
        if (extraCols != null && (extraCols = extraCols.trim()).length() > 0) {
            if (!extraCols.startsWith(",")) {
                sb.append(',');
            }
            sb.append(extraCols);
        }
        sb.append("\n)\n");
        if (dbmsType == 3 && options.mysqlTableType != 0) {
            sb.append("ENGINE=");
            switch (options.mysqlTableType) {
                case 1: {
                    sb.append("INNODB;");
                    break;
                }
                case 2: {
                    sb.append("MyISAM;");
                    break;
                }
                default: {
                    throw new IllegalStateException("MySQL table type " + options.mysqlTableType + " is not supported");
                }
            }
        }
        return sb.toString();
    }

    private static String createCreateLogTableStatement(String tableName, DatabaseOptions dbOptions, Connection con, StructureTableOptions options) throws SQLException {
        TypeConverter tc = new TypeConverter(con);
        int dbmsType = DatabaseOptions.getDBMSType(con);
        StringBuffer sb = new StringBuffer("CREATE ");
        if (dbmsType == 8) {
            sb.append("CACHED ");
        }
        sb.append("TABLE " + tableName + " (update_id ");
        if (dbmsType == 4) {
            sb.append("counter NOT NULL PRIMARY KEY");
        } else {
            sb.append(TableInfo.getAutoIncrementIntDefinition(dbmsType, dbOptions, tc, tableName));
        }
        sb.append(", update_info ").append(tc.getLocalTypeByCode(12));
        sb.append("(").append(120).append(") NOT NULL,");
        sb.append("cache_id").append(" ").append(tc.getLocalTypeByCode(12));
        sb.append("(").append(32).append(") NOT NULL)\n");
        if (dbmsType == 3 && options != null && options.mysqlTableType != 0) {
            sb.append(" ENGINE=");
            switch (options.mysqlTableType) {
                case 1: {
                    sb.append("INNODB;");
                    break;
                }
                case 2: {
                    sb.append("MyISAM;");
                    break;
                }
                default: {
                    throw new IllegalStateException("MySQL table type " + options.mysqlTableType + " is not supported");
                }
            }
        }
        return sb.toString();
    }

    public static String createCreateIndexOnHashStatement(Connection con, String tableName) throws SQLException {
        int dotPos;
        String indexName = tableName;
        if (DatabaseOptions.getDBMSType(con) == 7 && (dotPos = tableName.indexOf(46)) != -1) {
            indexName = tableName.substring(dotPos + 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE INDEX " + indexName + "_hx ON " + tableName + " (" + "cd_hash" + ")");
        return sb.toString();
    }

    public static String createCreateIndexOnSortableFormulaStatement(Connection con, String tableName) throws SQLException {
        int dotPos;
        String indexName = tableName;
        if (DatabaseOptions.getDBMSType(con) == 7 && (dotPos = tableName.indexOf(46)) != -1) {
            indexName = tableName.substring(dotPos + 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE INDEX " + indexName + "_fx ON " + tableName + " (" + "cd_sortable_formula" + ")");
        return sb.toString();
    }

    public static String createCreateIndexOnPreCalculatedStatement(Connection con, String tableName) throws SQLException {
        int dotPos;
        String indexName = tableName;
        if (DatabaseOptions.getDBMSType(con) == 7 && (dotPos = tableName.indexOf(46)) != -1) {
            indexName = tableName.substring(dotPos + 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE INDEX " + indexName + "_px ON " + tableName + " (" + "cd_pre_calculated" + ")");
        return sb.toString();
    }

    public static String createCreateIndexOnCacheIdStatement(Connection con, String tableName) throws SQLException {
        int dotPos;
        String indexName = tableName;
        if (DatabaseOptions.getDBMSType(con) == 7 && (dotPos = tableName.indexOf(46)) != -1) {
            indexName = tableName.substring(dotPos + 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE INDEX " + indexName + "_cx ON " + TableInfo.getLogTableName(tableName) + " (" + "cache_id" + ")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executeSql(Connection con, String sql) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Execute SQL command: \n{0}", sql);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, TableInfo.stackTraceToString(new Throwable("This is not an exception.")));
                }
            }
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    public static String stackTraceToString(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        printWriter.print("This is not an error just an information where the hack we are:\n");
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static void decipherAndExecute(Connection con, String sqls, String tableName, String colName) throws SQLException {
        TableInfo.decipherAndExecute(con, sqls, tableName, colName, 1);
    }

    public static void decipherAndExecute(Connection con, String sqls, String tableName, String colName, int startValue) throws SQLException {
        int endIndex;
        if (sqls == null || sqls.trim().equals("")) {
            return;
        }
        sqls = StringUtil.replaceString(sqls, "{TABLE}", tableName);
        sqls = StringUtil.replaceString(sqls, "{START_VALUE}", Integer.toString(startValue));
        sqls = StringUtil.replaceString(sqls, "{COLUMN}", colName);
        String query = ";;";
        int beginIndex = 0;
        do {
            if ((endIndex = sqls.substring(beginIndex).indexOf(query)) == -1) {
                endIndex = sqls.length();
            }
            String sql = sqls.substring(beginIndex, endIndex);
            TableInfo.executeSql(con, sql);
        } while ((beginIndex = endIndex + query.length()) < sqls.length());
    }

    public static String getTableNameWithSchema(Connection con, String tableName) throws SQLException {
        String tName = tableName.trim();
        DatabaseMetaData dbmd = con.getMetaData();
        if (tName.indexOf(46) == -1 && dbmd.supportsSchemasInDataManipulation()) {
            String schemaPrefix = null;
            if (DatabaseOptions.getDBMSType(dbmd) == 7) {
                schemaPrefix = TableInfo.getPgSchemaName(con, tName);
                if (schemaPrefix == null) {
                    throw new SQLException("No schema name found. Please, contact support@chemaxon.com");
                }
            } else {
                try {
                    schemaPrefix = dbmd.getUserName().trim();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            String fullName = tName;
            if (schemaPrefix != null) {
                fullName = schemaPrefix + "." + fullName;
            }
            if (TableNames.isTable(con, fullName)) {
                tName = fullName;
            }
        }
        if (dbmd.storesUpperCaseIdentifiers()) {
            tName = tName.toUpperCase();
        } else if (dbmd.storesLowerCaseIdentifiers()) {
            tName = tName.toLowerCase();
        }
        return tName;
    }

    public static String getTableNameWithoutSchema(String tableName) {
        return tableName.substring(tableName.indexOf(".") + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPgSchemaName(Connection con, String tableName) throws SQLException {
        String sql = "SELECT nspname FROM pg_class c, pg_namespace n WHERE relnamespace = n.oid AND c.oid = (select '" + tableName + "'::regclass::oid)";
        Statement stmt = con.createStatement();
        try {
            ResultSet rs;
            block9: {
                String string;
                rs = stmt.executeQuery(sql);
                try {
                    if (rs.next()) break block9;
                    string = null;
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return string;
            }
            String schemaPrefix = rs.getString(1).trim();
            if (rs.next()) {
                throw new SQLException("Too many schema names returned. Please, contact support@chemaxon.com");
            }
            String string = schemaPrefix;
            rs.close();
            return string;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveCreationProperties(ConnectionHandler conh, StructureTableOptions options) throws SQLException {
        Connection con = conh.getConnection();
        String tableName = TableInfo.getTableNameWithSchema(con, options.name);
        boolean indexTable = options.cartridgeIndexTable;
        DatabaseProperties prop = new DatabaseProperties(conh, indexTable);
        TableInfo.setTableCreationTimestamp(conh, tableName, indexTable);
        TableInfo.resetTableValidityTimestamp(prop, tableName);
        prop.setTableProperty(tableName, "JChemVersion", String.valueOf(VersionInfo.JCHEM_VERSION));
        prop.setTableProperty(tableName, "tableType", String.valueOf(options.tableType));
        prop.setTableProperty(tableName, "standardizerConfig", options.standardizerConfig);
        prop.setTableProperty(tableName, "absoluteStereo", String.valueOf(options.absoluteStereo));
        prop.setTableProperty(tableName, "tautomerDuplicateFiltering", String.valueOf(options.tautomerDuplicateChecking));
        prop.setTableProperty(tableName, "duplicateFiltering", String.valueOf(options.duplicateFiltering));
        prop.setTableProperty(tableName, "switchOffAllProtections", String.valueOf(options.tautomerSwitchOffAllProtections));
        TableInfo.saveChemTermColNamesAndExprs(conh, prop, tableName, options.chemTermColsConfig);
        prop.setTableProperty(tableName, "version", String.valueOf(RegenerationChecker.deduceTableVersion(tableName, prop, 2)));
        prop.setTableProperty(tableName, "ctVersion", String.valueOf(RegenerationChecker.deduceTableVersion(tableName, prop, 1)));
        prop.setTableProperty(tableName, "mdVersion", String.valueOf(RegenerationChecker.deduceTableVersion(tableName, prop, 3)));
        String sql = "DELETE FROM " + conh.getPropertyTable() + " WHERE " + "prop_name" + " LIKE 'update." + tableName + ".%'";
        Statement stmt = con.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
        int structuralKeyColumnCount = 0;
        String structuralKeyConfig = null;
        if (options.structuralKeyConfig != null) {
            structuralKeyColumnCount = options.structuralKeyConfig.getNumberOfIntegersNeeded();
            structuralKeyConfig = options.structuralKeyConfig.getConfig();
        }
        FingerprintHandler.save(conh, tableName, options.fp_numberOfInts * 32, options.fp_numberOfOnes, options.fp_numberOfEdges, structuralKeyColumnCount, structuralKeyConfig);
    }

    public static boolean checkRequiredGeneralProperties(ConnectionHandler conh, boolean indexTable, String tableName) throws SQLException {
        DatabaseProperties dbProp = new DatabaseProperties(conh, indexTable);
        if (dbProp.getTableProperty(tableName, "tableType") == null) {
            return false;
        }
        if (dbProp.getTableProperty(tableName, "absoluteStereo") == null) {
            return false;
        }
        if (dbProp.getTableProperty(tableName, "tautomerDuplicateFiltering") == null) {
            return false;
        }
        if (dbProp.getTableProperty(tableName, "duplicateFiltering") == null) {
            return false;
        }
        return dbProp.getTableProperty(tableName, "switchOffAllProtections") != null;
    }

    public static void ensureRequiredGeneralProperties(ConnectionHandler conh, boolean indexTable, String tableName) throws SQLException {
        DatabaseProperties dbProp = new DatabaseProperties(conh, indexTable);
        TableInfo.ensureTableProperty(dbProp, tableName, "tableType", String.valueOf(2));
        TableInfo.ensureTableProperty(dbProp, tableName, "absoluteStereo", String.valueOf(true));
        TableInfo.ensureTableProperty(dbProp, tableName, "tautomerDuplicateFiltering", String.valueOf(false));
        TableInfo.ensureTableProperty(dbProp, tableName, "duplicateFiltering", String.valueOf(false));
        TableInfo.ensureTableProperty(dbProp, tableName, "switchOffAllProtections", String.valueOf(false));
    }

    private static void ensureTableProperty(DatabaseProperties dbProp, String tableName, String propName, String defaultValue) throws SQLException {
        if (dbProp.getTableProperty(tableName, propName) == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, propName + " property is missing for table " + tableName + ". " + "It is set to default value: " + defaultValue);
            }
            dbProp.setTableProperty(tableName, propName, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveChemTermColNamesAndExprs(ConnectionHandler conh, DatabaseProperties prop, String tableName, Map chemTermColsCfg) throws SQLException {
        String colName = null;
        String expression = null;
        if (chemTermColsCfg == null || chemTermColsCfg.isEmpty()) {
            return;
        }
        Iterator iter = chemTermColsCfg.keySet().iterator();
        try {
            Evaluator evaluator = new Evaluator();
            MolContext context = new MolContext();
            context.setMolecule(new MolHandler("C").getMolecule());
            while (iter.hasNext()) {
                colName = (String)iter.next();
                expression = (String)chemTermColsCfg.get(colName);
                String sql = "SELECT " + colName + " FROM " + tableName;
                Statement stmt = conh.getConnection().createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(sql);
                    rs.close();
                }
                catch (SQLException sqlE) {
                    throw new IllegalArgumentException("Column '" + colName + "' (to hold values for the Chemical Terms expression " + expression + ") does not seem to exist.");
                }
                finally {
                    stmt.close();
                }
                if (FieldInfo.isReservedColumnName(colName)) {
                    throw new IllegalArgumentException(colName + " is name of a JChem table column " + "reserved for internal use by JChem");
                }
                ChemJEP jep = evaluator.compile(expression, MolContext.class);
                UpdateHandler.checkChemTermColValue(jep.evaluate(context));
                prop.setChemTermForColumn(tableName, colName.toUpperCase(), expression);
            }
        }
        catch (ParseException pe) {
            if (colName == null) {
                throw new RuntimeException("Error creating Evaluator instance: " + pe.getMessage(), pe);
            }
            throw new IllegalArgumentException("Error while testing Chemical Terms '" + expression + "' for column '" + colName + "': " + pe.getMessage(), pe);
        }
        catch (MolFormatException mfe) {
            throw new RuntimeException(mfe.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Error with Chemical Terms evaluation for column " + colName + ": " + iae.getMessage(), iae);
        }
    }

    public static void createLogTable(Connection con, DatabaseOptions dbOptions, String tableName, StructureTableOptions options) throws SQLException {
        String tName = tableName.trim();
        String logTableName = TableInfo.getLogTableName(tName);
        String sqlCreateLogTable = TableInfo.createCreateLogTableStatement(logTableName, dbOptions, con, options);
        TableInfo.executeSql(con, sqlCreateLogTable);
        if (DatabaseOptions.getDBMSType(con) == 5) {
            TableInfo.createTriggerIfNeeded(con, dbOptions, logTableName, "update_id");
        }
        TableInfo.executeSql(con, TableInfo.createCreateIndexOnCacheIdStatement(con, tName));
    }

    public static void createTable(ConnectionHandler conh, StructureTableOptions options) throws SQLException {
        TableInfo.createTable(conh, options, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable(ConnectionHandler conh, StructureTableOptions options, String createTableSQL) throws SQLException, LicenseException {
        if (options.tableType == 3) {
            TableInfo.checkLicense();
        }
        if (options.tableType == 1 && (options.fp_numberOfInts <= 0 || options.fp_numberOfInts % 16 != 0)) {
            throw new IllegalArgumentException("Fingerprint length must be multiple of 16 integers (512 bits).");
        }
        DatabaseOptions dbOptions = DatabaseOptions.getFromDatabase(conh);
        Connection con = conh.getConnection();
        boolean isAutoCommit = con.getAutoCommit();
        int dbmsType = DatabaseOptions.getDBMSType(conh);
        String tableName = options.name = options.name.trim();
        int maxOracleTableNameLength = 25;
        if ((dbmsType == 1 || dbmsType == 10) && TableInfo.getTableNameWithoutSchema(tableName).length() > maxOracleTableNameLength) {
            throw new IllegalArgumentException("Table name '" + tableName + "' is too long. The maximum allowed length is " + maxOracleTableNameLength + ".");
        }
        if (dbmsType == 4 && options.tableType == 3) {
            throw new IllegalArgumentException("Markush table type is not allowed for Access dbms system");
        }
        if (dbmsType == 10) {
            throw new IllegalArgumentException("JChem does not support table creation for Composite Databases.");
        }
        if (createTableSQL == null) {
            createTableSQL = TableInfo.createCreateTableStatement(conh, options, dbOptions);
        }
        try {
            TableInfo.executeSql(con, createTableSQL);
            TableInfo.createLogTable(con, dbOptions, options.name, options);
        }
        catch (SQLException e) {
            if (dbmsType == 7 && !isAutoCommit) {
                con.rollback();
            }
            throw e;
        }
        TableInfo.createCacheRegistrationTableWithProperty(conh);
        try {
            con.setAutoCommit(true);
            String sqlCreateIndexOnHash = TableInfo.createCreateIndexOnHashStatement(conh.getConnection(), tableName);
            TableInfo.executeSql(con, sqlCreateIndexOnHash);
            String sqlCreateIndexOnSortableFormula = TableInfo.createCreateIndexOnSortableFormulaStatement(conh.getConnection(), tableName);
            TableInfo.executeSql(con, sqlCreateIndexOnSortableFormula);
            String sqlCreateIndexOnPreCalculated = TableInfo.createCreateIndexOnPreCalculatedStatement(conh.getConnection(), tableName);
            TableInfo.executeSql(con, sqlCreateIndexOnPreCalculated);
            TableInfo.createTriggerIfNeeded(con, dbOptions, tableName, "cd_id");
            if (dbmsType == 1) {
                String sql = "CREATE SEQUENCE " + tableName + "_USQ " + "INCREMENT BY 1 START WITH 2";
                Statement stmt = con.createStatement();
                try {
                    stmt.execute(sql);
                }
                finally {
                    stmt.close();
                }
            }
            TableInfo.saveCreationProperties(conh, options);
            if (options.tableType == 3) {
                MarkushTableInfo.upgradeMarkushDescriptorTables(conh, tableName);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            try {
                TableInfo.deleteTable(conh, tableName);
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw new RuntimeException(ex);
        }
        finally {
            if (!isAutoCommit) {
                con.setAutoCommit(false);
            }
        }
    }

    public static void createTriggerIfNeeded(Connection con, DatabaseOptions dbOptions, String tableName, String column) throws SQLException {
        if (dbOptions.isAutoIncrementProperty && dbOptions.isAutoIncrementByTrigger) {
            try {
                int dbmsType = DatabaseOptions.getDBMSType(con);
                String sql = dbmsType == 1 ? "CREATE SEQUENCE {TABLE}_SQ\nINCREMENT BY 1 START WITH {START_VALUE};;\n\nCREATE TRIGGER {TABLE}_TR\n   BEFORE INSERT OR UPDATE ON {TABLE}\n   FOR EACH ROW\n   DECLARE\n       ICOUNTER {TABLE}.{COLUMN}%TYPE;\n       ICURRENT {TABLE}.{COLUMN}%TYPE;\n       CANNOT_CHANGE_VALUE EXCEPTION;\n   BEGIN\n       IF INSERTING THEN\n           IF :NEW.{COLUMN} IS NULL THEN\n               SELECT {TABLE}_SQ.NEXTVAL INTO ICOUNTER FROM DUAL;\n               :NEW.{COLUMN} := ICOUNTER;\n           ELSE\n               BEGIN\n                   SELECT {TABLE}_SQ.CURRVAL INTO ICURRENT FROM DUAL;\n               EXCEPTION\n                   WHEN OTHERS THEN      /* ON FIRST RUN NO CURRVAL AVAILABLE */\n                       SELECT {TABLE}_SQ.NEXTVAL INTO ICURRENT FROM DUAL;\n               END;\n               IF :NEW.{COLUMN} > ICURRENT THEN\n                   LOOP\n                       SELECT {TABLE}_SQ.NEXTVAL INTO ICOUNTER FROM DUAL;\n                       EXIT WHEN :NEW.{COLUMN} <= ICOUNTER;\n                   END LOOP;\n               END IF;\n           END IF;\n       END IF;\n       IF UPDATING THEN\n           IF NOT (:NEW.{COLUMN} = :OLD.{COLUMN}) THEN\n               RAISE CANNOT_CHANGE_VALUE;\n           END IF;\n       END IF;\n   EXCEPTION\n       WHEN CANNOT_CHANGE_VALUE THEN\n           RAISE_APPLICATION_ERROR(-20000, 'CANNOT CHANGE {TABLE}.{COLUMN} VALUE');\n   END;\n" : (dbmsType == 5 ? "CREATE GENERATOR GEN_{TABLE}_{COLUMN}" : dbOptions.autoIncrementTriggerCreation);
                TableInfo.decipherAndExecute(con, sql, tableName, column);
            }
            catch (SQLException e) {
                System.err.println("Auto-increment trigger creation failed");
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTable(ConnectionHandler conh, String tableName) throws SQLException {
        block25: {
            Connection con = conh.getConnection();
            int dbmsType = DatabaseOptions.getDBMSType(conh);
            if (dbmsType == 10) {
                throw new IllegalArgumentException("JChem does not support drop table for Composite Databases.");
            }
            boolean isAutoCommit = con.getAutoCommit();
            String errorText = "";
            try {
                block24: {
                    con.setAutoCommit(true);
                    try {
                        MDTableHandler mdth = new MDTableHandler(conh, tableName);
                        String[] mdTables = mdth.getMDTables();
                        for (int x = 0; x < mdTables.length; ++x) {
                            DBUtil.dropTable(con, mdTables[x]);
                        }
                    }
                    catch (SQLException e) {
                        errorText = errorText + "Descriptor table cleanup failed for table " + tableName + " .\n";
                    }
                    try {
                        TableInfo.cleanupTrigger(conh, tableName, "cd_id");
                    }
                    catch (Exception e) {
                        errorText = errorText + "Trigger cleanup failed for table " + tableName + " .\n";
                    }
                    try {
                        if (dbmsType != 1) break block24;
                        String sql = "DROP SEQUENCE " + tableName + "_USQ";
                        Statement stmt = con.createStatement();
                        try {
                            stmt.execute(sql);
                        }
                        finally {
                            stmt.close();
                        }
                    }
                    catch (Exception e) {
                        errorText = errorText + "Sequence cleanup failed for table " + tableName + " .\n";
                    }
                }
                try {
                    String logTableName = TableInfo.getLogTableName(tableName);
                    DBUtil.dropTable(con, logTableName);
                    if (dbmsType == 5) {
                        TableInfo.cleanupTrigger(conh, logTableName, "update_id");
                    }
                }
                catch (Exception e) {
                    errorText = errorText + "Log table cleanup failed for table " + tableName + " .\n";
                }
                DBUtil.dropTable(con, tableName);
                if (errorText != null && errorText.length() > 0) {
                    System.err.println(errorText);
                }
                DatabaseProperties dbProps = new DatabaseProperties(conh, false);
                dbProps.deleteTableProperties(tableName);
                if (dbmsType != 7) break block25;
                try {
                    Statement s = con.createStatement();
                    try {
                        s.executeUpdate("drop sequence " + tableName + "_cd_id_seq");
                    }
                    finally {
                        s.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            finally {
                if (!isAutoCommit) {
                    con.setAutoCommit(false);
                }
            }
        }
    }

    public static String getJChemVersion(ConnectionHandler ch, String tableName) throws SQLException {
        DatabaseProperties dp = new DatabaseProperties(ch);
        String version = dp.getTableProperty(tableName, "JChemVersion");
        if (version == null) {
            version = "";
        }
        return version;
    }

    public static int getTableVersion(ConnectionHandler ch, String tableName) throws SQLException {
        return TableInfo.getTableVersion(ch, tableName, false);
    }

    public static int getTableVersion(ConnectionHandler ch, String tableName, boolean indexTable) throws SQLException {
        DatabaseProperties dp = new DatabaseProperties(ch, indexTable);
        String versionString = dp.getTableProperty(tableName, "version");
        int version = 0;
        version = versionString == null ? -1 : Integer.parseInt(versionString);
        return version;
    }

    public static String getTableValidityTimestamp(DatabaseProperties dbProp, String tableName) throws SQLException {
        return dbProp.getTableProperty(tableName, "validityTimestamp");
    }

    public static void resetTableValidityTimestamp(DatabaseProperties dbProp, String tableName) throws SQLException {
        String timeString = new Timestamp(System.currentTimeMillis()).toString();
        dbProp.setTableProperty(tableName, "validityTimestamp", timeString);
    }

    public static void setTableCreationTimestamp(ConnectionHandler ch, String tableName, boolean indexTable) throws SQLException {
        DatabaseProperties dp = new DatabaseProperties(ch, indexTable);
        String timeString = new Timestamp(System.currentTimeMillis()).toString();
        dp.setTableProperty(tableName, "creationTime", timeString);
    }

    public static boolean checkTimeStamp(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    public static String getStandardizerConfig(ConnectionHandler ch, String tableName) throws SQLException {
        return TableInfo.getStandardizerConfig(ch, tableName, false);
    }

    public static String getStandardizerConfig(ConnectionHandler ch, String tableName, boolean indexTable) throws SQLException {
        DatabaseProperties dp = new DatabaseProperties(ch, indexTable);
        return dp.getTableProperty(tableName, "standardizerConfig");
    }

    public static Standardizer getStandardizer(ConnectionHandler ch, String tableName) throws SQLException, StandardizerException {
        return TableInfo.getStandardizer(ch, tableName, false);
    }

    public static Standardizer getStandardizer(ConnectionHandler ch, String tableName, boolean indexTable) throws SQLException, StandardizerException {
        return TableInfo.getStandardizers(ch, tableName, indexTable, 1)[0];
    }

    public static Standardizer[] getStandardizers(ConnectionHandler ch, String tableName, boolean indexTable, int count) throws SQLException, StandardizerException {
        Standardizer[] standardizers = new Standardizer[count];
        String standardizerConfig = TableInfo.getStandardizerConfig(ch, tableName, indexTable);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("standardizerConfig=" + standardizerConfig);
        }
        for (int x = 0; x < count; ++x) {
            standardizers[x] = standardizerConfig != null ? new Standardizer(standardizerConfig) : new Standardizer(DEFAULT_STANDARDIZER_CONFIG);
        }
        return standardizers;
    }

    public static void standardize(Molecule mol, Standardizer standardizer, boolean optionals) {
        if (standardizer != null) {
            try {
                if (optionals) {
                    standardizer.setActiveGroup("target");
                    standardizer.removeInactiveTasks("removeexplicith");
                } else {
                    standardizer.setActiveGroup("query");
                    standardizer.addInactiveTasks("removeexplicith");
                }
                standardizer.standardize(mol);
            }
            catch (SearchException e) {
                e.printStackTrace();
            }
        } else {
            if (optionals) {
                mol.implicitizeHydrogens(0);
            }
            mol.aromatize();
        }
    }

    public static void standardize(MolHandler mh, Standardizer standardizer, boolean optionals) {
        Molecule mol = mh.getMolecule();
        TableInfo.standardize(mol, standardizer, optionals);
    }

    private static void cleanupTrigger(ConnectionHandler conh, String tableName, String columnName) throws SQLException {
        Connection con = conh.getConnection();
        DatabaseOptions dbOptions = DatabaseOptions.getFromDatabase(conh);
        if (dbOptions.isAutoIncrementProperty && dbOptions.isAutoIncrementByTrigger) {
            int dbmsType = DatabaseOptions.getDBMSType(con);
            String sql = dbmsType == 1 ? "DROP TRIGGER {TABLE}_TR;;\nDROP SEQUENCE {TABLE}_SQ\n" : (dbmsType == 5 ? "DELETE FROM RDB$GENERATORS\n WHERE RDB$GENERATOR_NAME = 'GEN_{TABLE}_{COLUMN}'" : dbOptions.autoIncrementTriggerCleanup);
            TableInfo.decipherAndExecute(con, sql, tableName, columnName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsColumn(ConnectionHandler conh, String tName, String colName) throws SQLException {
        Connection con = conh.getConnection();
        String sql = "SELECT * from " + tName + " where 1=2";
        boolean found = false;
        Statement stmt = con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                int count = rsmd.getColumnCount();
                for (int x = 0; x < count; ++x) {
                    String name = rsmd.getColumnName(x + 1);
                    if (!name.equalsIgnoreCase(colName)) continue;
                    found = true;
                    break;
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return found;
    }

    public static boolean hasLogTable(ConnectionHandler conh, String tName) throws SQLException {
        Connection con = conh.getConnection();
        String sql = "SELECT * from " + TableInfo.getLogTableName(tName) + " where 1=2";
        Statement stmt = con.createStatement();
        boolean success = true;
        try {
            stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            success = false;
        }
        stmt.close();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLogTableColumns(ConnectionHandler conh, String tableName) throws SQLException {
        ArrayList<String> columns = new ArrayList<String>();
        String sql = "SELECT * from " + TableInfo.getLogTableName(tableName) + " where 1=2";
        try {
            Statement stmt = conh.getConnection().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(sql);
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
                        columns.add(rsmd.getColumnName(i).toLowerCase());
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            return null;
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTableExists(ConnectionHandler conh, String tableName) throws SQLException {
        String sql = "SELECT * FROM " + tableName + " WHERE 1 = 2";
        Statement stmt = conh.getConnection().createStatement();
        try {
            stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            stmt.close();
        }
        return true;
    }

    public static String getLogTableName(String jchemTableName) {
        return jchemTableName + "_UL";
    }

    static boolean hasOnlyMustFragmentForScreen(int tableType) {
        return tableType == 4 || tableType == 2;
    }

    static boolean isFPusedinHashCode(int tableType) {
        boolean notUsed = tableType == 3 || tableType == 1;
        return !notUsed;
    }
}

