/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.util.ConnectionHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class TableNames {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTable(Connection con, String table) throws SQLException {
        boolean success = true;
        Statement stmt = con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + table + " WHERE 1=2");
            rs.close();
        }
        catch (SQLException e) {
            success = false;
        }
        finally {
            stmt.close();
        }
        return success;
    }

    public static Iterator<String> iterator(ConnectionHandler conh) throws SQLException {
        return TableNames.iterator(conh, null);
    }

    public static Iterator<String> iterator(ConnectionHandler conh, ProgressWriter pw) throws SQLException {
        return new TableNameIterator(conh, pw);
    }

    static class TableNameIterator
    implements Iterator<String> {
        private final Iterator<String> tableNames;
        private final ProgressWriter pw;

        TableNameIterator(ConnectionHandler conh) throws SQLException {
            this(conh, null);
        }

        TableNameIterator(ConnectionHandler conh, ProgressWriter pw) throws SQLException {
            this.pw = pw;
            Vector<String> names = new DatabaseProperties(conh).getStructureTableNames();
            if (pw != null) {
                pw.reset();
                pw.setMaximum(names.size());
            }
            this.tableNames = names.iterator();
        }

        @Override
        public String next() throws NoSuchElementException {
            if (this.pw != null) {
                if (this.pw.isCanceled()) {
                    throw new NoSuchElementException();
                }
                this.pw.setProgress(this.pw.getProgress() + 1L);
            }
            return this.tableNames.next();
        }

        @Override
        public boolean hasNext() {
            return this.tableNames.hasNext();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

