/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.formats.MdlCompressor;
import chemaxon.formats.MolInputStream;
import chemaxon.util.DatabaseTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TableReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStructureSource(Connection con, String tableName, int cd_id) throws SQLException {
        String source = null;
        String sql = "SELECT cd_structure FROM " + tableName + " WHERE cd_id = " + cd_id;
        Statement stmt = con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                if (rs.next()) {
                    byte[] bytes = DatabaseTools.readBytes(rs, 1);
                    try {
                        bytes = TableReader.decompressIfNeeded(bytes);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return source;
    }

    private static byte[] decompressIfNeeded(byte[] bytes) throws IOException {
        String formatString = new MolInputStream(new ByteArrayInputStream(bytes)).getFormat();
        if (formatString.startsWith("csmol") || formatString.startsWith("cssdf") || formatString.startsWith("csrdf") || formatString.startsWith("csrxn")) {
            bytes = MdlCompressor.convert(bytes, MdlCompressor.DECOMPRESS);
        }
        return bytes;
    }
}

